<!DOCTYPE html>
<html lang="en">
<head>
<#include "../include/meta.ftl">
<#include "../include/head.ftl">
<#include "../include/ie8fix.ftl">

    <link href="${p_static}${_v('/goods/css/global.css')}" rel="stylesheet" type="text/css"/>
    <link href="${p_static}${_v('/goods/css/productDetailsSecKill.css')}" rel="stylesheet" type="text/css"/>
    <title>活动商品库存信息</title>
</head>
<body>
</body>
<script>

    //格式化代码函数,已经用原生方式写好了不需要改动,直接引用就好
    var formatJson = function (json, options) {
        var reg = null,
                formatted = '',
                pad = 0,
                PADDING = '    ';
        options = options || {};
        options.newlineAfterColonIfBeforeBraceOrBracket = (options.newlineAfterColonIfBeforeBraceOrBracket === true) ? true : false;
        options.spaceAfterColon = (options.spaceAfterColon === false) ? false : true;
        if (typeof json !== 'string') {
            json = JSON.stringify(json);
        } else {
            json = JSON.parse(json);
            json = JSON.stringify(json);
        }
        reg = /([\{\}])/g;
        json = json.replace(reg, '\r\n$1\r\n');
        reg = /([\[\]])/g;
        json = json.replace(reg, '\r\n$1\r\n');
        reg = /(\,)/g;
        json = json.replace(reg, '$1\r\n');
        reg = /(\r\n\r\n)/g;
        json = json.replace(reg, '\r\n');
        reg = /\r\n\,/g;
        json = json.replace(reg, ',');
        if (!options.newlineAfterColonIfBeforeBraceOrBracket) {
            reg = /\:\r\n\{/g;
            json = json.replace(reg, ':{');
            reg = /\:\r\n\[/g;
            json = json.replace(reg, ':[');
        }
        if (options.spaceAfterColon) {
            reg = /\:/g;
            json = json.replace(reg, ':');
        }
        (json.split('\r\n')).forEach(function (node, index) {
                    var i = 0,
                            indent = 0,
                            padding = '';

                    if (node.match(/\{$/) || node.match(/\[$/)) {
                        indent = 1;
                    } else if (node.match(/\}/) || node.match(/\]/)) {
                        if (pad !== 0) {
                            pad -= 1;
                        }
                    } else {
                        indent = 0;
                    }

                    for (i = 0; i < pad; i++) {
                        padding += PADDING;
                    }

                    formatted += padding + node + '\r\n';
                    pad += indent;
                }
        );
        return formatted;
    };

    $(function(){
        $.ajax({
            type: "post",
            dataType: "json",
            url: "viewStock",
            success: function(rsp){
                var data = formatJson(rsp);
                $("body").append("<pre>" + data + "</pre>");
            },
            error: function(XMLHttpRequest, textStatus, errorThrown){
                if (textStatus == 'error') {
                    $("body").html("系统异常");
                }
            }
        });
    });
</script>
</html>