<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="renderer" content="webkit">
<#include "/include/meta.ftl">
<#include "/include/head.ftl">
<#include "/include/ie8fix.ftl">
    <link href="${p_static}${_v('/index/css/rank.css')}" rel="stylesheet" type="text/css"/>
    <link href="${p_static}${_v('/index/css/global.css')}" rel="stylesheet" type="text/css"/>
    <link href="${p_static}${_v('/index/css/index.css')}" rel="stylesheet" type="text/css"/>
    <title>排行榜</title>
</head>
<body style="background-color:#ffe2e6">
<#include "/include/header.ftl">

<image class="rank_bg1" src="${p_static}${_v('/index/image/rank_bg3.jpg')}" alt="排行榜"/>
<!--排行榜-->
<div class="ranklist pageWidth scrollTopH">
    <div class="rightNav">
        <ul class="rightList">
            <li title="购物车"><a href="/score/myCart"><i class="iconfont icon">&#xe61c;</i></a></li>
            <li title="我的足迹"><a href="/score/order/myFootprints"><i class="iconfont icon">&#xe616;</i></a></li>
            <li title="我的收藏"><a href="/score/order/myCollections"><i class="iconfont icon">&#xe615;</i></a></li>
            <li class="scrollTop" title="返回顶部"><i class="iconfont icon">&#xe61b;</i></li>
        </ul>
    </div>
    <ul class="ranklist-title clearfix">
        <li class="ranklist-title-list fl <#if 'total'==  type?default("")> hover </#if>">
            <i class="iconfont rank-icon">&#xe62c;</i>
            <span><a href="salesRanking?type=total">总排行 </a></span>
        </li>
        <li class="ranklist-title-list fl <#if 'month'== type?default("")> hover </#if>">
            <i class="iconfont rank-icon">&#xe62c;</i>
            <span><a href="salesRanking?type=month">月排行</a></span>
        </li>
        <li class="ranklist-title-list fl <#if 'week'== type?default("")> hover </#if>">
            <i class="iconfont rank-icon">&#xe62c;</i>
            <span><a href="salesRanking?type=week">周排行</a></span>
        </li>
    </ul>
    <div class="ranklist-body">
        <ul class="ranklist-body-title clearfix">
            <li class="ranklist-body-title-list fl">排名</li>
            <li class="ranklist-body-title-list fl">商品</li>
            <li class="ranklist-body-title-list fl">价格</li>
        </ul>
        <div class="ranklist-body-container">
        <#if salesRanking??>
            <#list salesRanking as good>
                <#if good_index+1<=3 >
                    <div class="ranklist-body-goods">
                        <!--排名-->
                        <div class="ranklist-body-goods-prize fl clearfix medal">
                            <img class="prize-img" src="${p_static}/${_v('index/image/rank_${(good_index+1)}.png')}"
                                 alt=""/>
                            <span class="prize-text">${(good_index+1)}</span>
                        </div>
                        <!--礼品条件-->
                        <div class="ranklist-body-goods-conditions fl clearfix">

                            <#if good.getGoodsPictures()??>
                                <img class="gift" src="${good.getGoodsPictures()[0].picturePath}" alt=""/>
                            </#if>

                            <span class="gift-desc"><a
                                    href="/score/goodsdetails?goodsId=${good.id}">${good.name}</a></span>
                        </div>
                        <!--积分-->
                        <div class="ranklist-body-goods-point fl clearfix">
                            <span class="point"> ${(good.salePrice*scorePortion!)?string("0.00")}</span>
                        </div>
                    </div>
                <#else>
                    <div class="ranklist-body-goods">
                        <!--排名-->
                        <div class="ranklist-body-goods-prize fl clearfix">
                            <#if good_index<3>
                                <img class="prize-img" src="${p_static}/${_v('index/image/rank_${(good_index+1)}.png')}"
                                     alt=""/>
                            <#else >
                                <span class="prize-text">${(good_index+1)}</span>
                            </#if>

                        </div>
                        <!--礼品条件-->
                        <div class="ranklist-body-goods-conditions fl clearfix">
                            <#if good.getGoodsPictures()??>
                                <img class="gift" src="${good.getGoodsPictures()[0].picturePath}" alt=""/>
                            </#if>

                            <span class="gift-desc"><a
                                    href="/score/goodsdetails?goodsId=${good.id}">${good.name}</a></span>
                        </div>
                        <!--积分-->
                        <div class="ranklist-body-goods-point fl clearfix">
                            <span class="point"> ${(good.salePrice*scorePortion!)?string("0.00")}</span>
                        </div>
                    </div>
                </#if>
            </#list>
        </#if>

        </div>

    </div>
</div>
<div class="rank-bottom">
    <img class="rank_bg2" src="${p_static}/${_v('index/image/rank_bg2.png')}" alt=""/>
</div>
<#include "/include/footer.ftl">
</body>

<script src="${p_static}${_v('/index/js/rank.js')}"></script>
<#include "/include/resource.ftl">
<script src="${p_static}${_v('/index/js/index.js')}"></script>
<script>
</script>
<script src="${c_static}${_v('/common/js/scrollTop.js')}"></script>
<script type="text/javascript">
    function add(pageId) {
        $('.headerNav').find('a').each(function () {
            var navId = $(this).attr('data-id');
            if (pageId == navId) {
                $(this).addClass('currentPage');
            }
        })
    }

    window.onload = add("3");
</script>
</html>