<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="renderer" content="webkit">

    <link href="${c_static}${_v('/plugins/scoreFonts/iconfont.css')}" rel="stylesheet" type="text/css"/>
    <link href="${p_static}${_v('/login/member/css/global.css')}" rel="stylesheet" type="text/css"/>
    <link href="${p_static}${_v('/login/member/css/login.css')}" rel="stylesheet" type="text/css"/>
    <link rel="shortcut icon" type="image/x-icon" href="${c_static}${_v('/common/images/favicon.ico')}"/>

    <title>登录</title>
</head>
<body is-login-page="true">

<div class="loginPage">
    <div class="pageWidth clearfix">
        <div class="logoTitle clearfix">
            <img src="${p_static}${_v('/common/images/headLogo.jpg')}" class="fl"/>
        </div>
    </div>
    <div class="conBg">
        <div class="pageWidth clearfix">
            <form class="loginForm fr" action="${ctx}/dologin" method="post">
                <h2 class="loginTitle"><img src="${ctx}/login/member/image/loginLogo.png"/><span>商城登录</span></h2>
                <div class="loginInput">
                    <div class="inputCon clearfix">
                        <label class="inputName fl"><span class="justifyText">用户名</span>：</label>
                        <input type="text" placeholder="请输入手机号或邮箱" class="userInput fl"
                               maxlength="50" type="text" name="account" value="${account!}"/>
                    </div>
                    <p class="errorBack">${accountError!}</p>
                </div>
                <div class="loginInput">
                    <div class="inputCon clearfix">
                        <label class="inputName fl"><span class="justifyText">密码</span>：</label>
                        <input type="password" placeholder="请输入密码" class="passwordInput fl"
                               <#--maxlength="13" minlength="6"--> type="password" name="password"/>
                    </div>
                    <p class="errorBack">${passwordError!}</p>
                </div>

<#if validateFlag ?? && validateFlag==1 >
                <input type="hidden" value="${validateFlag!}" name="validateFlag" id="validateFlag" />
                <div class="loginInput">
                    <div class="clearfix codeCon">
                        <label class="inputName fl"><span class="justifyText">验证码</span>：</label>
                        <input type="text" placeholder="请输入验证码" class="codeInput fl" name="validateCode"  maxlength="6"/>
                        <label class="fr codeImgLabel">
                            <img style="cursor: pointer;" src="${ctx}/kaptcha/image?type=login" onclick="this.src='${ctx}/kaptcha/image?type=login&dt='+Math.random()"/>
                        </label>
                    </div>
                    <p class="errorBack">${imageCodeError!}</p>
                </div>
</#if>

                <a href="javascript:void(0)" class="forgetPassword">忘记密码？</a>
                <input type="button" value="登录" onclick="loginFormSubmit()"/>
            </form>
        </div>
    </div>


    <#--找回密码-->

    <div class="login-mask">
        <div class="forgetPwd-wrap clearfix">
            <h1 class="popUp-title">找回密码</h1>
            <div class="progress-wrap clearfix">
                <#--<p class="progress-bar"></p>-->
                <p class="progressImg">
                    <img class="progressFirst" src="${ctx}/login/member/image/firstStep.png" alt="">
                    <img class="progressSecond" src="${ctx}/login/member/image/secondStep.png" alt="">
                    <img class="progressThird" src="${ctx}/login/member/image/thirdStep.png" alt="">
                </p>
                <#--<span class="progress-step first-step">1</span>-->
                <#--<p class="progress-finished first"></p>-->
                <#--<span class="progress-text userer-identify">身份验证</span>-->
                <#--<span class="progress-step second-step">2</span>-->
                <#--<p class="progress-finished second"></p>-->
                <#--<span class="progress-text password-reset">重设密码</span>-->
                <#--<span class="progress-step third-step">3</span>-->
                <#--<p class="progress-finished third"></p>-->
                <#--<span class="progress-text identify-complish">完成</span>-->
            </div>
            <!--第一步-->
            <form class="form-findPwd form-identify">
                <!--手机号码-->
                <div class="loginInput mt-20 clearfix">
                    <label class="label-userName" for="userName">登录名：</label>
                    <input class="userName" id="userName" type="text" placeholder="请输入您登录的手机号码或邮箱" maxlength="30"/>
                </div>

                <!--图片验证码-->
                <div class="loginInput mt-30 clearfix">
                    <label class="label-pic-code" for="pic-code">图片验证码：</label>
                    <input class="pic-code" id="pic-code" type="text" placeholder="请输入图片验证码"/>
                    <img class="captcha" style="cursor: pointer;" id="updatePasswdImageCode" src="${ctx}/kaptcha/image?type=updatePasswd" onclick="this.src='${ctx}/kaptcha/image?type=updatePasswd&dt='+Math.random()"/>
                    <a onclick="$('#updatePasswdImageCode')[0].src='${ctx}/kaptcha/image?type=updatePasswd&dt='+Math.random()" class="captcha-change">换一张</a>
                </div>
                <!--验证码-->
                <div class="loginInput mt-30 clearfix">
                    <label class="label-identify-code" for="identify-code">验证码：</label>
                    <input class="identify-code" id="identify-code" type="text" placeholder="请输入验证码"/>
                    <button class="code-send" type="button">发送验证码</button>
                </div>
                <!--下一步-->
                <button type="button" class="button-next">下一步</button>
                <a class="retToLogin">返回登录</a>
            </form>
            <!--第二步-->
            <form class="form-findPwd clearfix form-resetPwd">
                <!--新密码-->
                <div class="loginInput mt-50 clearfix">
                    <label class="label-newPwd" for="newPwd">新密码：</label>
                    <input class="newPwd" id="newPwd" type="password" placeholder="请输入6-13位包含英文和数字的密码" minlength="6" maxlength="13" onblur=""/>
                </div>
                <!--确认密码-->
                <div class="loginInput mt-20 clearfix">
                    <label class="label-confirmPwd" for="confirmPwd">确认密码：</label>
                    <input class="confirmPwd" id="confirmPwd" type="password" placeholder="请输入确认密码" minlength="6" maxlength="13"/>
                </div>
                <!--下一步-->
                <button type="button" class="button-next">下一步</button>
                <a href="javascript:void(0)" class="retToLogin">返回登录</a>
            </form>
            <!--第三步-->
            <form class="form-findPwd form-accomplish clearfix">
                <div class="accomplish-text-container clearfix">
                    <i class="iconfont icon-success fl">&#xe630;</i>
					<span class="accomplish-box fl">
						<p>尊敬的用户您好！</p>
						<span class="toLogin" href="javascript:void(0)">您修改密码已成功，请重新登录！</span>
					</span>
                </div>
                <button type="button" class="button-next">登录</button>
            </form>
            <i class="icon-close iconfont">&#xe637;</i>
        </div>
    </div>
</div>
<script type="text/javascript" src="${c_static}${_v('/plugins/js/jquery1.11.2.min.js')}"></script>
<script type="text/javascript" src="${c_static}${_v('/plugins/js/jquery.placeholder.min.js')}"></script>
<script type="text/javascript" src="${p_static}${_v('/login/member/js/formCheck.js')}"></script>
</body>
</html>