/**
 * Created by Administrator on 2016/10/28.
 */

/**
 * 判断是否至少有1个购物车记录已被选择
 */
var isCartItemIdsChecked = function () {
    var hasChecked = false;
    $('.cart-item-cb').each(function () {
        if ($(this).is(":checked") || $(this).attr('checked')) {
            hasChecked = true;
        }
    });
    return hasChecked;
};

var hasUnvalidItems = function () {
    var invalidList = $('.invalidList');
    if (invalidList && invalidList.length > 0) {
        return true;
    }

    return false;
};

/**
 * 修改购物车商品购买数量
 * @param params
 */
var cartItemChangeCounts = function (params) {
    loginValidate(cartItemChangeCounts_logined, params);
}
var cartItemChangeCounts_logined = function (params) {
    var cartItemId = params.cartItemId;
    var counts = params.counts;
    var sucFunc = params.success;
    var errorFunc = params.error;
    var beforeSend = params.beforeSend;
    var isDebug = params.debug;
    var thisObject = params.thisObject;
    $.ajax({
        url: "/score/myCart/carItem/changeCounts.json",
        type: "POST",
        dataType: "json",
        data: {
            cartItemId: cartItemId,
            counts: counts,
            areaCode: $('#areaCode').val(),
            debug: isDebug ? isDebug : null
        },
        beforeSend: function () {
            showLoading();
            if (isDebug) {
                if (typeof console.info != 'undefined') {
                    console.info("cartItemChangeCounts beforeSend");
                }
            }
            if (beforeSend && (typeof beforeSend).toLowerCase() == 'function') {
                beforeSend();
            }
        },
        success: function (result) {
            hideLoading();
            //console.debug(result);
            if (isDebug) {
                if (typeof console.info != 'undefined') {
                    console.info("result: %o", result);
                }
            }
            if (result.status == "success") {
                sucFunc(result.data);
                if (parseInt(thisObject.val()) > 199) {
                    thisObject.val(199);
                    $('.alertLayer').find('.insuredTips').text('商品数量只能选择1-199');
                    $('.alertLayer').show();
                    itemNumsChanged_logined(thisObject);
                }
            } else {
                errorFunc(result.error, result.message, result.data);
            }
        },
        error: function (jqXHR, textStatus, errorThrown) {
            hideLoading();
            if (isDebug) {
                if (typeof console.info != 'undefined') {
                    console.info("Ajax Error: [%s], error: [%s], jqXHR: [%o]", textStatus, errorThrown, jqXHR);
                }
            }
            if (errorFunc && (typeof errorFunc).toLowerCase() == 'function') {
                errorFunc(textStatus, errorThrown, null);
            }

        }
    });
};

/**
 * 购物车商品移入收藏夹
 * @param params
 */
var moveItemToFav = function (params) {
    loginValidate(moveItemToFav_logined, params);
}
var moveItemToFav_logined = function (params) {
    var ids = params.ids;
    var beforeSend = params.beforeSend;
    var success = params.success;
    var error = params.error;
    if (typeof ids == 'string') {
        ids = ids.split(',');
    }

    $.ajax({
        url: "/score/myCart/carItem/favAdd.json",
        type: "POST",
        dataType: "json",
        data: {
            cartItemId: ids.join(","),
            random: Math.random()
        },
        beforeSend: function () {
            if ((typeof beforeSend).toLowerCase() == 'function') {
                beforeSend();
            }
        },
        success: function (result) {
            //console.debug("result: %o", result);
            /** 删除成功后，修改页面显示 */
            if (result.status == 0 || result.status == "0" || result.status == "success") {
                if (result.data) {
                    updateCartShow(result.data);
                    if ((typeof success).toLowerCase() == 'function') {
                        success(result.data);
                    }
                }
                $(document).on('click', '.doMoveToFav', addSelectedToFavOnClick);
                $(document).trigger("RefreshTopInfo");
            } else {
                if ((typeof sucess).toLowerCase() == 'function') {
                    error(result.data.error, result.data.message ? result.data.message : result.data.msg);
                }
                console.error("Ajax Error: [%s], message: [%s]", result.data.error, result.data.message);
            }

        },
        error: function (jqXHR, textStatus, errorThrown) {
            if ((typeof sucess).toLowerCase() == 'function') {
                error(textStatus, "AjaxRequestError: " + errorThrown);
            }
            console.error("Ajax Error: [%s], error: [%s], jqXHR: [%o]", textStatus, errorThrown, jqXHR);
        }
    });

};

/** 购物车商品件数减少按钮 START */
var numReduceOnClickFunc = function () {
    var $this = $(this);
    var $root = $this.parents(".modelList[data-cart-item-id]");
    if (!$root.hasClass('invalidList')) {
        var cartItemId = $root.attr('data-cart-item-id');
        var numInput = $this.parents('.numChoose').find('.cart-item-counts');
        var numEdit = $this.parents('.numChoose').find('.numEdit');
        var num = parseInt(numInput.val());
        if (num > 1) {
            num = num - 1;
        }
        var oldNum = parseInt(numInput.val());
        var oldSumCartItems = parseInt($('#sum-cart-item-counts').text());

        cartItemChangeCounts({
            thisObject:$this,
            cartItemId: cartItemId,
            counts: num,
            isDebug: true,
            beforeSend: function () {
                //$(document).off('click','.numReduce', numReduceOnClickFunc);
                showLoading();
            },
            success: function (data) {
                $(this).parents('.deletLayer').attr("rel", "");
                /** 修改成功后，修改页面显示 */
                if (data) {
                    if (data) {
                        updateCartShow(data);
                        //numSpan.text(num);
                        numEdit.val(num);
                        numInput.val(num);
                        /** 更新有货无货标识 */
                            //numSpan.parents('.modelItemCon').find('.lack-flag').text("有货").removeClass('textWarning');
                        $('#sum-cart-item-counts').text(oldSumCartItems - oldNum + parseInt(data.itemCounts));
                    }
                }

                //$(document).on('click','.numReduce', numReduceOnClickFunc);
                hideLoading();
            },
            error: function (errorCode, message, data) {
                //alert(errorCode + ": " + message);
                if (errorCode + "" == "3") {
                    updateCartShow(data);
                    $('.alertLayer').find('.insuredTips').text("该商品库存紧缺，无法继续添加！");
                    $('.alertLayer').fadeIn(200);
                }
                //$(document).on('click','.numAdd', numAddOnClickFunc);
                hideLoading();
            }
        });
    }
};
$(document).on('click', '.numReduce', numReduceOnClickFunc);
/** 购物车商品件数减少按钮 END */

/** 购物车商品件数增加按钮 START */
var numAddOnClickFunc = function () {
    //$(document).off('click','.numAdd', numAddOnClickFunc);
    var $this = $(this);
    var $root = $this.parents(".modelList[data-cart-item-id]");
    if (!$root.hasClass('invalidList')) {
        var cartItemId = $root.attr('data-cart-item-id');
        var numSpan = $(this).parents('.numChoose').find('.numShow');
        var numInput = $this.parents('.numChoose').find('.cart-item-counts');
        var numEdit = $this.parents('.numChoose').find('.numEdit');
        var oldNum = parseInt(numInput.val());
        var num = oldNum + 1;
        if(parseInt(num)>199){
            $('.alertLayer').find('.insuredTips').text('商品数量只能选择1-199');
            $('.alertLayer').show();
            return;
        }
        var oldSumCartItems = parseInt($('#sum-cart-item-counts').text());
        cartItemChangeCounts({
            thisObject:$this,
            cartItemId: cartItemId,
            counts: num,
            isDebug: true,
            beforeSend: function () {
                //$(document).off('click','.numAdd', numAddOnClickFunc);
                showLoading();
            },
            success: function (data) {
                $(this).parents('.deletLayer').attr("rel", "");
                /** 修改成功后，修改页面显示 */
                if (data) {
                    updateCartShow(data);
                    //numSpan.text(num);
                    numEdit.val(num);
                    numInput.val(num);
                    $('#sum-cart-item-counts').text(oldSumCartItems - oldNum + parseInt(data.itemCounts));
                }
                //$(document).on('click','.numAdd', numAddOnClickFunc);
                hideLoading();
            },
            error: function (errorCode, message) {
                //alert(errorCode + ": " + message);
                if (errorCode + "" == "3") {
                    $('.alertLayer').find('.insuredTips').text("该商品库存紧缺，无法继续添加！");
                    $('.alertLayer').fadeIn(200);
                    /** 更新有货无货标识 */
                    //numSpan.parents('.modelItemCon').find('.lack-flag').text("无货").addClass('textWarning');
                }
                //$(document).on('click','.numAdd', numAddOnClickFunc);
                hideLoading();
            }
        });
    }
};

$(document).on('click', '.numAdd', numAddOnClickFunc);
/** 购物车商品件数增加按钮 END */

/** 购物车商品件数修改input START */
var regxDigts = /^\d+$/;
var itemNumsChanged = function () {
    var $this=$(this);
    loginValidate(itemNumsChanged_logined,$this);
}
var itemNumsChanged_logined = function ($this) {
    //$(document).off('click','.numAdd', numAddOnClickFunc);
    var $valInput = $this.parents('.numChoose').find('.cart-item-counts');

    if (!regxDigts.test($this.val())) {
        $this.val($valInput.val());
    }

    var newCounts = parseInt($this.val());
    var oldCounts = parseInt($valInput.val());
    var $root = $this.parents(".modelList[data-cart-item-id]");
    var cartItemId = $root.attr('data-cart-item-id');
    var numSpan = $(this).parents('.numChoose').find('.numShow');

    if (newCounts != oldCounts) {
        cartItemChangeCounts({
            thisObject:$this,
            cartItemId: cartItemId,
            counts: newCounts,
            isDebug: true,
            beforeSend: function () {
                //$(document).off('click','.numAdd', numAddOnClickFunc);
                showLoading();
            },
            success: function (data) {
                $(this).parents('.deletLayer').attr("rel", "");
                /** 修改成功后，修改页面显示 */
                if (data) {
                    updateCartShow(data);
                    //numSpan.text(num);
                    //$('#sum-cart-item-counts').text(parseInt(data.itemCounts));
                    $valInput.val(newCounts).trigger('change');
                }
                //$(document).on('click','.numAdd', numAddOnClickFunc);
                hideLoading();
            },
            error: function (errorCode, message) {
                //alert(errorCode + ": " + message);
                if (errorCode + "" == "3") {
                    $this.val($valInput.val());
                    $('.alertLayer').find('.insuredTips').text("该商品库存紧缺，无法继续添加！");
                    $('.alertLayer').fadeIn(200);
                    /** 更新有货无货标识 */
                    //numSpan.parents('.modelItemCon').find('.lack-flag').text("无货").addClass('textWarning');
                }
                //$(document).on('click','.numAdd', numAddOnClickFunc);
                hideLoading();
            }
        });
    }
};

$(document).on('change blur', '.numAdd', itemNumsChanged);
/** 购物车商品件数修改input END */

$(document).on('click', '.delItem', function () {
    $('.deletLayer').attr("rel", $(this).attr("rel"));
    $('.deletLayer').show();
});

/**
 * 更新购物车显示
 * params: {
 *      deletedItemIds: [] // 已删除的cartItemId
 *      cartItemGroups: // cartItemGroups
 *      excludeModels: // 排除的更新模块，可选模块：stock -- 库存信息
 *      models: // 指定的更新模块，与excludeModels互斥
 * }
 *
 * */
var updateCartShow = function (params) {
    var inModel = function (model, allModel) {
        for (i in allModel) {
            if (allModel[i] == model) return i;
        }
        return -1;
    };

    var excludeModel = function (all, excludes) {
        var delIdx = 0;
        if (excludes && typeof excludes != 'undefined') {
            for (var i in excludes) {
                delIdx = inModel($.trim(excludes[i]), all);
                if (delIdx >= 0) {
                    all.splice(delIdx, 1);
                }
            }
        }
    };

    if (params) {
        var deletedItemIds = params.deletedItemIds;
        var cartItemGroups = params.cartItemGroups;
        var excludeModels = params.excludeModels;
        var updateModels = ["stock", "store", "groups"];
        excludeModel(updateModels, excludeModels);

        /** 删除已成功删除记录对应的DIV元素 */
        if (deletedItemIds && deletedItemIds.length > 0) {
            for (var i in deletedItemIds) {
                $modelList = $('.orderStore .orderList .modelList[data-cart-item-id=' + deletedItemIds[i] + ']');
                /** 去掉删除元素的勾选 */
                showLoading();
                $modelList.find('.cart-item-cb').attr('disabled', true).attr('checked', false).trigger('change');
                hideLoading();
                $modelList.fadeOut(500);
                //$modelList.remove();
            }
        }

        var sumMarketCartPrice = 0.00;
        var sumCartPrice = 0.00;
        var sumCartItemCounts = 0;

        /** 刷新分组价格合计 */
        for (var gidx = 0; gidx < cartItemGroups.length; gidx++) {
            if (cartItemGroups[gidx] && typeof cartItemGroups[gidx] != 'undefined') {
                var $orderStoreDiv = $('.orderStore[data-group-id="' + cartItemGroups[gidx].storeId + '"]');
                //$orderStoreDiv.find(".totalMoney").text(
                //    accounting.formatNumber(
                //        cartItemGroups[gidx].sumPrice , 2, ",", "."));

                $orderStoreDiv.find(".totalMoney").text(
                    "￥" + accounting.formatNumber(
                        cartItemGroups[gidx].sumPrice, 2, ",", "."));

                /** 分组下已无有效商品，取消分组checkBox选中 */
                if (cartItemGroups[gidx].displayCounts <= 0) {
                    $orderStoreDiv.find(".group-select-cb").attr("checked", false);
                    $orderStoreDiv.fadeOut(500);
                }


                /** 更新已选数量及总价 */
                var itemId, $itemDiv;
                for (var j = 0; j < cartItemGroups[gidx].cartItems.length; j++) {
                    itemId = cartItemGroups[gidx].cartItems[j].id;
                    $itemDiv = $orderStoreDiv.find('.modelList[data-cart-item-id="' + itemId + '"]');
                    var $cb = $itemDiv.find(".cart-item-cb");
                    //if (!$cb.is("disabled") && !$cb.attr('disabled') && ($cb.is(":checked") || $cb.attr('checked'))) {
                    if (!$cb.is("disabled") && !$cb.attr('disabled') && ($cb.is(":checked") || $cb.attr('checked'))) {
                        sumCartItemCounts++;
                        //sumCartPrice += cartItemGroups[gidx].cartItems[j].productFashion.salePrice * cartItemGroups[gidx].cartItems[j].count;
                        sumCartPrice += cartItemGroups[gidx].cartItems[j].sumSalePrice
                        sumMarketCartPrice += cartItemGroups[gidx].cartItems[j].productFashion.marketPrice * cartItemGroups[gidx].cartItems[j].count;
                    }
                        /** 刷新商品小计 */
                            //$itemDiv.find('.totalMoneyItem').text(accounting.formatNumber(cartItemGroups[gidx].cartItems[j].productFashion.salePrice * cartItemGroups[gidx].cartItems[j].count, 2, ",", "."));
                            //$itemDiv.find('.totalMoneyItem').text(accounting.formatNumber(cartItemGroups[gidx].cartItems[j].productFashion.salePrice * cartItemGroups[gidx].cartItems[j].count, 0, ",", ".") + "Ct");
                        $itemDiv.find('.totalMoneyItem').text("￥" + accounting.formatNumber(cartItemGroups[gidx].cartItems[j].sumSalePrice, 2, ",", "."));

                        /** 有货无货标志修改 */
                        if (inModel("stock", updateModels) >= 0) {
                            if (cartItemGroups[gidx].cartItems[j].status == '0') {
                                /*if (cartItemGroups[gidx].cartItems[j].productFashion.stockCount - cartItemGroups[gidx].cartItems[j].count < 0) {
                                    $itemDiv.find('.lack-flag').text("无货").addClass('textWarning');
                                    $cb.attr("stock", "false");
                                    if($cb.is(":checked") || $cb.attr('checked')) {
                                        $('#go-order-comfirm').addClass('disabled');
                                    }
                                } else {*/
                                    $cb.attr("stock", "true");
                                    $itemDiv.find('.lack-flag').text("有货").removeClass('textWarning');
                                /*}*/
                            } else {
                                $cb.attr("stock", "false");
                                if($cb.is(":checked") || $cb.attr('checked')) {
                                    $('#go-order-comfirm').addClass('disabled');
                                }
                                $itemDiv.find('.lack-flag').text("无货").addClass('textWarning');

                            }
                        }

                       /* if (inModel("stock", updateModels) >= 0) {
                            if (cartItemGroups[gidx].cartItems[j].status == '0') {
                                if (cartItemGroups[gidx].cartItems[j].productFashion.lackRemind) {
                                    if (cartItemGroups[gidx].cartItems[j].productFashion.stockCount - cartItemGroups[gidx].cartItems[j].count <= cartItemGroups[gidx].cartItems[j].productFashion.lackRemind) {
                                        //$itemDiv.find('.lack-flag').text("库存紧张").addClass('textWarning');
                                        $itemDiv.find('.lack-flag').text("有货").addClass('textWarning');

                                    } else {
                                        $itemDiv.find('.lack-flag').text("有货").removeClass('textWarning');
                                    }
                                } else {
                                    $itemDiv.find('.lack-flag').text("有货").removeClass('textWarning');
                                }
                            } else {
                                $itemDiv.find('.lack-flag').text("无货").addClass('textWarning');
                            }
                        }*/

                    //}
                }
            }
        }

        /** 如果当前无勾选商品，总计重置为0 */
        if (!isCartItemIdsChecked()) {
            params.sumCartItemCounts = 0;
            sumCartPrice = 0;
            sumMarketCartPrice = 0;
            params.sumScore = 0;
            params.needPayPrice = 0;
            //params.sumGoodsCount = 0;

        }

        if (params.sumGoodsCount <= 0) {
            $("#cartEmptyView").removeClass('f-hide').show();
            $(".cart-show-view-modals").addClass('f-hide').hide();
        } else {
            $("#cartEmptyView").addClass('f-hide').hide();
            $(".cart-show-view-modals").removeClass('f-hide').show();
        }

        var sumCartItemCounts = params.sumCartItemCounts;
        /** 根据已勾选的记录，重新计算件数 */
        var tmpCounts = 0;
        $('.cart-item-cb').each(function () {
            var $this = $(this);
            if ($this.attr("checked") && !$this.is(":hidden")) {
                var c = $this.parents(".modelList").find('.numShow').val();
                if (typeof c == 'undefined' || c == "") {
                    c = 0;
                }
                tmpCounts += Number(c);
            }
        });
        sumCartItemCounts = tmpCounts;

        $("#sum-goods-count").text(accounting.formatNumber(params.sumGoodsCount, 0, ",", "."));
        //$("#sum-cart-price").text(accounting.formatNumber(sumCartPrice , 2, ",", "."));
        //$("#sum-cart-price-save").text(accounting.formatNumber(sumMarketCartPrice - sumCartPrice , 2, ",", "."));
        $("#sum-cart-item-counts").text(accounting.formatNumber(sumCartItemCounts, 0, ",", "."));
        $("#sum-itaiping").text(accounting.formatNumber(params.sumScore, 0, ",", ".") + "Ct");
        //$("#sum-cart-needPay").text(accounting.formatNumber(params.needPayPrice, 2, ",", "."));
        $("#sum-cart-price").text("￥" + accounting.formatNumber(sumCartPrice, 2, ",", "."));
        $("#sum-cart-price-save").text(accounting.formatNumber((sumMarketCartPrice - sumCartPrice ), 0, ",", "."));
        $("#sum-cart-needPay").text(accounting.formatNumber(params.needPayPrice, 2, ",", "."));
    }
};

/** 购物车商品删除按钮 START */
var doCartItemDelFunc = function () {
    var $this=$(this);
    loginValidate(doCartItemDelFunc_logined,$this);
}
var doCartItemDelFunc_logined = function ($this) {
    $(document).off('click', '.doCartItemDel', doCartItemDelFunc);
    var $dialog = $this.parents(".coverCon");
    var cartItemId = $this.parents('.deletLayer').attr('rel');
    var isBatch = cartItemId.indexOf(',') > 0;

    var reqData = {
        cartItemId: cartItemId,
        debug: 'true'
    };

    if (cartItemId && cartItemId != "") {
        var $modelList;
        $.ajax({
            url: "/score/myCart/itemDel.json",
            type: "POST",
            dataType: "json",
            data: reqData,
            beforeSend: function () {
                $dialog.find(".msg-info").text("处理中...").fadeIn(300);
            },
            success: function (result) {
                //console.debug("result: %o", result);
                //$("#response").text(printObj(result));
                $(this).parents('.deletLayer').attr("rel", "");
                /** 删除成功后，修改页面显示 */
                if (result.status == 0 || result.status == "0" || result.status == "success") {
                    if (result.data) {
                        updateCartShow(result.data);
                        $dialog.find(".msg-info").text("已删除").fadeIn(300);
                        window.setTimeout(function () {
                            $dialog.find(".msg-info").text("").fadeOut(200);
                            $dialog.parent().fadeOut(300);
                        }, 300);
                    }

                }
                $(document).on('click', '.doCartItemDel', doCartItemDelFunc);
                $(document).trigger('RefreshTopInfo');
            },
            error: function () {
                $dialog.find(".msg-info").text("").hide();
                $dialog.find(".msg-error").fadeIn(300);
                $(document).on('click', '.doCartItemDel', doCartItemDelFunc);
            }
        });
    }
};
$(document).on('click', '.doCartItemDel', doCartItemDelFunc);
/** 购物车商品删除按钮 END */

/** 删除弹出窗点击移到收藏夹按钮 Start*/
var movePreDelItemToFav = function () {
    var $this = $(this);
    loginValidate(movePreDelItemToFav_logined,$this);
}
var movePreDelItemToFav_logined = function ($this) {
    $(document).off('click', '.doCartItemMove', movePreDelItemToFav);

    var $dialog = $this.parents(".coverCon");
    var cartItemId = $this.parents('.deletLayer').attr('rel');
    var isBatch = cartItemId.indexOf(',') > 0;
    var ids = cartItemId.split(',');
    for (var i in ids) {
        ids[i] = ("" + ids[i]).trim();
    }
    moveItemToFav({
        ids: ids,
        beforeSend: function () {
            $dialog.find(".msg-info").text("处理中...").fadeIn(300);
            $(document).off('click', '.doMoveToFav', addSelectedToFavOnClick);
        },
        success: function (data) {
            //alert("sucess callback");
            $dialog.find(".msg-info").text("已加入收藏夹").fadeIn(300);
            window.setTimeout(function () {
                $dialog.find(".msg-info").text("").fadeOut(200);
                $dialog.parent().fadeOut(300);
            }, 300);
            $(document).on('click', '.doMoveToFav', addSelectedToFavOnClick);

        },
        error: function (error, message) {
            $dialog.find(".msg-info").text("处理失败，请稍后再试！").hide();
            $dialog.find(".msg-error").fadeIn(300);
            $(document).on('click', '.doMoveToFav', addSelectedToFavOnClick);
        }
    });
};
$(document).on('click', '.delLayer .doCartItemMove', movePreDelItemToFav);
/** 删除弹出窗点击移到收藏夹按钮 End*/


/** 删除已选择商品按钮点击 START */
var delSelectedBtnOnClick = function () {
    $(document).off('click', '.deletBtn', delSelectedBtnOnClick);
    if (isCartItemIdsChecked()) {
        var ids = [];
        /** 获取已勾选记录 */
        $('.cart-item-cb').each(function () {
            if ($(this).is(":checked") || $(this).attr('checked')) {
                ids.push($(this).parents('[data-cart-item-id]').attr('data-cart-item-id'));
            }
        });

        $('.deletLayer').attr("rel", ids);
        $('.deletLayer').show();
    } else {
        $('.deletLayer').attr("rel", "");
        $('.leastLayer').fadeIn(300);
    }
    $(document).on('click', '.deletBtn', delSelectedBtnOnClick);
};
$(document).on('click', '.deletBtn', delSelectedBtnOnClick);
/** 删除已选择商品按钮点击 END */

/** 添加收藏夹 */
$(document).on('click', '.removeOneItem', function () {
    $('.removeLayer').attr("rel", $(this).attr("rel"));
    $('.removeLayer').show();
});

/** 批量添加收藏夹 START */
$(document).on('click', '.removeBatchItem', function () {
    if (isCartItemIdsChecked()) {
        $('.removeLayer').fadeIn(300);
    } else {
        $('.leastLayer').fadeIn(300);
    }
});

var addSelectedToFavOnClick = function (event) {
    $(document).off('click', '.doMoveToFav', addSelectedToFavOnClick);
    var $this = $(this);
    var orginTxt = $this.text();
    var ids = [];
    var rel = $this.parents('.removeLayer').attr('rel');
    if (rel && rel.length > 0) {
        ids = rel.split(',');
    } else {
        /** 获取已勾选记录 */
        $('.cart-item-cb').each(function () {
            if ($(this).is(":checked") || $(this).attr('checked')) {
                ids.push($(this).parents('[data-cart-item-id]').attr('data-cart-item-id'));
            }
        });
    }
    for (var i in ids) {
        ids[i] = ("" + ids[i]).trim();
    }

    var $dialog = $(this).parents(".coverCon");
    moveItemToFav({
        ids: ids,
        beforeSend: function () {
            $dialog.find(".msg-info").text("处理中...").fadeIn(300);
            $(document).off('click', '.doMoveToFav', addSelectedToFavOnClick);
        },
        success: function (data) {
            $dialog.find(".msg-info").text("已加入收藏夹").fadeIn(300);
            window.setTimeout(function () {
                $dialog.find(".msg-info").text("").fadeOut(200);
                $dialog.parent().fadeOut(300);
            }, 300);
            $(document).on('click', '.doMoveToFav', addSelectedToFavOnClick);

        },
        error: function (error, message) {
            $dialog.find(".msg-info").text("处理失败，请稍后再试！").hide();
            $dialog.find(".msg-error").fadeIn(300);
            $(document).on('click', '.doMoveToFav', addSelectedToFavOnClick);
        }
    });
};
$(document).on('click', '.doMoveToFav', addSelectedToFavOnClick);
/** 批量添加收藏夹 END */

/** 清除下架商品 START */
var deleteInvalidOnClick = function () {
    var $this = $(this);
    loginValidate(deleteInvalidOnClick_logined, $this);
}
var deleteInvalidOnClick_logined = function ($this) {
    $(document).off('click', '.clearGoods', deleteInvalidOnClick);
    var orginTxt = $this.text();
    $.ajax({
        url: "/score/myCart/invalidDel.json",
        type: "POST",
        dataType: "json",
        data: {
            random: Math.random()
        },
        beforeSend: function () {
            $this.text("处理中...");
            $(document).off('click', '.clearGoods', deleteInvalidOnClick);
        },
        success: function (result) {
            //console.debug("result: %o", result);
            /** 删除成功后，修改页面显示 */
            if (result.status == 0 || result.status == "0" || result.status == "success") {
                if (result.data) {
                    result.data.excludeModels = ["stock"];
                    updateCartShow(result.data);
                    $this.text("已清除所有下架商品！");
                    window.setTimeout(function () {
                        $this.fadeOut(200);
                        $this.text(orginTxt);
                        $this.fadeIn(200);
                    }, 500);
                }

            }
            $(document).on('click', '.clearGoods', deleteInvalidOnClick);
        },
        error: function (jqXHR, textStatus, errorThrown) {
            //$dialog.find(".msg-info").text("").hide();
            //$dialog.find(".msg-error").fadeIn(300);
            //$(document).on('click', '.doCartItemDel', doCartItemDelFunc);
            $this.text("处理失败，请稍后再试！");
            window.setTimeout(function () {
                $this.fadeOut(200);
                $this.text(orginTxt);
                $this.fadeIn(200);
            }, 500);
            $(document).on('click', '.clearGoods', deleteInvalidOnClick);
            console.error("Ajax Error: [%s], error: [%s], jqXHR: [%o]", textStatus, errorThrown, jqXHR);
        }
    });
};
$(document).on('click', '.clearGoods', deleteInvalidOnClick);
/** 清除下架商品 END */

/** 去结算按钮点击 START */
var goOrderSubmitOnClick = function () {
    loginValidate(goOrderSubmitOnClick_logined);
}
var goOrderSubmitOnClick_logined = function () {
    $('#allInvalidLayer').hide();
    if (!isCartItemIdsChecked()) {
        if (hasUnvalidItems()) {
            $('#allInvalidLayer').fadeIn(300);
        } else {
            $('.leastLayer').fadeIn(300);
        }
    } else {
        var ids = [];
        /** 获取已勾选记录 */
        $('.cart-item-cb').each(function () {
            if ($(this).is(":checked") || $(this).attr('checked')) {
                ids.push($(this).parents('[data-cart-item-id]').attr('data-cart-item-id'));
            }
        });

        $.ajax({
            url: "/score/order/newOrder.json",
            type: "POST",
            dataType: "json",
            data: {
                cartItemIds: ids.join(","),
                areaCode: $('#areaCode').val(),
                random: Math.random()
            },
            beforeSend: function () {
                showLoading();
            },
            success: function (result) {
                //console.debug("result: %o", result);

                /** 删除成功后，修改页面显示 */
                if (result.status == "success") {
                    window.location.href = "/score/order/orderInfo?rid=" + result.data.orderTmpId;
                } else {
                    hideLoading();
                    if (result.error + "" == "3") {
                        // 库存不足提示
                        $('#stockInvalidLayer').show();
                    } else {
                        console.error && (typeof console.error).toLowerCase() == 'function' && console.error("Ajax Error: [%s], message: [%s]", result.error, result.message);
                    }
                }


            },
            error: function (jqXHR, textStatus, errorThrown) {
                hideLoading();
                //$(document).on('click', '#go-order-comfirm', goOrderSubmitOnClick);
            }
        });
    }
};
$(document).off('click', '#go-order-comfirm', goOrderSubmitOnClick);
$(document).on('click', '#go-order-comfirm', goOrderSubmitOnClick);
/** 去结算按钮点击 END */

$(document).on('click', '.coverLayer .close, .coverLayer [rel=close]', function () {
    $(this).parents(".coverLayer").fadeOut(300);
    //$('.removeLayer').show();
});
/**
 * 数据加载，禁止提交购物车，禁止调整购物车数量，禁止checkbox事件响应
 */
var showLoading = function () {
    $('.newCheckbox').each(function () {
        $(this).attr('disabled', true);
    });
    $('#go-order-comfirm').addClass('disabled');
    $(document).off('click', '.numReduce', numReduceOnClickFunc);
    $(document).off('click', '.numAdd', numAddOnClickFunc);
    $(document).off('change keyup blur', '.numEdit', itemNumsChanged);
    $(document).off('click', '#go-order-comfirm', goOrderSubmitOnClick);
    $(document).off("change", ".cart-item-cb", cartItemCbOnChange);
};
/**
 * 数据加载，禁止提交购物车，禁止调整购物车数量，禁止checkbox事件响应
 */
var hideLoading = function () {
    $('.newCheckbox').each(function () {
        $(this).attr('disabled', false);
    });
    /** 确保事件只绑定一次 */
    $(document).off('click', '.numReduce', numReduceOnClickFunc);
    $(document).off('click', '.numAdd', numAddOnClickFunc);
    $(document).off('click', '#go-order-comfirm', goOrderSubmitOnClick);
    $(document).off("change", ".cart-item-cb", cartItemCbOnChange);
    $(document).off('change keyup blur', '.numEdit', itemNumsChanged);
    $(document).on('click', '.numReduce', numReduceOnClickFunc);
    $(document).on('click', '.numAdd', numAddOnClickFunc);
    $(document).on('click', '#go-order-comfirm', goOrderSubmitOnClick);
    $(document).on("change", ".cart-item-cb", cartItemCbOnChange);
    $(document).on('change blur', '.numEdit', itemNumsChanged);

    var checkedAll = true;
    var stockFalg = true;
    $(".cart-item-cb").each(function(index, elements) {
        if((!$(elements).prop("checked") || !$(elements).attr('checked'))) {
            checkedAll = false;
        }
        var stock = $(elements).attr("stock");
        if(stock == "false" && ($(elements).prop("checked") || $(elements).attr('checked'))) {
            stockFalg = false;
            $(document).off('click', '#go-order-comfirm', goOrderSubmitOnClick);
            return false;
        }
    });

    if(checkedAll) {
        $(".totalAllChoose").find("input[type='checkbox']").attr("checked", true);
    }

    if(stockFalg) {
        $('#go-order-comfirm').removeClass('disabled');
    }

};
var getSelectedCartIds = function () {
    var cartItemIds = [];
    $('.cart-item-cb').each(function () {
        if ($(this).attr('checked')) {
            cartItemIds.push($(this).val());
        }
    });

    return cartItemIds;
};
/**
 * 刷新购物车展示
 */
var CartDataCache = {
    "key": {
        exceedTime: undefined,
        lastUpdated: undefined,
        dateCreated: undefined,
        data: {}
    }
};
var refreshCartView = function (params) {
    var areaCode = params.areaCode;
    var beforeSend = params.beforeSend;
    var success = params.success;
    var error = params.error;
    var refreshStock = params.refreshStock;
    var refreshFlag = typeof params.refreshFlag == 'undefined' || params.refreshFlag == null ? true : params.refreshFlag;
    var cartItemIds = typeof params.cartItemIds == 'undefined' || params.cartItemIds == null ? getSelectedCartIds() : params.cartItemIds;

    getCartData({
        areaCode: areaCode,
        refreshStock: typeof refreshStock == 'undefined' ? true : refreshStock,
        cartItemIds: cartItemIds,
        cached: false,
        beforeSend: function () {
            showLoading();
            beforeSend && typeof beforeSend == 'function' && beforeSend();
        },
        success: function (data) {
            updateCartShow(data);
            hideLoading();
            success && typeof success == 'function' && success();
        },
        error: function () {
            hideLoading();
            alert("刷新第三方库存状态失败！");
            error && typeof error == 'function' && error();
        }
    });
};
/**
 *  ajax获取购物车数据
 * @param params:
 *      params.areaCode: String 地区编码
 *      params.refreshStock: boolean ture|false 是否刷新实时库存
 *      params.cartItemIds: String[] 指定的购物车item
 *      params.cached: Boolean ture|false 是否启用缓存
 *      params.exceed: number 缓存过期时间，单位：毫秒
 *      params.beforeSend: function 查询请求发送前回调
 *      params.success: function 成功回调
 *      params.error: function 错误回调
 */
var getCartData = function (params) {
    var areaCode = params.areaCode;
    var beforeSend = params.beforeSend;
    var success = params.success;
    var error = params.success;
    var refreshStock = params.refreshStock; // 是否刷新库存
    var cartItemIds = typeof params.cartItemIds == 'undefined' || params.cartItemIds == null ? [] : params.cartItemIds;
    var cached = typeof params.cached == 'undefined' || params.cached == null ? true : params.cached;
    var debug = typeof params.debug == 'undefined' || params.debug == null ? false : debug;
    var exceed = 60 * 1000; // 过期时间（毫秒）

    var cacheKey = areaCode + "_" + cartItemIds.join("_");

    var cachedData = CartDataCache[cacheKey];
    if (cached && cachedData && cachedData.exceedTime >= new Date()) {
        success && typeof success == 'function' && success(cachedData.data);
    } else {
        $.ajax({
            url: "/score/myCart/refresh.json",
            data: {
                areaCode: areaCode,
                cartItemIds: cartItemIds,
                getShippingFee: false,
                refreshStock: refreshStock
            },
            beforeSend: function () {
                beforeSend && typeof beforeSend == 'function' && beforeSend();
            },
            success: function (result) {
                var now = new Date();
                if (result.status == "success") {
                    updateCartDataCache(cacheKey, result.data, exceed);
                } else {
                    error && typeof error == 'function' && error("1", "刷新第三方库存状态失败");
                }
                success && typeof success == 'function' && success(result.data);
            },
            error: function (a, b, c) {
                error && typeof error == 'function' && error(a, a + "," + b + "," + c);
            }
        });
    }
};
var updateCartDataCache = function (key, data, exceed) {
    exceed = exceed ? exceed : 60 * 1000;
    var now = new Date();
    var cachedData = CartDataCache[key];
    if (!cachedData || cachedData == {} || cachedData == null || cachedData == undefined || typeof cachedData == 'undefined') {
        cachedData = {};
    }
    cachedData.exceedTime = new Date(now.getTime() + exceed);
    cachedData.lastUpdated = now;
    cachedData.dateCreated = cachedData.dateCreated ? cachedData.dateCreated : now;
    cachedData.data = data;
};

$(document).on(AreaSelectPlugin.EVENT_KEYS.AREA_SELECTED, '#areaCode', function (event, areaSelected) {
    /** 公共事件注册，成功选择地区后，保存所选地区 */
    if (areaSelected.length > 1) {
        $.get('/score/areaCommon/changeArea/' + areaSelected[areaSelected.length - 1].code, {}, function () {
            $(document).trigger("RefreshTopInfo");
        });
    } else {
        $.get('/score/areaCommon/changeProvince/' + areaSelected[0].code, {}, function () {
            $(document).trigger("RefreshTopInfo");
        });
    }
    var data = {};
    var lastIdx = 1;
    for (var i in areaSelected) {
        lastIdx = i;
    }

    refreshCartView({areaCode: areaSelected[lastIdx].code});
});

var cartItemCbOnChange = function () {
    if (!$(this).attr('disabled')) {
        refreshCartView({
            areaCode: $('#areaCode').val(),
            refreshStock: true,
            beforeSend: function () {
                showLoading();
            },
            success: function () {
                hideLoading();
                //$(document).on("change", ".cart-item-cb", cartItemCbOnChange);
                //$(".cart-item-cb").attr("disabled", false);
            },
            error: function () {
                hideLoading();
                //$(document).on("change", ".cart-item-cb", cartItemCbOnChange);
                //$(".cart-item-cb").attr("disabled", false);
            }
        });
    }
};

var cartItemGroupOnChange = function () {
    var $this = $(this);
    if (!$(this).attr('disabled')) {
        refreshCartView({
            areaCode: $('#areaCode').val(),
            refreshStock: false,
            beforeSend: function () {
                $(document).off("change", ".cart-item-cb", cartItemCbOnChange);
                $this.find('.cart-item-cb').each(function () {
                    if (!$(this).is("disabled") && !$(this).attr('disabled')) {
                        $(this).attr('checked', true);
                    }
                });
                $("#sum-cart-price").text(0.00);
                $("#sum-cart-price-save").text(0.00);
                $("#sum-cart-item-counts").text(0);
                //$(".cart-item-cb").attr("disabled", true);
            },
            success: function () {
                $(document).on("change", ".cart-item-cb", cartItemCbOnChange);
                //$(".cart-item-cb").attr("disabled", false);
            },
            error: function () {
                $(document).on("change", ".cart-item-cb", cartItemCbOnChange);
                //$(".cart-item-cb").attr("disabled", false);
            }
        });
    }
};

$(document).on("ready", function () {
    //refreshCartView({areaCode: $('#areaCode').val()});
    $(document).on('change', '.cart-item-cb', cartItemCbOnChange);
    $(document).on('change', '.group-select-cb', cartItemCbOnChange);


    //refreshCartView({
    //    areaCode: $('#areaCode').val(),
    //    refreshStock: false,
    //    refreshFlag:true, // 取消勾选/勾选商品时不请求服务器数据
    //    beforeSend: function() {
    //        $(document).off("change", ".cart-item-cb", cartItemCbOnChange);
    //        $("#sum-cart-price").text(0.00);
    //        $("#sum-cart-price-save").text(0.00);
    //        $("#sum-cart-item-counts").text(0);
    //        //$(".cart-item-cb").attr("disabled", true);
    //    },
    //    success: function() {
    //        $(document).on("change", ".cart-item-cb", cartItemCbOnChange);
    //        //$(".cart-item-cb").attr("disabled", false);
    //    },
    //    error: function() {
    //        $(document).on("change", ".cart-item-cb", cartItemCbOnChange);
    //        //$(".cart-item-cb").attr("disabled", false);
    //    }
    //});
});
$(".nav-tabs>li").on('mouseover', 'a', function () {
    if ($(this).html() != "") {
        $(this).addClass('activeTab');
    }
});
$(".nav-tabs>li").on('mouseout', 'a', function () {
    $(this).removeClass('activeTab');
});