/**
 * Created by Administrator on 2016/10/28.
 */

/**
 * 判断是否至少有1个购物车记录已被选择
 */
var isCartItemIdsChecked = function() {
    var hasChecked = false;
    $('.cart-item-cb:enabled').each(function() {
        if($(this).is(":checked") || $(this).attr('checked')) {
            hasChecked = true;
        }
    });
    return hasChecked;
};

/**
 * 修改购物车商品购买数量
 * @param params
 */
var cartItemChangeCounts = function(params) {
    var cartItemId = params.cartItemId;
    var counts = params.counts;
    var sucFunc = params.success;
    var errorFunc = params.error;
    var beforeSend = params.beforeSend;
    var isDebug = params.debug;
    $.ajax({
        url: "/cart/myCart/carItem/changeCounts.json",
        type: "POST",
        dataType: "json",
        data: {
            cartItemId: cartItemId,
            counts: counts,
            areaCode: $('#areaCode').val(),
            debug: isDebug ? isDebug : null
        },
        beforeSend: function() {
            if(isDebug) {
                if(typeof console.info != 'undefined') {
                    console.info("cartItemChangeCounts beforeSend");
                }
            }
            if(beforeSend && (typeof beforeSend).toLowerCase() == 'function') {
                beforeSend();
            }
        },
        success: function(result) {
            //console.debug(result);
            if(isDebug) {
                if(typeof console.info != 'undefined') {
                    console.info("result: %o", result);
                }
            }
            if(result.status == "success") {
                sucFunc(result.data);
            } else {
                errorFunc(result.error, result.message);
            }


        },
        error: function(jqXHR, textStatus, errorThrown) {
            if(isDebug) {
                if(typeof console.info != 'undefined') {
                    console.info("Ajax Error: [%s], error: [%s], jqXHR: [%o]", textStatus, errorThrown, jqXHR);
                }
            }
            if(errorFunc && (typeof errorFunc).toLowerCase() == 'function') {
                errorFunc(textStatus, errorThrown);
            }
        }
    });
};

/**
 * 购物车商品移入收藏夹
 * @param params
 */
var moveItemToFav = function(params) {
    var ids = params.ids;
    var beforeSend = params.beforeSend;
    var success = params.success;
    var error = params.error;
    if(typeof ids == 'string') {
        ids = ids.split(',');
    }

    $.ajax({
        url: "/cart/myCart/carItem/favAdd.json",
        type: "POST",
        dataType: "json",
        data: {
            cartItemId: ids.join(","),
            random: Math.random()
        },
        beforeSend: function() {
            if((typeof beforeSend).toLowerCase() == 'function') {
                beforeSend();
            }
        },
        success: function(result) {
            //console.debug("result: %o", result);
            /** 删除成功后，修改页面显示 */
            if(result.status == 0 || result.status == "0" || result.status == "success") {
                if(result.data) {
                    updateCartShow(result.data);
                    if((typeof success).toLowerCase() == 'function') {
                        success(result.data);
                    }
                }
                $(document).on('click', '.doMoveToFav', addSelectedToFavOnClick);
            } else {
                if((typeof sucess).toLowerCase() == 'function') {
                    error(result.data.error, result.data.message ? result.data.message : result.data.msg);
                }
                console.error("Ajax Error: [%s], message: [%s]",result.data.error, result.data.message);
            }

        },
        error: function(jqXHR, textStatus, errorThrown) {
            if((typeof sucess).toLowerCase() == 'function') {
                error(textStatus, "AjaxRequestError: "+errorThrown);
            }
            console.error("Ajax Error: [%s], error: [%s], jqXHR: [%o]", textStatus, errorThrown, jqXHR);
        }
    });

};


/** 购物车商品件数减少按钮 START */
var numReduceOnClickFunc = function() {
    $(document).off('click','.numReduce', numReduceOnClickFunc);
    var $this = $(this);
    var $root = $this.parents(".modelList[data-cart-item-id]");
    var cartItemId = $root.attr('data-cart-item-id');
    var numSpan = $(this).parents('.numChoose').find('.numShow');
    var num = parseInt(numSpan.text());
    if(num>1){
        num = num-1;
    }

    cartItemChangeCounts({
        cartItemId: cartItemId,
        counts: num,
        isDebug: true,
        beforeSend: function () {
            $(document).off('click','.numReduce', numReduceOnClickFunc);
        },
        success: function (data) {
            $(this).parents('.deletLayer').attr("rel", "");
            /** 修改成功后，修改页面显示 */
            if(data) {
                if(data) {
                    updateCartShow(data);
                    numSpan.text(num);
                    /** 更新有货无货标识 */
                    numSpan.parents('.modelItemCon').find('.lack-flag').text("有货").removeClass('textWarning');
                }
            }

            $(document).on('click','.numReduce', numReduceOnClickFunc);
        },
        error: function (errorCode, message) {
            //alert(errorCode + ": " + message);
            if(errorCode + "" == "3") {
                $('.alertLayer').find('.insuredTips').text("该商品库存紧缺，无法继续添加！");
                $('.alertLayer').fadeIn(200);
            }
            $(document).on('click','.numAdd', numAddOnClickFunc);
        }
    });
};
$(document).on('click','.numReduce', numReduceOnClickFunc);
/** 购物车商品件数减少按钮 END */

/** 购物车商品件数增加按钮 START */
var numAddOnClickFunc = function() {
    $(document).off('click','.numAdd', numAddOnClickFunc);
    var $this = $(this);
    var $root = $this.parents(".modelList[data-cart-item-id]");
    var cartItemId = $root.attr('data-cart-item-id');
    var numSpan = $(this).parents('.numChoose').find('.numShow');
    var num = parseInt(numSpan.text())+1;

    cartItemChangeCounts({
        cartItemId: cartItemId,
        counts: num,
        isDebug: true,
        beforeSend: function () {
            $(document).off('click','.numAdd', numAddOnClickFunc);
        },
        success: function (data) {
            $(this).parents('.deletLayer').attr("rel", "");
            /** 修改成功后，修改页面显示 */
            if(data) {
                updateCartShow(data);
                //$root.parents('.orderStore').find('.totalMoney').text(accounting.formatNumber(data.storeSumPrice , 2, ",", "."));
                //$("#sum-goods-count").text(accounting.formatNumber(data.sumGoodsCount , 0, ",", "."));
                //$("#sum-cart-price").text(accounting.formatNumber(data.sumCartPrice , 2, ",", "."));
                //$("#sum-cart-price-save").text(accounting.formatNumber(data.sumMarketCartPrice - data.sumCartPrice , 2, ",", "."));
                //$("#sum-cart-item-counts").text(accounting.formatNumber(data.sumCartItemCounts, 0, ",", "."));
                //$root.find('.totalMoneyItem').text(accounting.formatNumber(data.cartItemSumPrice, 2, ",", "."));
                numSpan.text(num);
                /** 更新有货无货标识 */
                alert("有货");
                numSpan.parents('.modelItemCon').find('.lack-flag').text("有货").removeClass('textWarning');
            }
            $(document).on('click','.numAdd', numAddOnClickFunc);
        },
        error: function (errorCode, message) {
            //alert(errorCode + ": " + message);
            if(errorCode + "" == "3") {
                $('.alertLayer').find('.insuredTips').text("该商品库存紧缺，无法继续添加！");
                $('.alertLayer').fadeIn(200);
                /** 更新有货无货标识 */
                //numSpan.parents('.modelItemCon').find('.lack-flag').text("无货").addClass('textWarning');
            }
            $(document).on('click','.numAdd', numAddOnClickFunc);
        }
    });
};

$(document).on('click','.numAdd', numAddOnClickFunc);
/** 购物车商品件数增加按钮 END */

$(document).on('click','.delItem',function(){
    $('.deletLayer').attr("rel", $(this).attr("rel"));
    $('.deletLayer').show();
});

/** 更新购物车显示 */
var updateCartShow = function(params) {
    var deletedItemIds = params.deletedItemIds;
    var cartItemGroups = params.cartItemGroups;
    /** 删除已成功删除记录对应的DIV元素 */
    if(deletedItemIds && deletedItemIds.length > 0) {
        for(var i in deletedItemIds) {
            $modelList = $('.orderStore .orderList .modelList[data-cart-item-id='+deletedItemIds[i]+']');
            $modelList.fadeOut(500);
            //$modelList.remove();
        }
    }
    /** 刷新分组价格合计 */
    for(var i in cartItemGroups) {
        var $orderStoreDiv = $('.orderStore[data-group-id="'+cartItemGroups[i].storeId+'"]');
        $orderStoreDiv.find(".totalMoney").text(
            accounting.formatNumber(
                cartItemGroups[i].sumPrice , 2, ",", "."));

        /** 分组下已无有效商品，取消分组checkBox选中 */
        if(cartItemGroups[i].displayCounts <= 0) {
            $orderStoreDiv.find(".group-select-cb").attr("checked", false);
            $orderStoreDiv.fadeOut(500);
        }
    }
    $("#sum-goods-count").text(accounting.formatNumber(params.sumGoodsCount , 0, ",", "."));
    $("#sum-cart-price").text(accounting.formatNumber(params.sumCartPrice , 2, ",", "."));
    $("#sum-cart-price-save").text(accounting.formatNumber(params.sumMarketCartPrice - params.sumCartPrice , 2, ",", "."));
    $("#sum-cart-item-counts").text(accounting.formatNumber(params.sumCartItemCounts, 0, ",", "."));

};

/** 购物车商品删除按钮 START */
var doCartItemDelFunc = function() {
    $(document).off('click', '.doCartItemDel', doCartItemDelFunc);
    var $this = $(this);
    var $dialog = $(this).parents(".coverCon");
    var cartItemId = $(this).parents('.deletLayer').attr('rel');
    var isBatch = cartItemId.indexOf(',') > 0;

    var reqData = {
        cartItemId: cartItemId,
        debug:'true'
    };

    if(cartItemId && cartItemId != "") {
        var $modelList;
        $.ajax({
            url: "/cart/myCart/itemDel.json",
            type: "POST",
            dataType: "json",
            data: reqData,
            beforeSend: function() {
                $dialog.find(".msg-info").text("处理中...").fadeIn(300);
            },
            success: function(result) {
                //console.debug("result: %o", result);
                //$("#response").text(printObj(result));
                $(this).parents('.deletLayer').attr("rel", "");
                /** 删除成功后，修改页面显示 */
                if(result.status == 0 || result.status == "0" || result.status == "success") {
                    if(result.data) {
                        updateCartShow(result.data);
                        $dialog.find(".msg-info").text("已删除").fadeIn(300);
                        window.setTimeout(function() {
                            $dialog.find(".msg-info").text("").fadeOut(200);
                            $dialog.parent().fadeOut(500);
                        }, 500);
                    }

                }
            },
            error: function() {
                $dialog.find(".msg-info").text("").hide();
                $dialog.find(".msg-error").fadeIn(300);
                $(document).on('click', '.doCartItemDel', doCartItemDelFunc);
            }
        });
    }
};
$(document).on('click', '.doCartItemDel', doCartItemDelFunc);
/** 购物车商品删除按钮 END */

/** 删除弹出窗点击移到收藏夹按钮 Start*/
var movePreDelItemToFav = function() {
    $(document).off('click', '.doCartItemMove', movePreDelItemToFav);
    var $this = $(this);
    var $dialog = $(this).parents(".coverCon");
    var cartItemId = $(this).parents('.deletLayer').attr('rel');
    var isBatch = cartItemId.indexOf(',') > 0;
    var ids = cartItemId.split(',');
    for(var i in ids) {
        ids[i] = (""+ids[i]).trim();
    }
    moveItemToFav({
        ids: ids,
        beforeSend: function() {
            $dialog.find(".msg-info").text("处理中...").fadeIn(300);
            $(document).off('click', '.doMoveToFav', addSelectedToFavOnClick);
        },
        success: function(data) {
            alert("sucess callback");
            $dialog.find(".msg-info").text("已加入收藏夹").fadeIn(300);
            window.setTimeout(function() {
                $dialog.find(".msg-info").text("").fadeOut(200);
                $dialog.parent().fadeOut(500);
            }, 500);
            $(document).on('click', '.doMoveToFav', addSelectedToFavOnClick);

        },
        error: function(error, message) {
            $dialog.find(".msg-info").text("处理失败，请稍后再试！").hide();
            $dialog.find(".msg-error").fadeIn(300);
            $(document).on('click', '.doMoveToFav', addSelectedToFavOnClick);
        }
    });
};
$(document).on('click', '.delLayer .doCartItemMove', movePreDelItemToFav);
/** 删除弹出窗点击移到收藏夹按钮 End*/



/** 删除已选择商品按钮点击 START */
var delSelectedBtnOnClick = function() {
    $(document).off('click', '.deletBtn', delSelectedBtnOnClick);
    if(isCartItemIdsChecked()) {
        var ids = [];
        /** 获取已勾选记录 */
        $('.cart-item-cb:checked').each(function() {
            ids.push($(this).parents('[data-cart-item-id]').attr('data-cart-item-id'));
        });

        $('.deletLayer').attr("rel", ids);
        $('.deletLayer').show();
    } else {
        $('.deletLayer').attr("rel", "");
        $('.leastLayer').fadeIn(300);
    }
    $(document).on('click', '.deletBtn', delSelectedBtnOnClick);
};
$(document).on('click', '.deletBtn', delSelectedBtnOnClick);
/** 删除已选择商品按钮点击 END */

/** 添加收藏夹 */
$(document).on('click','.removeOneItem',function(){
    $('.removeLayer').attr("rel", $(this).attr("rel"));
    $('.removeLayer').show();
});

/** 批量添加收藏夹 START */
$(document).on('click','.removeBatchItem',function(){
    if(isCartItemIdsChecked()) {
        $('.removeLayer').fadeIn(300);
    } else {
        $('.leastLayer').fadeIn(300);
    }
});

var addSelectedToFavOnClick = function(event) {
    $(document).off('click', '.doMoveToFav', addSelectedToFavOnClick);
    var $this = $(this);
    var orginTxt = $this.text();
    var ids = [];
    var rel = $this.parents('.removeLayer').attr('rel');
    if(rel && rel.length > 0) {
        ids = rel.split(',');
    } else {
        /** 获取已勾选记录 */
        $('.cart-item-cb:checked').each(function() {
            ids.push($(this).parents('[data-cart-item-id]').attr('data-cart-item-id'));
        });
    }
    for(var i in ids) {
        ids[i] = ("" + ids[i]).trim();
    }

    var $dialog = $(this).parents(".coverCon");
    moveItemToFav({
        ids: ids,
        beforeSend: function() {
            $dialog.find(".msg-info").text("处理中...").fadeIn(300);
            $(document).off('click', '.doMoveToFav', addSelectedToFavOnClick);
        },
        success: function(data) {
            $dialog.find(".msg-info").text("已加入收藏夹").fadeIn(300);
            window.setTimeout(function() {
                $dialog.find(".msg-info").text("").fadeOut(200);
                $dialog.parent().fadeOut(500);
            }, 500);
            $(document).on('click', '.doMoveToFav', addSelectedToFavOnClick);

        },
        error: function(error, message) {
            $dialog.find(".msg-info").text("处理失败，请稍后再试！").hide();
            $dialog.find(".msg-error").fadeIn(300);
            $(document).on('click', '.doMoveToFav', addSelectedToFavOnClick);
        }
    });
};
$(document).on('click', '.doMoveToFav', addSelectedToFavOnClick);
/** 批量添加收藏夹 END */

/** 清除下架商品 START */
var deleteInvalidOnClick = function() {
    $(document).off('click', '.clearGoods', deleteInvalidOnClick);
    var $this = $(this);
    var orginTxt = $this.text();
    $.ajax({
        url: "/cart/myCart/invalidDel.json",
        type: "POST",
        dataType: "json",
        data: {
            random: Math.random()
        },
        beforeSend: function() {
            $this.text("处理中...");
            $(document).off('click', '.clearGoods', deleteInvalidOnClick);
        },
        success: function(result) {
            //console.debug("result: %o", result);
            /** 删除成功后，修改页面显示 */
            if(result.status == 0 || result.status == "0" || result.status == "success") {
                if(result.data) {
                    updateCartShow(result.data);
                    $this.text("已清除所有下架商品！");
                    window.setTimeout(function() {
                        $this.fadeOut(200);
                        $this.text(orginTxt);
                        $this.fadeIn(200);
                    }, 500);
                }

            }
            $(document).on('click', '.clearGoods', deleteInvalidOnClick);
        },
        error: function(jqXHR, textStatus, errorThrown) {
            //$dialog.find(".msg-info").text("").hide();
            //$dialog.find(".msg-error").fadeIn(300);
            //$(document).on('click', '.doCartItemDel', doCartItemDelFunc);
            console.error("Ajax Error: [%s], error: [%s], jqXHR: [%o]", textStatus, errorThrown, jqXHR);
            $this.text("处理失败，请稍后再试！");
            window.setTimeout(function() {
                $this.fadeOut(200);
                $this.text(orginTxt);
                $this.fadeIn(200);
            }, 500);
            $(document).on('click', '.clearGoods', deleteInvalidOnClick);
        }
    });
};
$(document).on('click', '.clearGoods', deleteInvalidOnClick);
/** 清除下架商品 END */

/** 去结算按钮点击 START */
var goOrderSubmitOnClick = function() {

    if(isCartItemIdsChecked()) {
        var ids = [];
        /** 获取已勾选记录 */
        $('.cart-item-cb:checked').each(function() {
            ids.push($(this).parents('[data-cart-item-id]').attr('data-cart-item-id'));
        });

        $.ajax({
            url: "/cart/order/newOrder.json",
            type: "POST",
            dataType: "json",
            data: {
                cartItemIds: ids.join(","),
                random: Math.random()
            },
            beforeSend: function() {
                $(document).off('click', '#go-order-comfirm', goOrderSubmitOnClick);
            },
            success: function(result) {
                //console.debug("result: %o", result);
                /** 删除成功后，修改页面显示 */
                if(result.status == "success") {
                    window.location.href = "/cart/order/orderInfo?r=" + result.data.orderTmpId;
                } else {
                    console.error("Ajax Error: [%s], message: [%s]",result.data.error, result.data.message);
                }
                $(document).on('click', '#go-order-comfirm', goOrderSubmitOnClick);
            },
            error: function(jqXHR, textStatus, errorThrown) {
                $(document).on('click', '#go-order-comfirm', goOrderSubmitOnClick);
            }
        });
    } else {
        $('.leastLayer').fadeIn(300);
    }
};
$(document).on('click', '#go-order-comfirm', goOrderSubmitOnClick);
/** 去结算按钮点击 END */

$(document).on('click','.coverLayer .close, .coverLayer [rel=close]',function(){
    $(this).parents(".coverLayer").fadeOut(500);
    //$('.removeLayer').show();
});
$(document).on(AreaSelectPlugin.EVENT_KEYS.AREA_SELECTED, '#areaCode', function(event, selectedProv, selectedCity, selectedArea, selectedTown) {

    var data = {};

    if(selectedTown && (selectedTown + "").trim() != "") {
        data.areaCode = selectedTown;
    } else if(selectedArea && (selectedArea + "").trim() != "") {
        data.areaCode = selectedArea;
    } else if(selectedCity && (selectedCity + "").trim() != "") {
        data.areaCode = selectedCity;
    } else if(selectedProv && (selectedProv + "").trim() != "") {
        data.areaCode = selectedProv;
    }

    $.ajax({
        url: "/cart/myCart/refresh.json",
        data: data,
        beforeSend: function() {

        },
        success: function(result) {
            console.debug("refresh res: %o", result);
            if(result.status == "success") {
                updateCartShow(result.data);
            } else {
                alert("刷新第三方库存状态失败！");
            }

        }
    });
});
