var payTabViewModel = {sameAsAchiever: true};

function renderPayTabView(receiptAddressView) {
    var $v = $('#payment-tab-view');
    $v.html(template('_payment_tab_view', payTabViewModel));
    $v.find('.dropdown-menu.area-select').each(function () {
        /** 省份下拉框 */
        var $this = $(this);
        $this.empty();
        var level = 1;
        if ($this.hasClass('province')) {
            level = 1
        } else if ($this.hasClass('city')) {
            level = 2
        } else if ($this.hasClass('area')) {
            level = 3
        } else if ($this.hasClass('town')) {
            level = 4
        }
        $this.areaSelectDropDown(level);
    });

    var data = deepCopy(receiptAddressView.viewModel);
    data.showAddBtn = false;
    data.showInput = false;
    data.showMoreBtn = false;
    data.showAll = false;
    if (receiptAddressView.configs.cached) {
        var render = receiptAddressView.getCachedRender(receiptAddressView.configs.listTplId);
        /** 发票收件人，同已选择收件人 */
        $("#achieverAddressView").html(render ? render(data) : "");
    } else {
        /** 发票收件人，同已选择收件人 */
        $("#achieverAddressView").html(template(receiptAddressView.configs.listTplId, data));
    }
}

var showLoading = function () {
    $(document).off('click', '#submit-order-btn', submintOrderEvent);
    $('#submit-order-btn').addClass('disabled');
};

var hideLoading = function () {
    $(document).off('click', '#submit-order-btn', submintOrderEvent);
    $(document).on('click', '#submit-order-btn', submintOrderEvent);
    $('#submit-order-btn').removeClass('disabled');
};

var showLoadingModal = function () {
    var m = $("#common-message-modal");
    m.find('.messageTitle').hide();
    m.find('.messageTitle h5').text("");
    m.find('.messageInfo .msg-content').text("数据加载中，请稍候...");
    m.removeClass('f-hide').show();
};

/* 显示和隐藏收货地址*/
$(document).on('click', '.js-address', function () {
    var div = $('.optionAddress');
    if (div.css("display") === "none") {
        div.removeClass('f-hide');
        div.parents('.achieverAddress').addClass('achieverAddressHeight');
        $(this).find('.downIcon').addClass('f-hide');
        $(this).find('.pullIcon').removeClass('f-hide');
    } else {
        div.addClass('f-hide');
        div.parents('.achieverAddress').removeAttr('height');
        div.parents('.achieverAddress').removeClass('achieverAddressHeight');
        $(this).find('.downIcon').removeClass('f-hide');
        $(this).find('.pullIcon').addClass('f-hide');
    }
});

$(document).on('click', '.cancleBtn', function () {
    $('.editAddrCoverLayer').empty().addClass('f-hide');
    $('.coverLayer').addClass('f-hide');
    $('.deleteCoverLayer').addClass('f-hide');
    $('.cancleOrderLayer').addClass('f-hide');
});
$(document).on('click', '.closeBtn', function () {
    $('.coverLayer').addClass('f-hide');
    $('.deleteCoverLayer').addClass('f-hide');
    $('.cancleOrderLayer').addClass('f-hide');
    $('.editAddrCoverLayer').empty().addClass('f-hide');
});

/* 删除收货地址*/
$(document).on('click', '.deleteAddress', function () {
    $('#deleteCoverLayer').find('a.confirmBtn').attr('rel', $(this).attr('rel'));
    $('#deleteCoverLayer').removeClass('f-hide');
});

function needBillsChg() {
    //$(document).off('change', '.needBills input', needBillsChg);
    var $this = $(this);
    var isChecked = $this.is(":checked") || $this.attr("checked");
    if (isChecked) {
        $this.parents('.payment-tab').find('.bills-content').show();
        payTabViewModel.needBills = true;
    } else {
        $this.parents('.payment-tab').find('.bills-content').hide();
        payTabViewModel.needBills = false;
    }
    //$(document).on('change', '.needBills input', needBillsChg);
}

// 购物车前台公用表单校验插件初始化
var initAddressEditValidator = function (form) {
    var placeError = function (e, err) {
        /** 个性化处理message */
        /*larry modify*/
        var errEl = e.nextAll(".layerTip");
        if (e.attr("id") != "rcvAdd-addressDetail" && e.attr("id") != "rcvAdd-phone" && e.attr("id") != "rcvAdd-username") {
            if (errEl && errEl.length > 0) {
                errEl.text(err.text().replace(/{tipTitle}/g, (e.attr('tip-title') ? e.attr('tip-title') : '该字段')));
                errEl.show();
            } else {
                err.text(err.text().replace(/{tipTitle}/g, (e.attr('tip-title') ? e.attr('tip-title') : '该字段')));
                err.addClass("layerTip").insertAfter(e);
            }
        }
    };
    form = $(form);
    return form.validate({
        errorElement: "p", // 错误提示的DOM元素类型，默认为label<p>错误信息</p>
        errorPlacement: function (err, e) {
            placeError(e, err);
        },
        highlight: function (element, errorClass) {
            var e = $(element);
            placeError(e, $("p"));
            //var error = e.nextAll(".layerTip");
            //if(error && error.length > 0) {
            //    error.addClass(errorClass).show();
            //}
        },
        unhighlight: function (element, errorClass) {
            var error = $(element).nextAll(".layerTip");
            if (error && error.length > 0) {
                error.removeClass(errorClass).hide();
            }
        }
    });
};

$(document).on('change', '.needBills input', needBillsChg);

/*改变radio样式*/
$(document).on('click', '.deduction', function () {
    var $useScorePay = $("input[name='useScorePay']");
    if ($useScorePay.prop("checked")) {
        $useScorePay.prop("checked", false);
        $useScorePay.val("0");
        $(".deduction label").hide();
        $("#payScore").hide();
        $(".useScore").hide();
        $(".noUseScore").show();
    } else {
        $useScorePay.prop("checked", true);
        $useScorePay.val("1");
        $(".deduction label").show();

        //$('.glyphicon-record').css('color','#d12a3e');
        $("#payScore").show();
        $(".useScore").show();
        $(".noUseScore").hide();
    }

    /*var self = $(this);
    var box = self.find('input');
    var isCheck = box.attr("checked");
    if (isCheck) {
        box.attr('checked', false);
        box.val("0");
        $("#payScore").hide();
        $(".useScore").hide();
        $(".noUseScore").show();
    } else {
        box.attr('checked', true);
        box.val("1");
        $('.glyphicon-record').css('color','#d12a3e');
        $("#payScore").show();
        $(".useScore").show();
        $(".noUseScore").hide();
    }*/
})

/*订单用途*/
$(document).on('click', '.purpose>li>a', function () {
    $(this).addClass('purposeDefult');
    $(this).parent('li').siblings().find('a').removeClass('purposeDefult');
});

$(document).on('keyup blur change', '[data-copy-to]', function () {
    var copyTo = $(this).attr('data-copy-to');
    var minLen = $(this).attr('data-copy-min-len');
    if (minLen) {
        minLen = Number(minLen);
    } else {
        minLen = 1;
    }
    $("#" + copyTo).val('');
    if ($(this).val().length >= minLen) {
        $("#" + copyTo).val($(this).val());
    }
});

$(document).on('ready', function () {
    $('.as-select [rel-value]').each(function () {
        var $this = $(this);
        var n = $(this).parents('.as-select').attr('rel-name');
        var v = $(this).attr('rel-value');
        var obj = $('input[name="' + n + '"]');
        if ($(this).attr('default')) {
            obj.val(v);
        }
    });


    $(document).on('click', '.as-select [rel-value]', function () {
        var n = $(this).parents('.as-select').attr('rel-name');
        var v = $(this).attr('rel-value');
        var obj = $('input[name="' + n + '"]');
        obj.val(v).trigger('change');
        /** 清除校验信息事件 */
        if (v && $.trim(v) != '') {
            $(this).parents('.as-select').nextAll('.layerTip-as-select').hide();
        }
    });
});


var submintOrderEvent = function () {
    loginValidate(submintOrderEvent_login);
};

function submintOrderEvent_login() {
    $(document).off('click', '#submit-order-btn', submintOrderEvent);
    var canNext = $(this).attr('canNext');
    /** 表单校验 */
        // 订单用途选项校验
    var orderUsageValidFlag = true;
    var orderUsageCodeVal = $('#orderUsageCodeVal').val();
    var ui = $('[rel-name="' + $('#orderUsageCodeVal').attr('name') + '"]');
    var d = ui.nextAll('.layerTip-as-select');
    var addressId = $("#addressId").val();
    if (typeof addressId != 'undefined' && $.trim(addressId) != "") {
        orderUsageValidFlag = orderUsageValidFlag && true;
        $("#noRecvAddressError").addClass('f-hide').hide();
    } else {
        $("#noRecvAddressError").removeClass('f-hide').show();
        $(document).off('click', '#submit-order-btn', submintOrderEvent);
        $(document).on('click', '#submit-order-btn', submintOrderEvent);
        orderUsageValidFlag = orderUsageValidFlag && false;
    }
    /** 订单用途校验 */
    //if(orderUsageCodeVal && typeof orderUsageCodeVal != 'undefined' && $.trim(orderUsageCodeVal) != '') {
    //    orderUsageValidFlag = true;
    //    d && d.hide();
    //} else {
    //    if(!d || d.length <= 0) {
    //        d = $(document.createElement('p'));
    //        d.addClass('layerTip-as-select');
    //        ui.after(d);
    //    }
    //    d.text('请选择订单用途').show();
    //    orderUsageValidFlag = false;
    //}

    if (canNext != false) {
        if ($("#insured-order-info-form").valid() && orderUsageValidFlag) {
            $("#insured-order-info-form")[0].submit();
            //alert("no error !");
        }
    } else {
        $('#cantBuyInfoModal').removeClass('f-hide');
        $(document).off('click', '#submit-order-btn', submintOrderEvent);
        $(document).on('click', '#submit-order-btn', submintOrderEvent);
    }
}

$(document).off('click', '#submit-order-btn', submintOrderEvent);
$(document).on('click', '#submit-order-btn', submintOrderEvent);


$(document).ready(function () {
    /** 封装地区下拉校验 */
    var validAreaDropDowns = function () {
        $('.area-select-tip').hide();
        var areaSelected = true;

        var provinceCode = $.trim($('#rcvAdd-provCode-input').val());
        var cityCode = $.trim($('#rcvAdd-cityCode-input').val());
        var areaCode = $.trim($('#rcvAdd-areaCode-input').val());
        var townCode = $.trim($('#rcvAdd-townCode-input').val());

        if ($('#rcvAdd-provCode').parents('.dropdown').is(':visible')) {
            areaSelected = areaSelected && typeof provinceCode != 'undefined' && provinceCode != ''
            if (typeof provinceCode == 'undefined' || $.trim(provinceCode) == '') {
                $('#area-select-tip01').text("请选择省").show();
            }
        }
        if ($('#rcvAdd-cityCode').parents('.dropdown').is(':visible')) {
            areaSelected = areaSelected && typeof cityCode != 'undefined' && cityCode != '';
            if (typeof cityCode == 'undefined' || $.trim(cityCode) == '') {
                $('#area-select-tip02').text("请选择市").show();
            }
        }
        if ($('#rcvAdd-areaCode').parents('.dropdown').is(':visible')) {
            areaSelected = areaSelected && typeof areaCode != 'undefined' && areaCode != '';
            if (typeof areaCode == 'undefined' || $.trim(areaCode) == '') {
                $('#area-select-tip03').text("请选择区").show();
            }
        }
        if ($('#rcvAdd-townCode').parents('.dropdown').is(':visible')) {
            areaSelected = areaSelected && typeof townCode != 'undefined' && townCode != '';
            if (typeof townCode == 'undefined' || $.trim(townCode) == '') {
                $('#area-select-tip04').text("请选择街道").show();
            }
        }

        if (areaSelected) {
            $('.area-select-tip').hide();
        }

        return areaSelected;
    };

    var $form = initDefaultValidator("#insured-order-info-form");

    /** 封装配送地址相关操作 */
    var ReceiptAddressView = {
        createNew: function (parameters) {
            var obj = {};
            obj.configs = {
                id: "",
                listTplId: "",
                selectedTplId: "",
                cached: true,
                maxRetry: 5, // 出错重试次数
                retrySpan: 1000, // 出错重试间隔
                dataReqUrl: "/score/memberAddress/list.json",
                displayAddrLen: 9999999999999999999999999 // 显示地址最多显示字符数，超出部分以"..."代替

            };
            $.extend(obj.configs, parameters);
            obj.rootEl = $("#" + obj.configs.id);
            obj.cachedRender = {};
            obj.cachedTemplate = null;
            obj.viewModel = {};
            obj.dataCache = {};
            obj.selectedAddrId = "";


            obj.loadRender = function (tplName) {
                var scriptObj = $("#" + tplName);
                if (scriptObj && scriptObj.length > 0) {
                    var tplSrc = scriptObj.text();
                    /** 兼容其它浏览器 */
                    if ($.trim(tplSrc) == '') {
                        /** text()方法获取不到，用html()可以获取的浏览器 */
                        tplSrc = scriptObj.html();
                        tplSrc = tplSrc ? $.trim(tplSrc) : tplSrc;
                    }
                    if ($.trim(tplSrc) == '') {
                        /** text()、html()都获取不到的浏览器，用script的text属性获取 */
                        tplSrc = $.trim(scriptObj[0].text);
                    }

                    obj.cachedRender[tplName] = template.compile(tplSrc);
                    return obj.cachedRender[tplName];
                } else {
                    return null;
                }
            };

            obj.getCachedRender = function (tplName) {
                if (obj.configs.cached) {
                    var render = obj.cachedRender[tplName];
                    if (!render || typeof render == 'undefined') {
                        render = obj.loadRender(tplName);
                    }
                    return render;
                }

                return null;
            };

            obj.updateView = function (data) {
                var listHtml = "", selectedHtml = "";

                /** 模板数据预处理 */
                if (data.defAddr) {
                    //if(data.defAddr.displayAddress.length >= obj.configs.displayAddrLen) {
                    //    data.defAddr.displayAddress = data.defAddr.displayAddress.substring(0, obj.configs.displayAddrLen) + "..."
                    //}
                }
                if (data.addrList) {
                    //for(var k in data.addrList) {
                    //    if(data.addrList[k].displayAddress.length >= obj.configs.displayAddrLen) {
                    //        data.addrList[k].displayAddress = data.addrList[k].displayAddress.substring(0, obj.configs.displayAddrLen) + "..."
                    //    }
                    //}
                }

                data.showAddBtn = true;
                data.showInput = true;
                data.showMoreBtn = true;
                if (obj.configs.cached) {
                    var render = obj.getCachedRender(obj.configs.listTplId);
                    listHtml = render ? render(data) : "";
                    /** 发票收件人，同已选择收件人 */
                    data.showAddBtn = false;
                    data.showInput = false;
                    data.showMoreBtn = false;
                    data.showAll = false;
                    $("#achieverAddressView").html(render ? render(data) : "");

                    render = obj.getCachedRender(obj.configs.selectedTplId);
                    selectedHtml = render ? render(data) : "";

                } else {
                    listHtml = template(obj.configs.listTplId, data);
                    selectedHtml = template(obj.configs.selectedTplId, data);
                    /** 发票收件人，同已选择收件人 */
                    data.showAddBtn = false;
                    data.showInput = false;
                    data.showMoreBtn = false;
                    data.showAll = false;
                    $("#achieverAddressView").html(template(obj.configs.listTplId, data));
                }
                obj.rootEl.empty().html(listHtml);
                $("#selected-addr-show").html(selectedHtml);


                /* 重新绑定事件 */
                /** 显示编辑按钮 */
                obj.rootEl.find('.options').mouseover(function () {
                    var self = $(this);
                    var ads = self.find('.operationAddress');
                    ads.removeClass('f-hide');
                });
                obj.rootEl.find('.options').mouseleave(function () {
                    var self = $(this);
                    var ads = self.find('.operationAddress');
                    ads.addClass('f-hide');
                })
            };

            obj.updateMemberAddress = function (parameters) {
                var configs = {
                    success: function (data) {
                    },
                    beforeSend: function () {
                    },
                    error: function (code, message) {
                    },
                    retryCounts: 0,
                    showAll: false
                };
                $.extend(configs, parameters);
                var data = {
                    random: Math.random(),
                    noMask: 1
                };
                $.ajax({
                    url: obj.configs.dataReqUrl,
                    data: data,
                    type: "GET",
                    dataType: "json",
                    beforeSend: function () {
                        obj.rootEl.empty();
                        if (configs.beforeSend && (typeof configs.beforeSend).toLowerCase() == "function") {
                            configs.beforeSend();
                        }
                    },
                    success: function (result) {
                        result = FastJson.format(result);
                        //console.debug("result: %o", result);
                        if (result.status == "success") {
                            obj.dataCache = result.data;
                            configs.retryCounts = 0;
                            /** 查找默认地址 */
                            obj.viewModel = {};
                            obj.viewModel.showAll = configs.showAll;
                            obj.viewModel.addrList = result.data;
                            if (result.data.length == 1 && !result.data[0].isDefault) {
                                obj.viewModel.defAddr = result.data[0];
                                obj.viewModel.addrList = [];
                            } else if (result.data.length <= 0) {
                                obj.viewModel.noData = true;
                                obj.viewModel.defAddr = null;
                                obj.viewModel.addrList = [];
                            } else {
                                for (var k in result.data) {
                                    if (obj.selectedAddrId && obj.selectedAddrId != '') {
                                        if (result.data[k].id == obj.selectedAddrId) {
                                            obj.viewModel.defAddr = result.data[k];
                                            obj.viewModel.selectedAddrId = obj.selectedAddrId;
                                            obj.viewModel.addrList.splice(k, 1);
                                            break;
                                        }
                                    } else {
                                        if (result.data[k].isDefault) {
                                            obj.viewModel.defAddr = result.data[k];
                                            obj.viewModel.addrList.splice(k, 1);
                                            obj.viewModel.selectedAddrId = obj.viewModel.defAddr.id;
                                            obj.selectedAddrId = obj.viewModel.defAddr.id;
                                            break;
                                        }
                                    }
                                }

                                if (obj.viewModel.defAddr == {} || typeof obj.viewModel.defAddr == 'undefined' || obj.viewModel.defAddr == null) {
                                    obj.viewModel.defAddr = obj.viewModel.addrList[0];
                                    obj.viewModel.addrList.splice(0, 1);
                                }
                            }
                            obj.defAddr = obj.viewModel.defAddr;
                            obj.viewModel.showMenu = false;
                            obj.selectedAddrId = typeof obj.viewModel.defAddr != 'undefined' && obj.viewModel.defAddr != null ? obj.viewModel.defAddr.id : "";
                            obj.updateView(obj.viewModel);

                            if (configs.success && (typeof configs.success).toLowerCase() == "function") {
                                configs.success(result.data);
                            }
                        } else {
                            if (++configs.retryCounts <= obj.configs.maxRetry) {
                                //console.debug("configs.retryCounts: %o", configs.retryCounts);
                                window.setTimeout(function () {
                                    obj.updateMemberAddress(configs)
                                }, obj.configs.retrySpan);
                            } else {
                                configs.retryCounts = 0;
                                if (configs.error && (typeof configs.error).toLowerCase() == "function") {
                                    configs.error(result.error, result.message);
                                }
                            }
                        }

                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        if (typeof console.info != 'undefined') {
                            //console.info("Ajax Error: [%s], error: [%s], jqXHR: [%o]", textStatus, errorThrown, jqXHR);
                        }
                        if (++configs.retryCounts <= obj.configs.maxRetry) {
                            //console.debug("configs.retryCounts: %o", configs.retryCounts);
                            window.setTimeout(function () {
                                obj.updateMemberAddress(configs)
                            }, obj.configs.retrySpan);
                        } else {
                            configs.retryCounts = 0;
                            if (configs.error && (typeof configs.error).toLowerCase() == "function") {
                                configs.error(textStatus, jqXHR + textStatus + errorThrown + "");
                            }
                        }
                    },
                    complete: function () {
                        phoneMask();
                    }
                });
            };

            obj.findDataInCache = function (k, v) {
                for (var i in obj.dataCache) {
                    if (obj.dataCache[i][k] == v) {
                        return obj.dataCache[i];
                    }
                }

                if (obj.defAddr && obj.defAddr[k] == v) {
                    return obj.defAddr;
                }

                return null;
            };

            obj.seleceArea = function (id) {
                var data = obj.findDataInCache("id", id);
                if (data && typeof data != 'undefined') {
                    obj.selectedAddrId = data.id;
                    obj.viewModel.selectedAddrId = data.id;
                }
            };

            obj.init = function () {
                obj.loadRender(obj.configs.listTplId);
                obj.loadRender(obj.configs.selectedTplId);
                receiptAddressView.updateMemberAddress({
                    showAll: false, success: function () {
                        var data = obj.findDataInCache("id", obj.selectedAddrId);
                        obj.rootEl.trigger('areaSelected', data);
                    }
                });
            };

            return obj;
        }
    };

    var receiptAddressView = ReceiptAddressView.createNew({
        id: "receiptAddressView",
        listTplId: "_receiptAddressTpl",
        selectedTplId: "_selectedAddrTpl"
    });
    receiptAddressView.init();

    var onAreaSelected = function (e, selecedArea) {
        $("#pay").addClass("disabled");
        if (selecedArea) {
            var data = {};
            data.areaCode = selecedArea.areaCode ? selecedArea.areaCode : selecedArea.cityCode;
            data.areaCode = data.areaCode ? data.areaCode : selecedArea.provinceCode;
            data.rid = $("#rid").val();
            data.getShippingFee = true;
            data.addressId = $('input[name="addressId"]').val();
            $.ajax({
                url: "/score/order/refreshTmpOrder",
                data: data,
                beforeSend: function () {
                    showLoading();
                },
                success: function (result) {
                    hideLoading();
                    if (result.status == "success") {
                        var item;
                        var canNext = true;
                        for (var sk in result.data.storeList) {
                            for (var ik in result.data.storeList[sk].orderItems) {
                                item = result.data.storeList[sk].orderItems[ik];
                                var stockState = 0; // 0-- 有货， 1-- 紧张， 2-- 无货
                                /** 有货无货标志修改 */
                                if (item.stockCount == 0) {
                                    stockState = 2;
                                    canNext = false;
                                } else if (item.stockCount < 0) {
                                    stockState = item.status == "1" ? 0 : 2;
                                    canNext = item.status == "1" ? true : false;
                                } else {
                                    if (item.lackRemind) {
                                        if (item.stockCount - item.count <= item.lackRemind) {
                                            stockState = 1;
                                        }
                                    }

                                    if (item.stockCount >= item.count) {
                                        stockState = stockState == 1 ? 1 : 0;
                                    } else {
                                        stockState = 2
                                    }
                                }

                                switch (stockState) {
                                    case 0:
                                        $('.cartitemIds[value="' + item.productFashionId + '"]').parents('.row').find('.stockLackFlag').text('有货').css({color: 'rgb(51, 51, 51)'});
                                        canNext = true;
                                        break;
                                    case 1:
                                        $('.cartitemIds[value="' + item.productFashionId + '"]').parents('.row').find('.stockLackFlag').text('库存紧张').css({color: 'red'});
                                        canNext = true;
                                        break;
                                    case 2:
                                        $('.cartitemIds[value="' + item.productFashionId + '"]').parents('.row').find('.stockLackFlag').text('无货').css({color: 'red'});
                                        canNext = false;
                                        break;
                                }
                            }
                        }

                        if (result.data.sumShippingFee && !result.data.freeShippingFee) {

                            $(".shipping-fee-show").html(accounting.formatNumber(result.data.sumShippingFee, 2, ",", "."));
                            // $(".sum-price-show").html('￥'+accounting.formatNumber(result.data.sumShippingFee + result.data.sumPrice, 2, ",", "."));
                        }

                        if (canNext) {
                            $('#cantBuyInfoModal').addClass('f-hide');
                            $('#submit-order-btn').removeClass('disabled').attr('canNext', true);
                            $(document).off('click', '#submit-order-btn', submintOrderEvent);
                            $(document).on('click', '#submit-order-btn', submintOrderEvent);
                            $("#pay").removeClass("disabled");
                        } else {
                            $('#cantBuyInfoModal').removeClass('f-hide');
                            $('#submit-order-btn').addClass('disabled').attr('canNext', false);
                            $(document).off('click', '#submit-order-btn', submintOrderEvent);
                        }
                    } else {
                        alert("刷新第三方库存状态失败！");
                    }
                },
                error: function () {
                    hideLoading();
                }
            });
        }
        //alert(ids.join(','));
    };
    var onAreaSelected_bak = function (e, selecedArea) {
        var ids = [];
        $('.cartitemIds').each(function () {
            ids.push($(this).val());
        });

        if (selecedArea) {
            var data = {};
            data.areaCode = selecedArea.areaCode ? selecedArea.areaCode : selecedArea.cityCode;
            data.areaCode = data.areaCode ? data.areaCode : selecedArea.provinceCode;
            data.cartItemIds = ids;
            data.getShippingFee = false;// 积分商城暂不计算运费
            data.addressId = $('input[name="addressId"]').val();
            $.ajax({
                url: "/score/myCart/refresh.json",
                data: data,
                beforeSend: function () {
                    showLoading();
                },
                success: function (result) {
                    hideLoading();
                    if (result.status == "success") {
                        var item;
                        var canNext = true;
                        for (var gk in result.data.cartItemGroups) {
                            for (var ik in result.data.cartItemGroups[gk].cartItems) {
                                item = result.data.cartItemGroups[gk].cartItems[ik];
                                var stockState = 0; // 0-- 有货， 1-- 紧张， 2-- 无货
                                /** 有货无货标志修改 */
                                if (item.productFashion.stockCount <= 0) {
                                    stockState = 2;
                                    canNext = false;
                                } else {
                                    if (item.productFashion.lackRemind) {
                                        if (item.productFashion.stockCount - item.count <= item.productFashion.lackRemind) {
                                            stockState = 1;
                                        }
                                    }

                                    if (item.productFashion.stockCount >= item.count) {
                                        stockState = stockState == 1 ? 1 : 0;
                                    } else {
                                        stockState = 2
                                    }
                                }

                                switch (stockState) {
                                    case 0:
                                        $('.cartitemIds[value="' + item.id + '"]').parents('.row').find('.stockLackFlag').text('有货').css({color: 'rgb(51, 51, 51)'});
                                        canNext = true;
                                        break;
                                    case 1:
                                        $('.cartitemIds[value="' + item.id + '"]').parents('.row').find('.stockLackFlag').text('库存紧张').css({color: 'red'});
                                        canNext = true;
                                        break;
                                    case 2:
                                        $('.cartitemIds[value="' + item.id + '"]').parents('.row').find('.stockLackFlag').text('无货').css({color: 'red'});
                                        canNext = false;
                                        break;
                                }
                            }
                        }

                        if (result.data.shippingFee) {
                            $("#shipping-fee-show").text(accounting.formatNumber(result.data.shippingFee, 2, ",", "."));
                        }

                        if (canNext) {
                            $('#cantBuyInfoModal').addClass('f-hide');
                            $('#submit-order-btn').removeClass('disabled').attr('canNext', true);
                            $(document).off('click', '#submit-order-btn', submintOrderEvent);
                            $(document).on('click', '#submit-order-btn', submintOrderEvent);
                        } else {
                            $('#cantBuyInfoModal').removeClass('f-hide');
                            $('#submit-order-btn').addClass('disabled').attr('canNext', false);
                            $(document).off('click', '#submit-order-btn', submintOrderEvent);
                        }
                    } else {
                        alert("刷新第三方库存状态失败！");
                    }
                },
                error: function () {
                    hideLoading();
                }
            });
        }
        //alert(ids.join(','));
    };
    $('#receiptAddressView').on('areaSelected', onAreaSelected);

    /** 后台提交删除收货地址 */


    var addrDelConfirmBtnClick = function () {
        loginValidate(addrDelConfirmBtnClick_login);
    };

    function addrDelConfirmBtnClick_login() {
        $(document).off('click', '#addrDelConfirmBtn', addrDelConfirmBtnClick);
        var ids = [];
        var id = $('#addrDelConfirmBtn').attr('rel');
        ids.push(id);
        //ids.push($(this).attr('rel'));
        var $this = $(this);
        $.ajax({
            url: "/score/memberAddress/delete",
            data: {ids: ids, random: Math.random()},
            type: "GET",
            dataType: "json",
            beforeSend: function () {
                $(document).off('click', '#addrDelConfirmBtn', addrDelConfirmBtnClick);
            },
            success: function (result) {
                result = FastJson.format(result);
                receiptAddressView.updateMemberAddress({showAll: true});
                $(document).on('click', '#addrDelConfirmBtn', addrDelConfirmBtnClick);
                $('.deleteCoverLayer').addClass('f-hide');
            },
            error: function (jqXHR, textStatus, errorThrown) {
                if (typeof console.info != 'undefined') {
                    console.info("Ajax Error: [%s], error: [%s], jqXHR: [%o]", textStatus, errorThrown, jqXHR);
                }
                $(document).on('click', '#addrDelConfirmBtn', addrDelConfirmBtnClick);
                $('.deleteCoverLayer').addClass('f-hide');
            }
        });
    }

    $(document).on('click', '#addrDelConfirmBtn', addrDelConfirmBtnClick);
    $(document).on('click', '.editorAddress, .addReceiptAddress', function () {
        var id = $(this).attr('rel');
        //console.debug("editing id: %o",id);
        var data = {};
        if (typeof  id != 'undefined' && id != '') {
            data = receiptAddressView.findDataInCache("id", id);
        }
        var html = template("_memberAddressTpl", data);
        $('.editAddrCoverLayer').html(html).removeClass('f-hide');
        initAddressEditValidator('#memberAddressAddForm');

        /** 初始化地区选择下拉框 */
        $('.dropdown-menu.area-select').each(function () {
            /** 省份下拉框 */
            var $this = $(this);
            //$this.empty();
            var level = 1;
            if ($this.hasClass('province')) {
                level = 1;
                $this.areaSelectDropDown(level);
            } else if ($this.hasClass('city')) {
                level = 2
            } else if ($this.hasClass('area')) {
                level = 3
            } else if ($this.hasClass('town')) {
                level = 4
            }
        });
        $('#rcvAdd-provCode-input, #rcvAdd-cityCode-input, #rcvAdd-areaCode-input, #rcvAdd-townCode-input').on('change', function () {
            //console.info("changed");
            validAreaDropDowns();
        });

    });
    $(document).on('click', '.addReceiptAddress', function () {
        $('.detailed-address').addClass('f-hide');
    })

    /** 选择地址点击 */
    $(document).on('click', '.selectAddr', function () {
        var id = $(this).attr('rel');
        receiptAddressView.seleceArea(id);
        receiptAddressView.updateMemberAddress({
            showAll: true, success: function () {
                var div = $('.optionAddress');
                div.addClass('f-hide');
                div.parents('.achieverAddress').removeAttr('height');
                div.parents('.achieverAddress').removeClass('achieverAddressHeight');
                $('.downIcon').removeClass('f-hide');
                $('.pullIcon').addClass('f-hide');
                var data = receiptAddressView.findDataInCache("id", id);
                receiptAddressView.rootEl.trigger('areaSelected', data);
            }
        });

    });

// 编辑按钮弹窗收货人只输入汉字
    function chineseInput1(obj) {
        obj = $(obj);
        //alert(obj);
        evt = window.event;
        var editNameInput = $('.rcvAdd-username');
        var editName = $('.rcvAdd-username').val();
        var chinese = /^[\u4e00-\u9fa5|a-zA-Z]+$/;
        var chineseFlag = chinese.test(obj.val());
        if (obj.val() == "" || obj.val() == null || obj.val() == undefined) {
            obj.next().html('请输入收货人');
            obj.next().show();
            return false;
        } else if (!chineseFlag) {
            obj.next().html('请核对收货人是否输入正确');
            obj.next().show();
            return false;
        }
        return true;
    }

    //编辑按钮弹窗手机号码校验
    function testPhone1(obj) {
        obj = $(obj);
        var editTel = $('.rcvAdd-phone').val();
        var editTelInput = $('.rcvAdd-phone');
        var pattern = /^1(3|4|5|7|8)\d{9}$///验证手机号码的格式
        var phoneFlag = pattern.test(obj.val());
        if (obj.val() == "" || obj.val() == null || obj.val() == undefined) {
            obj.next().html('请输入手机号码');
            obj.next().show();
            return false;
        } else if (!phoneFlag || obj.val().length < 11) {
            obj.next().html('请核对手机号码是否输入正确');
            obj.next().show();
            return false;
        }
        return true;
    }

    //编辑按钮弹窗详细地址校验
    function addDetailsAddr1(obj) {
        obj = $(obj);
        var editDetailsAddr = $('.rcvAdd-addressDetail').val();
        if (obj.val() == '' || obj.val() == null || obj.val() == undefined) {
            obj.next().html('请输入详细地址');
            obj.next().show();
            return false;
        }
        return true;
    }

    /** 确认提交配送地址修改 */
    var rcvAddrSubmitOnClick = function () {
        var provinceCode = $.trim($('#rcvAdd-provCode-input').val());
        var cityCode = $.trim($('#rcvAdd-cityCode-input').val());
        var areaCode = $.trim($('#rcvAdd-areaCode-input').val());
        var townCode = $.trim($('#rcvAdd-townCode-input').val());
        $(document).off('click', '#rcvAdd-submit-btn', rcvAddrSubmitOnClick);
        var areaSelected = validAreaDropDowns();
        var formValid = $('#memberAddressAddForm').valid();
        var userNameCheck = chineseInput1($('.rcvAdd-username'));
        var phoneCheck = testPhone1($('.rcvAdd-phone'));
        var addressCheck = addDetailsAddr1($('.rcvAdd-addressDetail'));
        if (formValid && areaSelected && userNameCheck && phoneCheck && addressCheck) {
            var $this = $(this);
            var data = {
                id: $.trim($('#rcvAdd-id').val()),
                provinceCode: provinceCode,
                cityCode: cityCode,
                areaCode: areaCode,
                townCode: townCode,
                addressDetail: $.trim($('#rcvAdd-addressDetail').val()),
                username: $.trim($('#rcvAdd-username').val()),
                random: Math.random()
            };
            if ($('#rcvAdd-phone').attr('data-edited')) {
                data.phone = $.trim($('#rcvAdd-phone').val());
            }

            /** 判断是否已有其它数据 */
            var hasDefault = false;
            if (receiptAddressView.viewModel.defAddr) {
                hasDefault = true;
            } else {
                for (var k in receiptAddressView.dataCache) {
                    if (receiptAddressView.dataCache[k].isDefault) {
                        hasDefault = true;
                        break;
                    }
                }
            }


            if (!hasDefault)
                data.isDefault = true;

            var phone = $('#rcvAdd-phone').val();
            if (data.id && data.id != '') {
                var d = receiptAddressView.findDataInCache('id', data.id);
                if (d) {
                    data.phone = phone == d.phone ? null : phone;
                }
            }

            var txtOrgin = $this.text();
            loginValidate(addCartBtnClicked_logined);

            function addCartBtnClicked_logined() {
                $.ajax({
                    url: "/score/memberAddress/update",
                    data: data,
                    type: "GET",
                    dataType: "json",
                    beforeSend: function () {
                        $(document).off('click', '#rcvAdd-submit-btn', rcvAddrSubmitOnClick);
                        $this.text("处理中...");
                    },
                    success: function (result) {
                        result = FastJson.format(result);
                        if (result.status == 'success') {
                            if(result.data.isDefault) {
                                var id = result.data.id;
                                receiptAddressView.seleceArea(id);
                                receiptAddressView.updateMemberAddress({showAll: true, success: function() {
                                        var div = $('.optionAddress');
                                        div.addClass('f-hide');
                                        div.parents('.achieverAddress').removeAttr('height');
                                        div.parents('.achieverAddress').removeClass('achieverAddressHeight');
                                        $('.downIcon').removeClass('f-hide');
                                        $('.pullIcon').addClass('f-hide');
                                        var data = receiptAddressView.findDataInCache("id", id);
                                        receiptAddressView.rootEl.trigger('areaSelected', data);
                                        $('.editAddrCoverLayer').empty().addClass('f-hide');
                                    }});
                            } else {
                                receiptAddressView.updateMemberAddress({
                                    showAll: true, success: function () {
                                        $this.text(txtOrgin);
                                        $(document).on('click', '#rcvAdd-submit-btn', rcvAddrSubmitOnClick);
                                        $('.editAddrCoverLayer').empty().addClass('f-hide');
                                    }
                                });
                            }
                        }
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        if (typeof console.info != 'undefined') {
                            console.info("Ajax Error: [%s], error: [%s], jqXHR: [%o]", textStatus, errorThrown, jqXHR);
                        }
                        $this.text(txtOrgin);
                        $(document).on('click', '#rcvAdd-submit-btn', rcvAddrSubmitOnClick);
                    }
                });
            }


        } else {
            $(document).on('click', '#rcvAdd-submit-btn', rcvAddrSubmitOnClick);
        }
    };

    $(document).on('click', '#rcvAdd-submit-btn', rcvAddrSubmitOnClick);

    $(document).on('change', '#sameAsAchiever', function () {
        if ($(this).attr('checked')) {
            $("#invoiceReceiverInput").hide();
            $("#invoiceReceiverSameAsAchiever").show();
        } else {
            $("#invoiceReceiverInput").show();
            $("#invoiceReceiverSameAsAchiever").hide();
        }
    });

    /** 配送地址录入框获取焦点清空 */
    $(document).on('focus', '#rcvAdd-phone', function () {
        if ($(this).attr('data-edited') != true) {
            // $(this).val('').trigger('change');
            $(this).attr('data-edited', true);
            $(this).addClass('required');
        }
    });

    ///* 后付费 */
    //$(document).on('click', '.payLater', function () {
    //    $('.payLater').addClass('default');
    //    $('.transferCompany').removeClass('default');
    //    $('.payOnline').removeClass('default');
    //    //$('.payLaterTab').removeClass('f-hide');
    //    //$('.payOnlineTab').addClass('f-hide');
    //    //$('.transferAccountTab').addClass('f-hide');
    //    payTabViewModel.className = "payLaterTab";
    //    payTabViewModel.needBills = true;
    //    payTabViewModel.isPayLater = true;
    //    payTabViewModel.ruleClass = "billRule";
    //    payTabViewModel.orderTips = "";
    //    renderPayTabView(receiptAddressView);
    //});
    //
    ///* 在线支付 */
    //$(document).on('click', '.payOnline', function () {
    //    $('.payLater').removeClass('default');
    //    $('.transferCompany').removeClass('default');gg
    //    $('.payOnline').addClass('default');
    //    //$('.payOnlineTab').removeClass('f-hide');
    //    //$('.payLaterTab').addClass('f-hide');
    //    //$('.transferAccountTab').addClass('f-hide');
    //    payTabViewModel.className = "payOnlineTab";
    //    //payTabViewModel.showContent = false;
    //    payTabViewModel.isPayLater = false;
    //    payTabViewModel.ruleClass = "transferAccountRule";
    //    payTabViewModel.orderTips = "";
    //    renderPayTabView(receiptAddressView);
    //});
    //
    ///* 公司转账 */
    //$(document).on('click', '.transferCompany', function () {
    //    $('.payLater').removeClass('default');
    //    $('.transferCompany').addClass('default');
    //    $('.payOnline').removeClass('default');
    //    //$('.transferAccountTab').removeClass('f-hide');
    //    //$('.payLaterTab').addClass('f-hide');
    //    //$('.payOnlineTab').addClass('f-hide');
    //    payTabViewModel.className = "transferAccountTab";
    //    //payTabViewModel.showContent = false;
    //    payTabViewModel.isPayLater = false;
    //    payTabViewModel.ruleClass = "transferAccountRule";
    //    payTabViewModel.orderTips = "订单下单后，系统自动为您保留7天有效期，超过有效期后订单将会自动取消。为避免订单被取消，请及时通知相关人员进行付款";
    //    renderPayTabView(receiptAddressView);
    //});
    //

    /** 初始化 */
    //$('.payMethod .default').each(function() {
    //    var $this = $(this);
    //    $this.trigger('click');
    //});
});
$(document).on('click', '.alipay', function () {
    $(this).addClass('default');
    $('.wechatpay').removeClass('default')
});
$(document).on('click', '.wechatpay', function () {
    $(this).addClass('default');
    $('.alipay').removeClass('default');
});

$(document).on('click', '.close-layer-gototop', function () {
    $('.scrollTop').trigger('click');
});
$(document).on('click', '.addressDetailInfo .dropdown-toggle', function () {
    $('.addressDetailInfo input').blur();
});

//手机号码只能输入数字
function mobile(obj) {
    evt = window.event;
    obj.value = obj.value.replace(/[^\d\s]/g, '');
}

var state = true;

function getCodeEcard() {

    if (noPhone) {
        return false;
    }

    var EcardPhone = $('#Phone').html();
    if (EcardPhone == '' || EcardPhone == undefined || EcardPhone == null) {
        alert('未绑定手机号，请至itaiping平台绑定手机号');
        return false;
    }
    if (state == true) {
        state = false
        time($('.EcardcheckBtn'));
        $.ajax({
            url: "sendVerifyCode",
            data: {
                userName: EcardPhone,
                verifyCodeType: "6"
            },
            type: "post",
            dataType: "json",
            success: function (data) {
                var result = data.result
                if (result == '1') {
                    return;
                } else if (result == '3') {
                    alert("已达到当日验证码发送次数上限")
                } else {
                    alert("验证码发送失败");
                    //$(document).off('click', '#sendCode', getCodeEcard);
                }

            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                state = true;
            }
        });
    }

}

function time(o) {

    o.attr("disabled", true);
    o.html('重新发送120s');
    var step = 119;
    o.html('重新发送120s');
    var _res = setInterval(function () {
        o.html('重新发送' + step + 's');
        o.css("background", "#9E9E9E");
        step -= 1;
        if (step <= 0) {
            o.html('获取验证码');
            o.css("background", "#40a6f5");
            o.removeAttr("disabled");
            clearInterval(_res);//清除setInterval
            state = true;
            //$(document).on('click', '#sendCode', getCodeEcard);
        }
    }, 1000);
}

var noPhone = false;
var submitOrderFlag = false;

function disableSubmitButton() {
    $("#pay").addClass("clicked");
}
function enableSubmitButton() {
    $("#pay").removeClass("clicked");
}

//去結算按鈕事件
$(document).on('click', '.btn-exchange', function () {
    if($(this).hasClass("disabled")) {
        return;
    }
    if (!$("#xieyi").prop("checked")) {
        return;
    }

    var addressId = $("#addressId").val();
    if (typeof addressId != 'undefined' && $.trim(addressId) != "") {
        $("#noRecvAddressError").addClass('f-hide').hide();
    } else {
        $("#noRecvAddressError").removeClass('f-hide').show();
        return;
    }

    var $phoneMask = $("#Phone").html();
    if (noPhone || $phoneMask.length == 0) {
        noPhone = true;
        $("#Phone").parent().css("color", "#585858").css("font-size", "20px").html("请进入个人中心绑定手机号码");
        $("#sendCode").css("background", "darkgray");
        $("#sendCode").css("border-color", "darkgray");
        $("#sendCode").css("cursor", "default");
        $("#btn-sure").css("hover", "default");
    }
    if (submitOrderFlag) {
        return;
    }
    submitOrderFlag = true;
    disableSubmitButton();
    var email=$("#email").val();
    if(email.indexOf("CTYSP123.com")>0){
        submintOrderEvent();
    }else {
        $('.layer-exchange').show();
        $('.editAddrCoverLayer').removeClass('f-hide');
    }


})

var sureOrderFlag = false;

function disableSureSubmitButton() {
    $(".btn-sure").addClass("clicked");
}

function enableSureSubmitButton() {
    $(".btn-sure").removeClass("clicked");
}

$(document).on('click', '.btn-sure', function () {
    if (sureOrderFlag) {
        return false;
    }
    sureOrderFlag = true;
    disableSureSubmitButton();
    checkekVerifyCode()
})

function checkekVerifyCode() {

    if (noPhone) {
        $('.editAddrCoverLayer').addClass('f-hide');
        $('.layer-exchange').hide();
        return false;
    }

    var verifyCode = $("#verifyCode").val().replace(/^\s+|\s+$/g, '');
    if (verifyCode == "" || verifyCode == null) {
        $('.layer-exchange').show();
        alert("请输入手机验证码")
        sureOrderFlag = false;
        enableSureSubmitButton();
        return false
    }

    $.ajax({
        url: "checkekVerifyCode",
        data: {
            userName: $("#Phone").html(),
            verifyCode: verifyCode,
        },
        type: "post",
        dataType: "json",
        success: function (data) {
            var result = data
            if (result == '1') {
                // $('.layer-exchange').hide();
                $('.editAddrCoverLayer').removeClass('f-hide');
                /* $('.editAddrCoverLayer').addClass('f-hide');*/
                submintOrderEvent();
            } else if (result == '0') {
                $('.layer-exchange').show();
                alert("手机验证码错误！")
                sureOrderFlag = false;
                enableSureSubmitButton();
                return false;
            } else if (result == "2") {
                $('.layer-exchange').show();
                alert("手机验证码已失效");
                sureOrderFlag = false;
                enableSureSubmitButton();
                return false;
            }
        },
        error: function (errorData) {
            sureOrderFlag = false;
            enableSureSubmitButton();
        }
    });
    $("#verifyCode").val("");
}

function phoneMask() {

    $(".phoneMask").each(function () {
        var noMask = $(this).html();
        var mask = noMask.substr(0, 3) + "*****" + noMask.substr(7);
        $(this).html(mask);
    });

}


