/**
 * Created by Administrator on 2016/10/31.
 */
//深拷贝JS对象
function deepCopy(source) {

    var result={};
    for (var key in source) {
        result[key] = typeof source[key]==='object'? deepCopy(source[key]): source[key];
    }
    return result;
};
//by函数接受一个成员名字符串和一个可选的次要比较函数做为参数
//并返回一个可以用来包含该成员的对象数组进行排序的比较函数
//当o[age] 和 p[age] 相等时，次要比较函数被用来决出高下
var by = function(name,minor){
    return function(o,p){
        var a,b;
        if(o && p && typeof o === 'object' && typeof p ==='object'){
            a = o[name];
            b = p[name];
            if(a === b){
                return typeof minor === 'function' ? minor(o,p):0;
            }
            if(typeof a === typeof b){
                return a < b ? -1:1;
            }
            return typeof a < typeof b ? -1 : 1;
        }else{
            throw("error");
        }
    }
};


/** 获取地区Ajax接口调用 */
var getAreaData = function (parameters) {
    var beforeSend = parameters.beforeSend;
    var success = parameters.success;
    var error = parameters.error;
    var pCode = parameters.pCode;
    var level = parameters.level;
    var isDebug = parameters.debug;
    var sortListData;
    if(parameters.sortData && (typeof parameters.sortData).toLowerCase() == "function") {
        sortListData = parameters.sortData;
    } else {
        sortListData = function(data) {
            data.sort(by("levelType", by("id")));
        }
    }

    var data = {
        level: level,
        parentId: pCode
    };

    if(isDebug) {
        data.r = Math.random();
    }

    $.ajax({
        url: "/score/areaCommon/findAll",
        type: "GET",
        data: data,
        dataType: "json",
        beforeSend: function() {
            if(beforeSend && (typeof beforeSend).toLowerCase() == "function") {
                beforeSend();
            }
        },
        success: function(result) {
            result = FastJson.format(result); // 解析FastJson的节点引用
            if(isDebug == true) {
                console.info("result: %o", result);
            }
            if(result.status == "success") {

                if(Object.prototype.toString.call(result.data) === '[object Array]') {
                    sortListData(result.data);
                }

                if(success && (typeof success).toLowerCase() == "function") {
                    success(result.data);
                }
            } else {
                if(error && (typeof error).toLowerCase() == "function") {
                    error(result.error, result.message);
                }
            }
        },
        error: function(jqXHR, textStatus, errorThrown) {
            if(typeof console.info != 'undefined') {
                console.info("Ajax Error: [%s], error: [%s], jqXHR: [%o]", textStatus, errorThrown, jqXHR);
            }

            if(error && (typeof error).toLowerCase() == "function") {
                error(textStatus, jqXHR+textStatus+errorThrown+"");
            }
        }
    });

};
//下拉框
$(document).on('click','.beautySelect .dropdown-menu li',function(){
    $('.beautySelect .dropdown-toggle').val($(this).text());
});

//checkbox
$(document).on('click','.newCheckbox',function(){
    var self = $(this);
    var selfBox = self.find('input');
    var isCheck = selfBox.attr("checked");
    var isDisable = selfBox.is(':disabled');
    if(isDisable || self.attr('disabled')){
        return;
    }
    if(isCheck){
        /** 当前checkBox不选中 */
        selfBox.attr('checked',false);
        var childBox = self.parents('.orderList').find('.newCheckbox input');
        var flag = true;
        childBox.each(function(){
            if($(this).attr("checked")){ // 店铺下所有商品都取消选择后取消店铺勾选
                flag = false;
            }
        });
        if(flag){
            self.parents('.orderStore').find('.allChoose input').attr('checked',false).trigger("change");
        }
        //self.find('label').hide();
        if(self.hasClass('allChoose')){//购物车-店铺全选
            self.parents('.orderStore').find('.newCheckbox input').attr('checked',false).trigger("change");
        } else if(self.hasClass('totalAllChoose')){//购物车-全选
            /** 防止循环触发 */
            //$(document).off('change', '.cart-item-cb', cartItemCbOnChange);
            var allCheckBox =  $('.newCheckbox input');
            var allTotalAllCheckBox = $('.totalAllChoose input');
            allTotalAllCheckBox.each(function() {
                if(!$(this).is(':disabled')){
                    $(this).attr('checked',false);
                    //$(this).trigger("change");
                }
            });
            allCheckBox.each(function(){
                if(!$(this).is(':disabled') && !$(this).attr('disabled')){
                    $(this).attr('checked',false);
                }
            });
            /** 确保所有checkeBox都取消勾选后再触发change事件 */
            $('.cart-item-cb').trigger('change');
            //allCheckBox.each(function(){$(this).trigger("change");});
            /** 防止循环触发 */
            //$(document).on('change', '.cart-item-cb', cartItemCbOnChange);
            //$(allCheckBox[0]).length > 0 && $(allCheckBox[0]).trigger('change');
        } else {
            /** 任一商品取消选择后，取消“全部”的勾选 */
            /** 防止循环触发 */
            $(document).off('change', '.cart-item-cb', cartItemCbOnChange);
            $('.totalAllChoose input[type="checkbox"]').each(function() {
                //$(this).attr('checked',false);
                $(this).attr('checked',false).trigger("change");
            });
            $(document).on('change', '.cart-item-cb', cartItemCbOnChange);
        }
    } else {
        /** 当前checkBox选中 */
        selfBox.attr('checked',true);
        if(self.hasClass('allChoose')){//购物车-店铺全选
            self.parents('.orderStore').find('.newCheckbox input').attr('checked',true).trigger("change");
        } else if (self.hasClass('totalAllChoose')){//购物车-全选
            var allCheckBox =  $('.newCheckbox input');
            var allTotalAllCheckBox = $('.totalAllChoose input');
            /** 防止循环触发 */
            allTotalAllCheckBox.each(function() {
                if(!$(this).is(':disabled')){
                    $(this).attr('checked',true);
                    //$(this).trigger("change");
                }
            });
            allCheckBox.each(function(){
                if(!$(this).is(':disabled') && !$(this).attr('disabled')){
                    $(this).attr('checked',true);
                }
            });
            /** 确保所有checkeBox都取消勾选后再触发change事件 */
            //allCheckBox.each(function(){$(this).trigger("change");});
            $('.cart-item-cb').trigger('change');
            /** 防止循环触发 */
            //$(allCheckBox[0]).length > 0 && $(allCheckBox[0]).trigger('change');
        } else {
            /** 防止循环触发 */
            $(document).off('change', '.cart-item-cb', cartItemCbOnChange);
            var childBox = self.parents('.orderList').find('.newCheckbox input');
            // 任意商品选中后，勾选店铺
            self.parents('.orderStore').find('.allChoose input').attr('checked',true).trigger("change");
            // 全部商品选中后，勾选“全部”
            var f = true;
            $('.cart-item-cb').each(function() {
                if(!$(this).attr('disabled') && !$(this).attr('checked') && !$(this).is(":checked")) {
                    f = false;
                }
            });

            if(f) {
                $('.totalAllChoose input[type="checkbox"]').each(function() {
                    $(this).attr('checked',true).trigger("change");
                });
            }
            /** 防止循环触发 */
            $(document).on('change', '.cart-item-cb', cartItemCbOnChange);
        }
    }
    selfBox.trigger('change');
});
//关闭弹窗
$(document).on('click','.coverLayer .closeTips',function(e){
    $(this).parents('.coverLayer').hide();
});

//ie8兼容trim()
String.prototype.trim = function ()
{
    return this.replace(/(^\s*)|(\s*$)/g, "");
}
String.prototype.ltrim = function ()
{
    return this.replace(/(^\s*)/g, "");
}
String.prototype.rtrim = function ()
{
    return this.replace(/(\s*$)/g, "");
}
/** 地区选择（下拉菜单方式） */
$.fn.areaSelectDropDown = function(level) {
    level = level && typeof level != 'undefined' ? level : 1;
    var $this = $(this);
    var defVal = $this.attr('data-value');
    var dataParent = $this.attr('data-parent-select');
    var $relParent = dataParent && typeof dataParent != 'undefined' ? $("#"+$this.attr('data-parent-select')) : undefined;

    var getAreaSelectRelView = function(el) {
        var relViewEl, relViewElId;
        relViewElId = el.attr("data-rel-view");
        if(relViewElId && $.trim(relViewElId) != '') {
            relViewEl = $("#" + relViewElId);
        } else {
            //relViewEl = el.parent().find('[data-toggle="dropdown"]');
            relViewEl = el.parent().find('.area-view-input');
    }
        return relViewEl && relViewEl.length > 0 ? relViewEl : null;
    };

    var getAreaSelectRelInput = function(el) {
        var relInput, relInputId;
        relInputId = el.attr("data-rel-input");
        if(relInputId && $.trim(relInputId) != '') {
            relInput = $("#" + relInputId);
        }
        return relInput;
    };

    /** 下拉菜单关联显示值 */
    var setAreaSelectRelView = function(el, txt) {
        var relViewEl = getAreaSelectRelView(el);
        relViewEl && relViewEl.val(txt);
    };
    /** 下拉菜单关联表单值 */
    var setAreaSelectRelValue = function(el, val) {
        var relInput = getAreaSelectRelInput(el);
        relInput && relInput.val(val).trigger("change");
    };
    /** 更新地区下拉框内容 */
    var updateAreaSelectMenu = function(el, data) {
        var defVal = el.attr('data-value');
        if(data) {
            el.empty();
            var name = "";
            for(var k in data) {
                name = data[k].name.length > 3 ? data[k].shortName : data[k].name;
                $(document.createElement("li")).attr("data-value", data[k].code).text(name).appendTo(el);
                if(data[k].code == defVal) {
                    setAreaSelectRelView(el, name);
                    setAreaSelectRelValue(el, data[k].code);
                }
            }
        }
    };


    $this.on('click', 'li', function() {
        setAreaSelectRelView($this, $(this).text());
        setAreaSelectRelValue($this, $(this).attr('data-value'));
        $this.attr('data-value', $(this).attr('data-value'));
        /** 点击更新下级 */
        var $nextLvEl = $this;
        /** 重置后续级别 */
        for(var i = level + 1; i <= 4; i++) {
            $nextLvEl = $('[data-parent-select="'+$nextLvEl.attr('id')+'"]');
            $nextLvEl.attr('data-value', "");
            $nextLvEl && $nextLvEl.length >0 && $nextLvEl.areaSelectDropDown(i);
        }
    });

    if(level == 1) {
        setAreaSelectRelView($this, "请选择省");
    } else if(level == 2) {
        setAreaSelectRelView($this, "请选择市");
    } else if(level == 3) {
        setAreaSelectRelView($this, "请选择区");
    } else if(level == 4) {
        setAreaSelectRelView($this, "请选择街道");
    }

    $this.empty();
    var pCode = $relParent && $relParent.length > 0 ? $relParent.attr('data-value') : null;
    var showTxtOrgin = getAreaSelectRelView($this).val();
    setAreaSelectRelValue($this, '');
    if(level == 1 || (pCode && $.trim(pCode) != '')) {
        getAreaData({
            level: level, debug: false, pCode: pCode,
            beforeSend: function(data) {
                $this.empty();
                //$this.hide();
                var relView = getAreaSelectRelView($this);
                relView.parents('.detailed-address').addClass('f-hide');
                setAreaSelectRelView($this, "请稍候...");
                setAreaSelectRelValue($this, '');
            },
            success: function(data) {
                setAreaSelectRelView($this, showTxtOrgin);
                var relView = getAreaSelectRelView($this);
                if(data && data.length > 0) {
                    updateAreaSelectMenu($this, data);
                    relView.parents('.dropdown').show() && relView.nextAll('.selectIcon').show() && relView.parents('.detailed-address').removeClass('f-hide');
                    /**Akers 2017/1/5修改： 直辖市隐藏2级 START */
                    if(data.length == 1 && data[0].remarks == 'direct') {
                        setAreaSelectRelView($this, data[0].name);
                        setAreaSelectRelValue($this, data[0].code);

                        //relViewEl.hide();
                        //relViewEl.nextAll('.selectIcon').hide();

                        var $li = $this.find('li:first');
                        $this.attr('data-value', $li.attr('data-value'));
                        $this.attr('data-direct', true);
                        relView.parents('.dropdown').hide();
                        $('.area-select-tip').hide();
                        relView.parents('.detailed-address').addClass('f-hide');
                    } else {
                        //relViewEl.show();
                        //relViewEl.nextAll('.selectIcon').show();
                        relView.parents('.dropdown').show();
                        relView.parents('.detailed-address').removeClass('f-hide');
                        $this.attr('data-direct', false);
                    }

                    /** 更新下级 */
                    var $nextLvEl = $this;
                    /** 重置后续级别 */
                    if(level < 4) {
                        $nextLvEl = $('[data-parent-select="'+$nextLvEl.attr('id')+'"]');
                        $nextLvEl && $nextLvEl.length >0 && $nextLvEl.areaSelectDropDown(level + 1);
                    }
                    /**Akers 2017/1/5修改： 直辖市隐藏2级 END */
                } else {
                    relView.parents('.dropdown').hide() && relView.nextAll('.selectIcon').hide() &&
                    relView.parents('.detailed-address').addClass('f-hide') && $('.area-select-tip').hide();;
                    var $nextLvEl = $this;
                    /** 重置后续级别 */
                    for(var i = level + 1; i <= 4; i++) {
                        $nextLvEl = $('[data-parent-select="'+$nextLvEl.attr('id')+'"]');
                        $nextLvEl.attr('data-value', "");
                        $nextLvEl && $nextLvEl.length >0 && $nextLvEl.areaSelectDropDown(i);
                    }
                }
            }
        });
    } else {
        getAreaSelectRelView($this).parents('.dropdown').hide();
        $('.area-select-tip').hide();
        getAreaSelectRelView($this).parents('.detailed-address').addClass('f-hide')
        var $nextLvEl = $this;
        /** 重置后续级别 */
        for(var i = level + 1; i <= 4; i++) {
            $nextLvEl = $('[data-parent-select="'+$nextLvEl.attr('id')+'"]');
            $nextLvEl.attr('data-value', "");
            $nextLvEl && $nextLvEl.length >0 && $nextLvEl.areaSelectDropDown(i);
        }
    }
};


$(document).ready(function() {
    /** 初始化地区选择控件 */
    $('.area-select-plugin').each(function() {
        AreaSelectPlugin.createNew().init({el: $(this), maxLevel: 4,
            dataReqUrl: '/score/areaCommon/findAll',
            ipAddressUrl: '/score/areaCommon/ipAddress'});
    });
    /** 初始化地区选择下拉框 */
    $('.dropdown-menu.area-select').each(function() {
        /** 省份下拉框 */
        var $this = $(this);
        $this.empty();
        var level = 1;
        if($this.hasClass('province')) {
            level = 1
        } else if($this.hasClass('city')) {
            level = 2
        } else if($this.hasClass('area')) {
            level = 3
        } else if($this.hasClass('town')) {
            level = 4
        }
        $this.areaSelectDropDown(level);
    });
    $(".nav-tabs>li").on('mouseover','a',function(){
        if($(this).html()!=""){
            $(this).addClass('activeTab');
        }
    });
    $(".nav-tabs>li").on('mouseout','a',function(){
        $(this).removeClass('activeTab');
    });
});

var showLoadingModal = function() {
    var m = $("#common-message-modal");
    m.find('.messageTitle').hide();
    m.find('.messageTitle h5').text("");
    m.find('.messageInfo .msg-content').text("数据加载中，请稍候...");
    m.removeClass('f-hide').show();
};

var hideLoadingModal = function() {
    var m = $("#common-message-modal");
    m.find('.messageTitle').show();
    m.addClass('f-hide').hide();
};

// 购物车前台公用表单校验插件初始化
var initDefaultValidator = function(form) {
    form = $(form);
    return form.validate({
        errorElement: "p", // 错误提示的DOM元素类型，默认为label<p>错误信息</p>
        errorPlacement:function(err, e) {
            /** 个性化处理message *//*larry modify*/
            var errEl = e.nextAll(".checkTip");
            if(errEl && errEl.length > 0) {
                errEl.text(err.text().replace(/{tipTitle}/g, (e.attr('tip-title') ? e.attr('tip-title') : '该字段')));
                errEl.show();
            } else {
                err.text(err.text().replace(/{tipTitle}/g, (e.attr('tip-title') ? e.attr('tip-title') : '该字段')));
                err.addClass("checkTip").insertAfter(e);
            }

        },
        highlight: function(element, errorClass) {
            var e = $(element);
            var error = e.nextAll(".checkTip");
            if(error && error.length > 0) {
                error.addClass(errorClass).show();
            }
        },
        unhighlight: function(element, errorClass) {
            var error = $(element).nextAll(".checkTip");
            if(error && error.length > 0) {
                error.removeClass(errorClass).hide();
            }
        }
    });
};
//var initDefaultValidator = function(form) {
//    form = $(form);
//    return form.validate({
//        errorElement: "p", // 错误提示的DOM元素类型，默认为label
//        errorPlacement:function(error, e) {
//            /** 个性化处理message *//*larry modify*/
//            error.text(error.text().replace(/{tipTitle}/g, (e.attr('tip-title') ? e.attr('tip-title') : '该字段')));
//            error.addClass("checkTip").insertAfter(e);
//        },
//        success: function(l, e) {
//
//        }
//    });
//};
