/**
 * Created by zhangqingan on 2016/12/21.
 */
var CM={
    init:function(){
        CM.bindCheckUserName();
        CM.bindCheckPhoneNum();
        CM.bindCheckEmail();
        CM.bindCheckOrderNo();
    },
    bindCheckUserName:function(){
        $('#username,#orderName').on('blur',function(){
          CM.checkUserName($(this));
        });
    },
    bindCheckPhoneNum:function(){
        $('#phone').on('blur',function(){
            CM.checkPhoneNum($(this));
        });
    },
    bindCheckEmail:function(){
        $('#email').on('blur',function(){
            CM.checkEmail($(this));
        });
    },
    bindCheckOrderNo:function(){
        $('#orderNo').on('blur',function(){
            CM.checkOrderNo($(this));
        });
    },
    // 校验姓名
    checkUserName:function(obj){
        var inputText=obj.val();
        //^[a-zA-Z\u4e00-\u9fa5]+$
        var reg=new RegExp("^[\u4E00-\u9FA5A-Za-z0-9]+$");
        if(inputText.length==0){
            CM.clearErrorMsg(obj[0]);
            return true;
        }else if(inputText.length>50){
            CM.showErrorMsg(obj[0],'最多可录入50个字符');
            return false;
        }else if(!reg.test(inputText)){
            CM.showErrorMsg(obj[0],'只可录入汉字、数字和英文字符');
            return false;
        }else{
            CM.clearErrorMsg(obj[0]);
            return true;
        }
    },
    // 校验手机号码
    checkPhoneNum:function(obj){
        var inputText=obj.val();
        var reg=new RegExp("^1[3-8][0-9]{9}$");
        if(inputText.length==0){
            CM.clearErrorMsg(obj[0]);
            return true;
        } else if(!reg.test(inputText)){
            CM.showErrorMsg(obj[0], '您录入的手机号码格式有误');
            return false;
        }else{
            CM.clearErrorMsg(obj[0]);
            return true;
        }
    },
    //else if(!(/^1(3|4|5|7|8)\d{9}$/.test(inputText))){
    // CM.showErrorMsg(obj[0],'您录入的手机号码格式有误');
    //    return false;
    //}
    // 校验邮箱
    checkEmail:function(obj){
        var inputText=obj.val();
        var reg=new RegExp("^[A-Za-z0-9@\.]{1,50}$");
        if(inputText.length==0){
            CM.clearErrorMsg(obj[0]);
            return true;
        }else if(!reg.test(inputText)){
            CM.showErrorMsg(obj[0], '邮箱格式有误，请检查');
            return false;
        }else{
            CM.clearErrorMsg(obj[0]);
            return true;
        }
    },

    // 校验手机号码
    checkOrderNo:function(obj){
        var inputText=obj.val();
        var reg=new RegExp("^[0-9]{0,20}$");
        if(inputText.length==0){
            CM.clearErrorMsg(obj[0]);
            return true;
        } /*else if(!reg.test(inputText)){
            CM.showErrorMsg(obj[0], '您录入的订单号有误');
            return false;
        }*/else{
            CM.clearErrorMsg(obj[0]);
            return true;
        }
    },

//    else if(!(/\w[-\w.+]*@([A-Za-z0-9][-A-Za-z0-9]+\.)+[A-Za-z]{2,14}/).test(inputText)){
//    CM.showErrorMsg(obj[0],'邮箱格式有误，请检查');
//    return false;
//}
    // 错误提示信息
    showErrorMsg:function(obj,errorText){
        if(!$(obj).parents('.formInput').find('p.errorManMsg')[0]){
            var errorP = '<p class="errorManMsg">'+errorText+'</p>';
            $(obj).parents('.formInput').append(errorP);
        }
    },
//	错误提示删除
    clearErrorMsg:function(obj){
        var errorP = $(obj).parents('.formInput').find('.errorManMsg');
        errorP.remove();
    }
};
$(function(){
    CM.init();
})