//使用插件兼容IE8的placeholder属性
$('input, textarea').placeholder();
//登录校验
function checkUserInput(obj){
    var inputText = $(obj).val();
    if(inputText==""||inputText==null||inputText==undefined){
        clearError(obj);
        showError(obj,'请输入手机号或邮箱');
        return false;
    }else{
        clearError(obj);
        return true;
    }
}
function checkPasswordInput(obj){
    var inputText = $(obj).val();
    if(inputText==""||inputText==null||inputText==undefined){
        clearError(obj);
        showError(obj,'请输入密码');
        return false;
    }else{
        clearError(obj);
        return true;
    }
}
function checkCodeInput(obj){
    var inputText = $(obj).val();
    if(inputText==""||inputText==null||inputText==undefined){
        clearError(obj);
        showError(obj,'请输入验证码');
        return false;
    }else{
        clearError(obj);
        return true;
    }
}
//错误提示
function showError(obj,errorText,parent){
    var errorP = '<p class="loginError">'+errorText+'</p>';
	if(parent!=undefined){
		$(obj).parents(parent).append(errorP);
	}else{
		$(obj).parents('.loginInput').append(errorP);
	}
}
function clearError(obj,parent){
	if(parent!=undefined){
		var errorP = $(obj).parents(parent).children('.loginError');
	}else{
		var errorP = $(obj).parents('.loginInput').children('.loginError');
	}
    errorP.remove();
}
//登录点击
function loginFormSubmit(){
    var loginFlag = [false,false,false];
    loginFlag[0] = checkUserInput('.userInput');
    loginFlag[1] = checkPasswordInput('.passwordInput');
	if ($("#validateFlag").val() != 1){
		loginFlag[2] = true;
	}else{
		loginFlag[2] = checkCodeInput('.codeInput');
	}
    var flagTrue = loginFlag[0] && loginFlag[1] && loginFlag[2];
    if(flagTrue){
        //alert('登录成功');
        $('.loginForm').submit();
    }else{
        return false;
    }
}
//密码修改
function checkOldInput(obj){
	var inputText = $(obj).val();
	if(inputText==""||inputText==null||inputText==undefined){
		clearError(obj,'.inputDiv');
		showError(obj,'请输入原始密码','.inputDiv');
		return false;
	}else{
		clearError(obj,'.inputDiv');
		return true;
	}
}
function checkNewInput(obj){
	var inputText = $(obj).val();
	if(inputText==""||inputText==null||inputText==undefined){
		clearError(obj,'.inputDiv');
		showError(obj,'请输入新密码','.inputDiv');
		return false;
	}else{
		clearError(obj,'.inputDiv');
		return true;
	}
}
function checkNewAgainInput(obj){
	var inputText = $(obj).val();
    var re =  /[a-zA-Z]+(?=[0-9]+)|[0-9]+(?=[a-zA-Z]+)/g;
	if(inputText==""||inputText==null||inputText==undefined){
		clearError(obj,'.inputDiv');
		showError(obj,'请输入确认新密码','.inputDiv');
		return false;
	} else if(!re.test(inputText)||inputText.length<6||inputText.length>13){
        clearError(obj,'.inputDiv');
        showError(obj,'请输入6-13位包含英文和数字的密码','.inputDiv');
        return false;
    } else{
		clearError(obj,'.inputDiv');
		if($('.newPassword').val() != inputText){
			showError(obj,'新密码和确认新密码不一致，请检查！','.inputDiv');
			return false;
		}
		else if($('.oldPassword').val()==$('.newPassword').val()){
			showError(obj,'新密码不能与原密码一致，请检查！','.inputDiv');
			return false;
		}
		else{
			return true;
		}
	}
}
//修改密码点击提交
function changeFormSubmit(){
	var loginFlag = [false,false,false];
	loginFlag[0] = checkOldInput('.oldPassword');
	loginFlag[1] = checkNewInput('.newPassword');
	loginFlag[2] = checkNewAgainInput('.againPassword');
	var flagTrue = loginFlag[0] && loginFlag[1] && loginFlag[2];
	if(flagTrue){
		//alert('修改成功');

		var postData = {
			oldPwd:$(".oldPassword").val(),
			newPwd:$(".newPassword").val(),
			newRePwd:$(".againPassword").val()
		};

		$.post("update/passwd",postData,function (data) {
			if (data.code == '0'){
				//$('.changePasswordForm').submit();
				$('.importPopup').show();
                $('.changeFail').hide();
				$('.changeSuccess').show();

				$(".oldPassword").val('');
				$(".newPassword").val('');
				$(".againPassword").val('');
			}else{
				$('.importPopup').show();
				$('.changeFail').show();
				$("#changeErrorMsg").html("密码修改失败，"+data.msg);
			}
		});


	}else{
		return false;
	}
}


//忘记密码
var L={
	timer:null,
	init:function(){
		var canSendIdentifyCode=true;
		//	弹出第一个弹窗
		$('.forgetPassword').on('click',function(){
			$('.login-mask').show();
			$('form.form-identify').show();
			$('.forgetPwd-wrap').fadeIn();
			$('.progress-step.first-step').addClass('hover').next().show().next().addClass('hover');
		})
		//验证用户名
		$('.userName').on('blur',function(){
			L.checkPhoneOrEmail(this);
		})
		//验证图片验证码
		$('.pic-code').on('blur',function(){
			L.checkPicCode(this);
		})
        //验证验证码
		$('.identify-code').on('blur',function(){
			L.checkIdentifyCode(this);
		})
		//手机验证码计时
		$('.code-send').on('click',function(){
			$(this).text('已发送（60）').addClass('disabled').attr('disabled',true);
			L.reciprocal(this);
		})
//		验证新密码
		$('.newPwd').on('blur',function(){
			L.checkNewPwd(this);
		})
//		校验确认密码
		$('.confirmPwd').on('blur',function(){
			L.checkConfirmPwd(this);
		})
		//右上角关闭按钮
		$('.icon-close').on('click',function(){
			L.timer&&clearInterval(L.timer),L.timer=null;
			$(this).parent().find('.code-send').text('发送验证码').removeClass('disabled').attr('disabled',false);
			$('.progress-step.second-step').removeClass('hover').next().hide().next().removeClass('hover');
			$('.progress-step.third-step').removeClass('hover').next().hide().next().removeClass('hover');
			$(this).parents('.login-mask').hide();
			$('.form-findPwd').hide();
			$(this).parent().find('input').val('');
		})
		//返回登录按钮
		$('.retToLogin').on('click',function(){
			if($(this).parent().hasClass('form-identify')){
				L.timer&&clearInterval(L.timer),L.timer=null;
				$(this).parent().find('.code-send').text('发送验证码').removeClass('disabled').attr('disabled',false);
				$(this).parents('.login-mask').hide();
				$('.form-findPwd').hide();
			}else if($(this).parent().hasClass('form-resetPwd')){
				$('.progress-step.second-step').removeClass('hover').next().hide().next().removeClass('hover');
				$(this).parents('.login-mask').hide();
				$('.form-findPwd').hide();
			}
			$('.errorMsg').remove();
			$(this).parent().find('input').val('');
		});
		//下一步按钮
		$('.button-next').on('click',function(){
			if($(this).parent().hasClass('form-identify')){
//				下一步成功
				if(L.checkUserBasicMsg()){
					$('form.form-identify').hide();
					$('.progress-step.second-step').addClass('hover').next().show().next().addClass('hover');
					$('form.form-resetPwd').show();
					//取消当前计时器
					L.timer&&clearInterval(L.timer),L.timer=null;
					$(this).parent().find('.code-send').text('发送验证码').removeClass('disabled').attr('disabled',false);
					$(this).parent().find('input').val('');
				}else{
					return;
				}
			}else if($(this).parent().hasClass('form-resetPwd')){
				if(L.checkResetPwd()){
					$('form.form-resetPwd').hide();
					$('.progress-step.third-step').addClass('hover').next().show().next().addClass('hover');
					$('form.form-accomplish').show();
					$(this).parent().find('input').val('');
				}else{
					return;
				}
			}else{
//				登录按钮
				$('.progress-step.second-step').removeClass('hover').next().hide().next().removeClass('hover');
				$('.progress-step.third-step').removeClass('hover').next().hide().next().removeClass('hover');
				$(this).parents('.login-mask').hide();
				$('form.form-accomplish').hide();
			}
		})
	},
	//验证码倒数
	reciprocal:function(obj){
		var time=59;
		L.timer=setInterval(function(){
			if(time>=0){
				$(obj).text('已发送（'+time+'）');
				time--;
			}else{
				clearInterval(L.timer);
				L.timer=null;
				$(obj).text('发送验证码').removeClass('disabled').attr('disabled',false);
				return;
			}
		},1000)
	},
//	检查手机号码
	checkPhoneOrEmail:function(obj){
	    var inputText = $(obj).val();
		if(!inputText){
		    L.clearErrorMsg(obj);
		    L.showErrorMsg(obj,'请输入手机号或邮箱');
		    return false;
		}else{
		    L.clearErrorMsg(obj);
		    return true;
	    }
	},
//	检查图片验证码
	checkPicCode:function(obj){
		var inputText = $(obj).val();
		if(!inputText){
		    L.clearErrorMsg(obj);
		    L.showErrorMsg(obj,'请输入图片验证码');
		    return false;
		}else{
		    L.clearErrorMsg(obj);
		    return true;
	    } 
	},
	//检查验证码
	checkIdentifyCode:function(obj){
		var inputText = $(obj).val();
		if(!inputText){
		    L.clearErrorMsg(obj);
		    L.showErrorMsg(obj,'请输入图片验证码');
		    return false;
		}else{
		    L.clearErrorMsg(obj);
		    return true;
	    } 
	},
	checkNewPwd:function(obj){
		var inputText = $(obj).val();
		var inputLen=$(obj).val().length;
		var re =  /[a-zA-Z]+(?=[0-9]+)|[0-9]+(?=[a-zA-Z]+)/g;
		if(!re.test(inputText)||(!inputText)||inputLen<6||inputLen>13){
		    L.clearErrorMsg(obj);
		    L.showErrorMsg(obj,'密码不合要求，请输入6-13位包含英文和数字的密码');
		    return false;
		}else{
		    L.clearErrorMsg(obj);
		    return true;
	    } 
	},
	checkConfirmPwd:function(obj){
		var inputText = $(obj).val();
		if(!inputText){
		    L.clearErrorMsg(obj);
		    L.showErrorMsg(obj,'密码不能为空，请重新输入');
		    return false;
		}else if(inputText!=$('.newPwd').val()){
			L.clearErrorMsg(obj);
		    L.showErrorMsg(obj,'密码不正确，请重新输入');
		    return false;
		}else{
		    L.clearErrorMsg(obj);
		    return true;
	    } 
	},
//	错误提示信息
	showErrorMsg:function(obj,errorText){
		var errorP = '<p class="errorMsg">'+errorText+'</p>';
	    $(obj).parents('.loginInput').append(errorP);
	},
//	错误提示删除
	clearErrorMsg:function(obj){
	    var errorP = $(obj).parents('.loginInput').children('.errorMsg');
	    errorP.remove();
	},
//	找回密码-身份验证(下一步)
	checkUserBasicMsg:function(){
	    var checkedFlag = [false,false,false];
	    checkedFlag[0] = L.checkPhoneOrEmail('.userName');
	    checkedFlag[1] = L.checkPicCode('.pic-code');
	    checkedFlag[2] = L.checkIdentifyCode('.identify-code');
	    var flagTrue = checkedFlag[0] && checkedFlag[1] && checkedFlag[2];
	    if(flagTrue){
	        return true;
	    }else{
	        return false;
	    }
	},
//	找回密码-重设密码(下一步)
	checkResetPwd:function(){
		var checkedFlag = [false,false];
	    checkedFlag[0] = L.checkNewPwd('.newPwd');
	    checkedFlag[1] = L.checkConfirmPwd('.confirmPwd');
	    var flagTrue = checkedFlag[0] && checkedFlag[1];
	    if(flagTrue){
	        return true;
	    }else{
	        return false;
	    }
	}
}

$(function(){
	L.init();

});

