var MO = {
    init: function () {
        MO.bindMyOrder();
        MO.bindDropDownByDuring();
        MO.bindDropDownByStatus();
    },
    bindMyOrder: function () {
        $('.order-model').on('click', '.order-model-list', function () {
            $(this).addClass('hover').siblings().removeClass('hover');
            if ($(this).attr("id") == "status_0") {
                $('span.cur-status').text("全部");
            } else if ($(this).attr("id") == "status_3") {
                $('span.cur-status').text("待收货");
            }
        })
    },
    bindDropDownByDuring: function () {
        $('.order-during').mouseenter(function (event) {
            var e = event || window.event;
            $('.drop-over-during>li.avaliable').each(function (index, ele) {
                ($(ele).find('.avaliable-range').text() == $('.range:eq(0)').text()) && ($(ele).addClass('hover').siblings().removeClass('hover'));
            });
            $('.drop-over-during').show();
            $('.drop-over-during').mouseleave(function (event) {
                var e = event || window.event;
                $(this).hide();
            })
        });
        $('.drop-over-during').on('click', '.order-during-list.avaliable', function () {
            $('span.range').text($(this).find('.avaliable-range').text());
            $('.drop-over-during').hide();
        })
    },
    bindDropDownByStatus: function () {
        $('.order-status').mouseenter(function (event) {
            var e = event || window.event;
            $('.drop-over-status>li.status').each(function (index, ele) {
                ($(ele).find('.status-text').text() == $('.cur-status:eq(0)').text()) && ($(ele).addClass('hover').siblings().removeClass('hover'));
            })
            $('.drop-over-status').show();
            $('.drop-over-status').mouseleave(function (event) {
                var e = event || window.event;
                $(this).hide();
            })
        });
        $('.drop-over-status').on('click', '.order-status-list.status', function () {
            $('span.cur-status').text($(this).find('.status-text').text());
            if ($(this).attr("id") == "status0_0") {
                $("#statusSelect li:eq(0)").addClass('hover').siblings().removeClass('hover');
            } else if ($(this).attr("id") == "status0_3") {
                $("#statusSelect li:eq(1)").addClass('hover').siblings().removeClass('hover');
            } else if ($(this).attr("id") == "status0_4") {
                $("#statusSelect li:eq(2)").addClass('hover').siblings().removeClass('hover');
            } else {
                $("#statusSelect li").removeClass('hover');
            }
            $('.drop-over-status').hide();
        })
    }
};


var currentPage = 1;
var pageSize = 10;
var startTime = "";
var endTime = "";
var status = "";
var orderNo = "";
var isInit=true;
$(function () {
    MO.init();
    //========================时间处理

    var nowDate = new Date();
    var year = nowDate.getFullYear();
    var li = '';
    if(isInit) {
        for (var i = 1; i < 4; i++) {
            var l_year = year - i;
            if (i == 3) {
                li += '<li class="order-during-list avaliable" id="time_3y">' +
                    '<i class="iconfont icon-range">&#xe623;</i>' +
                    '<span class="avaliable-range">' + (l_year + 1) + '年以前订单</span>' +
                    '</li>';
            } else {
                li += '<li class="order-during-list avaliable" id="time_' + i + 'y">' +
                    '<i class="iconfont icon-range">&#xe623;</i>' +
                    '<span class="avaliable-range">' + l_year + '年订单</span>' +
                    '</li>';
            }
        }
        isInit=false;
    }

    $(li).appendTo("#timeSelect");
    //========================

    var postData = {
        startTime: startTime,
        endTime: endTime,
        status: status,
        orderNo: orderNo,
        page: currentPage,
        pageSize: pageSize
    };
    queryMyOrder(postData);

    //按钮查询
    $("#order-submit").click(function () {

        orderNo = $("#orderNum").val();
        var postData = {};
        if (orderNo == undefined || orderNo == '') {
            //postData = {
            //    startTime: startTime,
            //    endTime: endTime,
            //    status: status,
            //    orderNo: orderNo,
            //    page: currentPage,
            //    pageSize: pageSize
            //};
            $('.NullTips').show();
            return;
        } else {
            postData = {
                startTime: startTime,
                endTime: endTime,
                status: status,
                orderNo: orderNo,
                pageIndex: currentPage,//必须从0开始查询
                pageSize: pageSize
            };
        }
        queryMyOrder(postData);
    });

    $('#orderNum').change(function () {
        orderNo = $("#orderNum").val();

    });
    $('#orderNum').focus(function () {
        $('.NullTips').hide();
    });


    //状态选择
    $("#statusSelect li").click(function () {
        //console.log(this.id);
        if (this.id == "status_0") {
            status = "";
        } else if (this.id == "status_3") {
            status = "3";
        } else if (this.id == "status_4") {
            status = "4";
        } else {
            status = "";
        }
        postData = {
            startTime: startTime,
            endTime: endTime,
            status: status,
            orderNo: orderNo,
            pageIndex: 0,//必须从0开始查询
            pageSize: pageSize
        };
        queryMyOrder(postData);
    });
    //状态选择
    $("#statusSelect0 li").click(function () {
        //console.log(this.id);
        if (this.id == "status0_0") {
            status = "";
        } else if (this.id == "status0_1") {
            status = "1";
        } else if (this.id == "status0_2") {
            status = "2";
        } else if (this.id == "status0_3") {
            status = "3";
        } else if (this.id == "status0_4") {
            status = "4";
        } else if (this.id == "status0_5") {
            status = "5";
        } else if (this.id == "status0_6") {
            status = "6";
        } else if (this.id == "status0_7") {
            status = "7";
        } else {
            status = "";
        }
        postData = {
            startTime: startTime,
            endTime: endTime,
            status: status,
            orderNo: orderNo,
            pageIndex: currentPage,//必须从0开始查询
            pageSize: pageSize
        };
        queryMyOrder(postData);
    });

    //时间选择
    $("#timeSelect li").click(function () {
        //console.log(this.id);
        var nowDate = new Date();
        var year = nowDate.getFullYear();
        var month = nowDate.getMonth() + 1;
        var day = nowDate.getDate();

        if (this.id == "time_3m") {
            nowDate.setMonth(nowDate.getMonth() - 3);
            startTime = nowDate.getFullYear() + "-" + (nowDate.getMonth() + 1) + "-" + "01";
            endTime = year + "-" + month + "-" + day;
        } else if (this.id == "time_ny") {
            startTime = year + "-01-" + "01";
            endTime = year + "-" + month + "-" + day;
        } else if (this.id == "time_1y") {
            startTime = (year - 1) + "-01-" + "01";
            endTime = (year - 1) + "-12-31";
        } else if (this.id == "time_2y") {
            startTime = (year - 2) + "-01-" + "01";
            endTime = (year - 2) + "-12-31";
        } else if (this.id == "time_3y") {
            startTime = (year - 3) + "-01-" + "01";
            endTime = (year - 10) + "-12-31";//前10年
        } else {
            startTime = year + "-" + (month - 2) + "-" + "01";
            endTime = year + "-" + month + "-" + day;
        }

        startTime += " 00:00:00";
        endTime += " 23:59:59";

        postData = {
            startTime: startTime,
            endTime: endTime,
            status: status,
            orderNo: orderNo,
            pageIndex: currentPage,//必须从0开始查询
            pageSize: pageSize
        };
        //console.log(postData);
        queryMyOrder(postData);
    });

});

/**
 * 分页查询
 * @param postData
 */
function queryMyOrder(postData) {

    var page = 0;
    if (postData.pageIndex) {
        page = postData.pageIndex - 1;
    } else {
        page = 0;
    }
    postData.pageIndex = page;
    $.post("../order/queryOrder", postData, function (data) {
        //console.log(data);

        var totalPage = data.totalPage;
        var pageNum = data.pageNum;

        var listData = data.orderData;
        var orderHtml = convertData(listData);
        $("#orderListTable").html(orderHtml);

        //console.log(totalPage);

        //显示分页
        laypage({
            cont: 'orderListPage', //容器。值支持id名、原生dom对象，jquery对象。【如该容器为】：<div id="page1"></div>
            pages: totalPage, //通过后台拿到的总页数
            curr: (postData.pageIndex + 1) || 1, //当前页
            skin: '#AF0000',//皮肤
            jump: function (obj, first) { //触发分页后的回调
                if (!first) { //点击跳页触发函数自身，并传递当前页：obj.curr
                    currentPage = obj.curr;
                    if (window["console"]){
                        console.log("当前页:" + currentPage);
                    }

                    var postData = {
                        startTime: startTime,
                        endTime: endTime,
                        status: status,
                        orderNo: orderNo,
                        pageIndex: currentPage,
                        pageSize: pageSize
                    };
                    queryMyOrder(postData);
                }
            }
        });


    });

}

/**
 * 拼接列表页面
 * @param orderData
 * @returns {string}
 */
function convertData(orderData) {
    var returnStr = '';

    if (orderData == undefined || orderData.length == 0) {
        return "<div style='width: 100%;text-align: center;height: 150px;line-height: 150px;'>很抱歉，系统找不到您的记录，换个条件试试</div>";
    }
    //console.log(orderData.length);

    jQuery.each(orderData, function (n, value) {
        //console.log(value);
        var orderMain = value.orderMain;
        var buyer = value.buyer;
        var payMoney = value.payMoney;
        var score=value.score;
        var picList = value.picList;

        var orderItem0 = "";
        var imgItem0 = "";
        if (picList && picList[0]) {
            var orderItem0 = picList[0].ITEM;
            var imgItem0 = picList[0].IMG;
        }
        var date0 = ['', ''];
        if (orderMain.createTime != undefined) {
            date0 = orderMain.createTime.split(" ");
        }
        if (score == undefined) {
            score = 0;
        }
        if (payMoney == undefined) {
            payMoney = 0;
        }

        var productName = orderItem0.productName;
        if (productName == undefined) {
            productName = "";
        }

        if (buyer == undefined) {
            buyer = "";
        }
        var count0 = 0;
        if(orderItem0.count != undefined){
            count0 = orderItem0.count;
        }

        returnStr += '<div class="order-detail-wrap clearfix"> ' +

            '<span>订单号：</span><span class="red"><a class="red" href="myOrder/detail/' + orderMain.orderNo + '">' + orderMain.orderNo + '</a></span> ' +
            '<span class="order-date">' + date0[0] + '</span> ' +
            '<span class="order-time">' + date0[1] + '</span> ' +

            '<ul class="order-detail-body clearfix"> ' +

            '<li class="order-detail-list clearfix" > ' +
            '<span class="order-detail-img fl">' +
            '<img onclick="goToDetail(\'' + orderItem0.goodsId + '\')" src="' + imgItem0 + '" alt=""/>' +
            '</span> ' +
            '<span class="order-detail-desc fl"> ' +
            '<a onclick="goToDetail(\'' + orderItem0.goodsId + '\')"  style="cursor: pointer;">' + productName + '</a> ' +

            '</span> ' +
            '<span class="order-detail-count-wrap fl">' +
            '×<span class="order-detail-count">' + count0 + '</span> ' +
            '</span> ' +

            '<span class="order-detail-deliver fl">' + buyer + '</span> ' +

            '<span class="order-detail-payment fl"> ' +
            '<span class="order-detail-jf">' + score + '</span>积分' +
            '<span class="order-detail-money">+' + payMoney + '元</span> ' +

            '</span> ' +
            '<span class="order-detail-finish fl clearfix"> ';

        switch (orderMain.status) {
            case '0':
            {
                returnStr += '<span class="block mt3" style="cursor: default;">待付款</span> ';
                returnStr += '<a href="javascript:void(0);" onclick="toPay(\'' + orderMain.orderNo + '\')" class="block">立即支付</a>' +
                    '<a href="javascript:void(0);" onclick="isCancel(\'' + orderMain.id + '\',this,\'' + orderMain.orderNo + '\')" class="block">取消订单</a>';
                returnStr += '<a href="myOrder/detail/' + orderMain.orderNo + '" class="block">订单详情</a> ';
            }
                break;
            case '1':
            {
                returnStr += '<span class="block mt3" style="cursor: default;">待付款</span> ';
                returnStr += '<a href="javascript:void(0);" onclick="toPay(\'' + orderMain.orderNo + '\')" class="block">立即支付</a>' +
                    '<a href="javascript:void(0);" onclick="isCancel(\'' + orderMain.id + '\',this,\'' + orderMain.orderNo + '\')" class="block">取消订单</a>';
                returnStr += '<a href="myOrder/detail/' + orderMain.orderNo + '" class="block">订单详情</a> ';

            }
                break;
            case '2':
            {
                returnStr += '<span class="block mt5" style="cursor: default;">待收货</span> ';
                //returnStr +='<a href="javascript:void(0);" class="block" onclick="isCancel(\'' + orderMain.id + '\',this,\'' + orderMain.orderNo + '\')">取消订单</a>';
                returnStr += '<a href="myOrder/detail/' + orderMain.orderNo + '" class="block">订单详情</a> ';
            }
                break;
            case '3':
            {
                returnStr += '<span class="block mt5" style="cursor: default;">待收货</span> ';
                //returnStr +='<a href="javascript:void(0);" class="block" onclick="isCancel(\'' + orderMain.id + '\',this,\'' + orderMain.orderNo + '\')">取消订单</a>';
                returnStr += '<a href="myOrder/detail/' + orderMain.orderNo + '" class="block">订单详情</a> ';
            }
                break;
            case '4':
            {
                returnStr += '<span class="block mt5" style="cursor: default;">已完成</span> ';
                returnStr += '<a href="myOrder/detail/' + orderMain.orderNo + '" class="block">订单详情</a> ';
            }
                break;
            case '5':
            {
                returnStr += '<span class="block mt5" style="cursor: default;">已完成</span> ';
                returnStr += '<a href="myOrder/detail/' + orderMain.orderNo + '" class="block">订单详情</a> ';
            }
                break;
            case '6':
            {
                returnStr += '<span class="block mt5" style="cursor: default;">已取消</span> ';
                returnStr += '<a href="myOrder/detail/' + orderMain.orderNo + '" class="block">订单详情</a> ';
            }
                break;
            case '7':
            {
                returnStr += '<span class="block mt5" style="cursor: default;">拒收</span> ';
                returnStr += '<a href="myOrder/detail/' + orderMain.orderNo + '" class="block">订单详情</a> ';
            }
                break;
            case '8':
            {
                returnStr += '<span class="block mt5" style="cursor: default;">已取消</span> ';
                returnStr += '<a href="myOrder/detail/' + orderMain.orderNo + '" class="block">订单详情</a> ';
            }
                break;
            default:
            {
                returnStr += '<span class="block mt5" style="cursor: default;">处理中</span> ';
                returnStr += '<a href="myOrder/detail/' + orderMain.orderNo + '" class="block">订单详情</a> ';
            }
                break;
        }


        returnStr += '</span> ' +
            '</li> ';

        for (var i = 1; i < picList.length; i++) {
            var itemN = picList[i].ITEM;
            var imgN = picList[i].IMG;

            var count = 0;
            if(itemN.count != undefined){
                count = itemN.count;
            }

            returnStr += '<li class="order-detail-list clearfix"> ' +
                '<span class="order-detail-img fl"> ' +
                '<img onclick="goToDetail(\'' + itemN.goodsId + '\')" src="' + imgN + '" alt=""/> ' +
                '</span> ' +
                '<span class="order-detail-desc fl"> ' +
                '<a onclick="goToDetail(\'' + itemN.goodsId + '\')"  style="cursor: pointer;">' + itemN.productName + '</a> ' +
                '</span> ' +
                '<span class="order-detail-count-wrap fl">' +
                '×<span class="order-detail-count">' + count + '</span> ' +
                '</span> ' +
                '<span class="order-detail-deliver fl"></span> ' +
                '<span class="order-detail-payment fl"> ' +
                '</span> ' +
                '<span class="order-detail-status fl clearfix"> ' +
                '</span> ' +
                '</li> ';
        }

        returnStr += '</ul> ' +

            '</div>';

    });
    return returnStr;
}

function goToDetail(goodsId) {
    window.location.href = "../../score/goodsdetails?goodsId=" + goodsId;
}


/**
 * 时间格式化
 * @param format
 * @returns {*}
 */
Date.prototype.format = function (format) {
    var o = {
        "M+": this.getMonth() + 1, //month
        "d+": this.getDate(),    //day
        "h+": this.getHours(),   //hour
        "m+": this.getMinutes(), //minute
        "s+": this.getSeconds(), //second
        "q+": Math.floor((this.getMonth() + 3) / 3),  //quarter
        "S": this.getMilliseconds() //millisecond
    }
    if (/(y+)/.test(format)) format = format.replace(RegExp.$1,
        (this.getFullYear() + "").substr(4 - RegExp.$1.length));
    for (var k in o)if (new RegExp("(" + k + ")").test(format))
        format = format.replace(RegExp.$1,
            RegExp.$1.length == 1 ? o[k] :
                ("00" + o[k]).substr(("" + o[k]).length));
    return format;
}


function toPay(orderNo) {      //去支付
    //console.log("立即支付:" + orderNo);
    window.location.href = "../../../../score/showPayGateWay?orderNo=" + orderNo;
}

var orderIdSure;
var elemetOrder;
var sureCancel;
var cancelOrderNo;
function isCancel(orderId, element, cancelOrderN) {
    orderIdSure = orderId;
    elemetOrder = element;
    cancelOrderNo = cancelOrderN;
    sureCancel = 1;//弹框为取消订单
    $("#word").html("温馨提示：订单成功取消后无法恢复！");
    showFrame();
}

function cancleOrder() {   //确认取消订单
    $.post("cancelOrder", {orderNo: cancelOrderNo}, function (data) {
        //console.log(data);

        if (data.code == "0") {
            location.reload();
        } else {
            $("#tip").html(data.msg);
            showFrame1();
        }
    })
}


function showFrame() {
    $("#popupBg").show();
    $("#popupBox").show();
}
function showFrame1() {
    $("#popupBg1").show();
    $("#popupBox1").show();

}
function clearFrame() {
    $("#popupBg").hide();
    $("#popupBox").hide();
}

function clearFrame1() {
    $("#popupBg1").hide();
    $("#popupBox1").hide();
    window.location.reload();
}

function isSure(orderId, element) {   //再次确认收到货
    sureCancel = 0;//弹框为确认收货
    orderIdSure = orderId;
    elemetOrder = element;
    $("#word").html("温馨提示：请再次确认，您已经收到所有商品！");
    showFrame();
}


function dealFrame() {
    clearFrame();
    if (sureCancel == 0) {
        sureGet();
    } else {
        cancleOrder();
    }
}


function sureGet() {   //确认收货
    var element = elemetOrder;
    var orderId = orderIdSure;
    $.post("sureGet", {orderId: orderId}, function (data) {
        if (data == "success") {
            location.reload();
        } else {
            $("#tip").html("收货确认失败");
            showFrame1();
        }

    });
}
