/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.cloud.discovery;

import de.codecentric.boot.admin.server.cloud.discovery.ServiceInstanceConverter;
import de.codecentric.boot.admin.server.domain.values.Registration;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class DefaultServiceInstanceConverter
implements ServiceInstanceConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServiceInstanceConverter.class);
    private static final String[] KEYS_MANAGEMENT_SCHEME = new String[]{"management.scheme", "management-scheme"};
    private static final String[] KEYS_MANAGEMENT_ADDRESS = new String[]{"management.address", "management-address"};
    private static final String[] KEYS_MANAGEMENT_PORT = new String[]{"management.port", "management-port"};
    private static final String[] KEYS_MANAGEMENT_PATH = new String[]{"management.context-path", "management-context-path"};
    private static final String[] KEYS_HEALTH_PATH = new String[]{"health.path", "health-path"};
    private String managementContextPath = "/actuator";
    private String healthEndpointPath = "health";

    @Nullable
    private static String getMetadataValue(ServiceInstance instance, String[] keys) {
        Map metadata = instance.getMetadata();
        for (String key : keys) {
            String value = (String)metadata.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public Registration convert(ServiceInstance instance) {
        LOGGER.debug("Converting service '{}' running at '{}' with metadata {}", new Object[]{instance.getServiceId(), instance.getUri(), instance.getMetadata()});
        String healthUrl = this.getHealthUrl(instance).toString();
        String managementUrl = this.getManagementUrl(instance).toString();
        String serviceUrl = this.getServiceUrl(instance).toString();
        return Registration.create((String)instance.getServiceId(), (String)healthUrl).managementUrl(managementUrl).serviceUrl(serviceUrl).metadata(this.getMetadata(instance)).build();
    }

    protected URI getHealthUrl(ServiceInstance instance) {
        return UriComponentsBuilder.fromUri((URI)this.getManagementUrl(instance)).path("/").path(this.getHealthPath(instance)).build().toUri();
    }

    protected String getHealthPath(ServiceInstance instance) {
        String healthPath = DefaultServiceInstanceConverter.getMetadataValue(instance, KEYS_HEALTH_PATH);
        if (StringUtils.hasText((String)healthPath)) {
            return healthPath;
        }
        return this.healthEndpointPath;
    }

    protected URI getManagementUrl(ServiceInstance instance) {
        UriComponentsBuilder builder;
        URI serviceUrl = this.getServiceUrl(instance);
        String managementScheme = this.getManagementScheme(instance);
        String managementHost = this.getManagementHost(instance);
        int managementPort = this.getManagementPort(instance);
        if (serviceUrl.getHost().equals(managementHost) && serviceUrl.getScheme().equals(managementScheme) && serviceUrl.getPort() == managementPort) {
            builder = UriComponentsBuilder.fromUri((URI)serviceUrl);
        } else {
            builder = UriComponentsBuilder.newInstance().scheme(managementScheme).host(managementHost);
            if (managementPort != -1) {
                builder.port(managementPort);
            }
        }
        return builder.path("/").path(this.getManagementPath(instance)).build().toUri();
    }

    private String getManagementScheme(ServiceInstance instance) {
        String managementServerScheme = DefaultServiceInstanceConverter.getMetadataValue(instance, KEYS_MANAGEMENT_SCHEME);
        if (StringUtils.hasText((String)managementServerScheme)) {
            return managementServerScheme;
        }
        return this.getServiceUrl(instance).getScheme();
    }

    protected String getManagementHost(ServiceInstance instance) {
        String managementServerHost = DefaultServiceInstanceConverter.getMetadataValue(instance, KEYS_MANAGEMENT_ADDRESS);
        if (StringUtils.hasText((String)managementServerHost)) {
            return managementServerHost;
        }
        return this.getServiceUrl(instance).getHost();
    }

    protected int getManagementPort(ServiceInstance instance) {
        String managementPort = DefaultServiceInstanceConverter.getMetadataValue(instance, KEYS_MANAGEMENT_PORT);
        if (StringUtils.hasText((String)managementPort)) {
            return Integer.parseInt(managementPort);
        }
        return this.getServiceUrl(instance).getPort();
    }

    protected String getManagementPath(ServiceInstance instance) {
        String managementPath = DefaultServiceInstanceConverter.getMetadataValue(instance, KEYS_MANAGEMENT_PATH);
        if (StringUtils.hasText((String)managementPath)) {
            return managementPath;
        }
        return this.managementContextPath;
    }

    protected URI getServiceUrl(ServiceInstance instance) {
        return instance.getUri();
    }

    protected Map<String, String> getMetadata(ServiceInstance instance) {
        return instance.getMetadata() != null ? instance.getMetadata().entrySet().stream().filter(e -> e.getKey() != null && e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)) : Collections.emptyMap();
    }

    public String getManagementContextPath() {
        return this.managementContextPath;
    }

    public void setManagementContextPath(String managementContextPath) {
        this.managementContextPath = managementContextPath;
    }

    public String getHealthEndpointPath() {
        return this.healthEndpointPath;
    }

    public void setHealthEndpointPath(String healthEndpointPath) {
        this.healthEndpointPath = healthEndpointPath;
    }
}

