/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.ui.extensions;

import de.codecentric.boot.admin.server.ui.extensions.UiExtension;
import de.codecentric.boot.admin.server.ui.extensions.UiExtensions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;

public class UiExtensionsScanner {
    private static final Logger log = LoggerFactory.getLogger(UiExtensionsScanner.class);
    private final ResourcePatternResolver resolver;

    public UiExtensionsScanner(ResourcePatternResolver resolver) {
        this.resolver = resolver;
    }

    public UiExtensions scan(String ... locations) throws IOException {
        ArrayList<UiExtension> extensions = new ArrayList<UiExtension>();
        for (String location : locations) {
            for (Resource resource : this.resolveAssets(location)) {
                String resourcePath = this.getResourcePath(location, resource);
                if (resourcePath == null || !resource.isReadable()) continue;
                UiExtension extension = new UiExtension(resourcePath, location + resourcePath);
                log.debug("Found UiExtension {}", (Object)extension);
                extensions.add(extension);
            }
        }
        return new UiExtensions(extensions);
    }

    private List<Resource> resolveAssets(String location) throws IOException {
        String widerLocation = this.toPattern(location);
        return Stream.concat(Arrays.stream(this.resolver.getResources(widerLocation + "**/*.js")), Arrays.stream(this.resolver.getResources(widerLocation + "**/*.css"))).collect(Collectors.toList());
    }

    private String toPattern(String location) {
        return location.replace("classpath:", "classpath*:");
    }

    @Nullable
    private String getResourcePath(String location, Resource resource) throws IOException {
        String locationWithoutPrefix = location.replaceFirst("^[^:]+:", "");
        Matcher m = Pattern.compile(Pattern.quote(locationWithoutPrefix) + "(.+)$").matcher(resource.getURI().toString());
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }
}

