/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.discovery;

import de.codecentric.boot.admin.discovery.DefaultServiceInstanceConverter;
import de.codecentric.boot.admin.discovery.ServiceInstanceConverter;
import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.registry.ApplicationRegistry;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.client.discovery.event.HeartbeatMonitor;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.discovery.event.ParentHeartbeatEvent;
import org.springframework.context.event.EventListener;
import org.springframework.util.PatternMatchUtils;

public class ApplicationDiscoveryListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationDiscoveryListener.class);
    private static final String SOURCE = "discovery";
    private final DiscoveryClient discoveryClient;
    private final ApplicationRegistry registry;
    private final HeartbeatMonitor monitor = new HeartbeatMonitor();
    private ServiceInstanceConverter converter = new DefaultServiceInstanceConverter();
    private Set<String> ignoredServices = new HashSet<String>();
    private Set<String> services = new HashSet<String>(Collections.singletonList("*"));

    public ApplicationDiscoveryListener(DiscoveryClient discoveryClient, ApplicationRegistry registry) {
        this.discoveryClient = discoveryClient;
        this.registry = registry;
    }

    @EventListener
    public void onInstanceRegistered(InstanceRegisteredEvent<?> event) {
        this.discover();
    }

    @EventListener
    public void onParentHeartbeat(ParentHeartbeatEvent event) {
        this.discoverIfNeeded(event.getValue());
    }

    @EventListener
    public void onApplicationEvent(HeartbeatEvent event) {
        this.discoverIfNeeded(event.getValue());
    }

    private void discoverIfNeeded(Object value) {
        if (this.monitor.update(value)) {
            this.discover();
        }
    }

    protected void discover() {
        Set<String> staleApplicationIds = this.getAllApplicationIdsFromRegistry();
        for (String serviceId : this.discoveryClient.getServices()) {
            if (!this.ignoreService(serviceId) && this.registerService(serviceId)) {
                for (ServiceInstance instance : this.discoveryClient.getInstances(serviceId)) {
                    String applicationId = this.register(instance);
                    staleApplicationIds.remove(applicationId);
                }
                continue;
            }
            LOGGER.debug("Ignoring discovered service {}", (Object)serviceId);
        }
        for (String staleApplicationId : staleApplicationIds) {
            LOGGER.info("Application ({}) missing in DiscoveryClient services ", (Object)staleApplicationId);
            this.registry.deregister(staleApplicationId);
        }
    }

    protected boolean ignoreService(String serviceId) {
        return this.checkPatternIsMatching(serviceId, this.ignoredServices);
    }

    protected boolean registerService(String serviceId) {
        return this.checkPatternIsMatching(serviceId, this.services);
    }

    protected boolean checkPatternIsMatching(String serviceId, Set<String> patterns) {
        for (String pattern : patterns) {
            if (!PatternMatchUtils.simpleMatch((String)pattern, (String)serviceId)) continue;
            return true;
        }
        return false;
    }

    protected final Set<String> getAllApplicationIdsFromRegistry() {
        HashSet<String> result = new HashSet<String>();
        for (Application application : this.registry.getApplications()) {
            if (this.ignoreService(application.getName()) || !this.registerService(application.getName()) || !SOURCE.equals(application.getSource())) continue;
            result.add(application.getId());
        }
        return result;
    }

    protected String register(ServiceInstance instance) {
        try {
            Application application = this.converter.convert(instance);
            application = Application.copyOf(application).withSource(SOURCE).build();
            if (application != null) {
                LOGGER.debug("Registering discovered application {}", (Object)application);
                return this.registry.register(application).getId();
            }
            LOGGER.warn("No application for service {} registered", (Object)instance);
        }
        catch (Exception ex) {
            LOGGER.error("Couldn't register application for service {}", (Object)instance, (Object)ex);
        }
        return null;
    }

    public void setConverter(ServiceInstanceConverter converter) {
        this.converter = converter;
    }

    public void setIgnoredServices(Set<String> ignoredServices) {
        this.ignoredServices = ignoredServices;
    }

    public Set<String> getIgnoredServices() {
        return this.ignoredServices;
    }

    public Set<String> getServices() {
        return this.services;
    }

    public void setServices(Set<String> services) {
        this.services = services;
    }
}

