/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;

public class SanitizingMapSerializer
extends StdSerializer<Map<String, String>> {
    private static final long serialVersionUID = 1L;
    private final Pattern[] keysToSanitize;

    public SanitizingMapSerializer(String[] patterns) {
        super(Map.class);
        this.keysToSanitize = SanitizingMapSerializer.createPatterns(patterns);
    }

    private static Pattern[] createPatterns(String ... keys) {
        Pattern[] patterns = new Pattern[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            patterns[i] = Pattern.compile(keys[i], 2);
        }
        return patterns;
    }

    public void serialize(Map<String, String> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        for (Map.Entry<String, String> entry : value.entrySet()) {
            gen.writeStringField(entry.getKey(), this.sanitize(entry.getKey(), entry.getValue()));
        }
        gen.writeEndObject();
    }

    private String sanitize(String key, String value) {
        for (Pattern pattern : this.keysToSanitize) {
            if (!pattern.matcher(key).matches()) continue;
            return value == null ? null : "******";
        }
        return value;
    }
}

