/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.notify;

import de.codecentric.boot.admin.event.ClientApplicationEvent;
import de.codecentric.boot.admin.notify.AbstractStatusChangeNotifier;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.web.client.RestTemplate;

public class TelegramNotifier
extends AbstractStatusChangeNotifier {
    private static final String DEFAULT_MESSAGE = "<strong>#{application.name}</strong>/#{application.id} is <strong>#{to.status}</strong>";
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private RestTemplate restTemplate = new RestTemplate();
    private String apiUrl = "https://api.telegram.org";
    private String chatId;
    private String authToken;
    private String parse_mode = "HTML";
    private boolean disableNotify = false;
    private Expression message = this.parser.parseExpression("<strong>#{application.name}</strong>/#{application.id} is <strong>#{to.status}</strong>", ParserContext.TEMPLATE_EXPRESSION);

    @Override
    protected void doNotify(ClientApplicationEvent event) {
        this.restTemplate.getForObject(this.buildUrl(), Void.class, this.createMessage(event));
    }

    protected String buildUrl() {
        return String.format("%s/bot%s/sendmessage?chat_id={chat_id}&text={text}&parse_mode={parse_mode}&disable_notification={disable_notification}", this.apiUrl, this.authToken);
    }

    private Map<String, Object> createMessage(ClientApplicationEvent event) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("chat_id", this.chatId);
        parameters.put("parse_mode", this.parse_mode);
        parameters.put("disable_notification", this.disableNotify);
        parameters.put("text", this.getText(event));
        return parameters;
    }

    protected String getText(ClientApplicationEvent event) {
        return (String)this.message.getValue((Object)event, String.class);
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setRestTemplate(RestTemplateBuilder builder) {
        this.restTemplate = builder.build();
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getChatId() {
        return this.chatId;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public boolean isDisableNotify() {
        return this.disableNotify;
    }

    public void setDisableNotify(boolean disableNotify) {
        this.disableNotify = disableNotify;
    }

    public String getParse_mode() {
        return this.parse_mode;
    }

    public void setParse_mode(String parse_mode) {
        this.parse_mode = parse_mode;
    }

    public void setMessage(String message) {
        this.message = this.parser.parseExpression(message, ParserContext.TEMPLATE_EXPRESSION);
    }
}

