/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.web;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.values.BuildVersion;
import de.codecentric.boot.admin.server.domain.values.StatusInfo;
import de.codecentric.boot.admin.server.eventstore.InstanceEventPublisher;
import de.codecentric.boot.admin.server.services.InstanceRegistry;
import de.codecentric.boot.admin.server.web.AdminController;
import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@AdminController
@ResponseBody
public class ApplicationsController {
    private static final Logger log = LoggerFactory.getLogger(ApplicationsController.class);
    private static final ServerSentEvent<?> PING = ServerSentEvent.builder().comment("ping").build();
    private static final Flux<ServerSentEvent<?>> PING_FLUX = Flux.interval((Duration)Duration.ZERO, (Duration)Duration.ofSeconds(10L)).map(tick -> PING);
    private final InstanceRegistry registry;
    private final InstanceEventPublisher eventPublisher;

    public ApplicationsController(InstanceRegistry registry, InstanceEventPublisher eventPublisher) {
        this.registry = registry;
        this.eventPublisher = eventPublisher;
    }

    @GetMapping(path={"/applications"}, produces={"application/json"})
    public Flux<Application> applications() {
        return this.registry.getInstances().filter(Instance::isRegistered).groupBy(instance -> instance.getRegistration().getName()).flatMap(grouped -> this.toApplication((String)grouped.key(), (Flux<Instance>)grouped));
    }

    @GetMapping(path={"/applications/{name}"}, produces={"application/json"})
    public Mono<ResponseEntity<Application>> application(@PathVariable(value="name") String name) {
        return this.toApplication(name, (Flux<Instance>)this.registry.getInstances(name).filter(Instance::isRegistered)).map(ResponseEntity::ok).defaultIfEmpty((Object)ResponseEntity.notFound().build());
    }

    @GetMapping(path={"/applications"}, produces={"text/event-stream"})
    public Flux<ServerSentEvent<Application>> applicationsStream() {
        return Flux.from((Publisher)this.eventPublisher).flatMap(event -> this.registry.getInstance(event.getInstance())).map(this::getApplicationForInstance).flatMap(group -> this.toApplication((String)group.getT1(), (Flux<Instance>)((Flux)group.getT2()))).map(application -> ServerSentEvent.builder((Object)application).build()).mergeWith(ApplicationsController.ping());
    }

    @DeleteMapping(path={"/applications/{name}"})
    public Mono<ResponseEntity<Void>> unregister(@PathVariable(value="name") String name) {
        log.debug("Unregister application with name '{}'", (Object)name);
        return this.registry.getInstances(name).flatMap(instance -> this.registry.deregister(instance.getId())).collectList().map(deregistered -> !deregistered.isEmpty() ? ResponseEntity.noContent().build() : ResponseEntity.notFound().build());
    }

    protected Tuple2<String, Flux<Instance>> getApplicationForInstance(Instance instance) {
        String name = instance.getRegistration().getName();
        return Tuples.of((Object)name, (Object)this.registry.getInstances(name).filter(Instance::isRegistered));
    }

    protected Mono<Application> toApplication(String name, Flux<Instance> instances) {
        return instances.collectList().filter(instanceList -> !instanceList.isEmpty()).map(instanceList -> {
            Application group = new Application(name);
            group.setInstances((List<Instance>)instanceList);
            group.setBuildVersion(this.getBuildVersion((List<Instance>)instanceList));
            Tuple2<String, Instant> status = this.getStatus((List<Instance>)instanceList);
            group.setStatus((String)status.getT1());
            group.setStatusTimestamp((Instant)status.getT2());
            return group;
        });
    }

    protected BuildVersion getBuildVersion(List<Instance> instances) {
        List versions = instances.stream().map(Instance::getBuildVersion).filter(Objects::nonNull).distinct().sorted().collect(Collectors.toList());
        if (versions.isEmpty()) {
            return null;
        }
        if (versions.size() == 1) {
            return (BuildVersion)versions.get(0);
        }
        return BuildVersion.valueOf(versions.get(0) + " ... " + versions.get(versions.size() - 1));
    }

    protected Tuple2<String, Instant> getStatus(List<Instance> instances) {
        Map<String, Instant> statusWithTime = instances.stream().collect(Collectors.toMap(instance -> instance.getStatusInfo().getStatus(), Instance::getStatusTimestamp, this::getMax));
        if (statusWithTime.size() == 1) {
            Map.Entry<String, Instant> e2 = statusWithTime.entrySet().iterator().next();
            return Tuples.of((Object)e2.getKey(), (Object)e2.getValue());
        }
        if (statusWithTime.containsKey("UP")) {
            Instant oldestNonUp = statusWithTime.entrySet().stream().filter(e -> !"UP".equals(e.getKey())).map(Map.Entry::getValue).min(Comparator.naturalOrder()).orElse(Instant.EPOCH);
            Instant latest = this.getMax(oldestNonUp, statusWithTime.getOrDefault("UP", Instant.EPOCH));
            return Tuples.of((Object)"RESTRICTED", (Object)latest);
        }
        return statusWithTime.entrySet().stream().min(Map.Entry.comparingByKey(StatusInfo.severity())).map(e -> Tuples.of(e.getKey(), e.getValue())).orElse(Tuples.of((Object)"UNKNOWN", (Object)Instant.EPOCH));
    }

    private Instant getMax(Instant t1, Instant t2) {
        return t1.compareTo(t2) >= 0 ? t1 : t2;
    }

    private static <T> Flux<ServerSentEvent<T>> ping() {
        return PING_FLUX;
    }

    public static class Application {
        private final String name;
        private BuildVersion buildVersion;
        private String status;
        private Instant statusTimestamp;
        private List<Instance> instances;

        public Application(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public BuildVersion getBuildVersion() {
            return this.buildVersion;
        }

        public String getStatus() {
            return this.status;
        }

        public Instant getStatusTimestamp() {
            return this.statusTimestamp;
        }

        public List<Instance> getInstances() {
            return this.instances;
        }

        public void setBuildVersion(BuildVersion buildVersion) {
            this.buildVersion = buildVersion;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public void setStatusTimestamp(Instant statusTimestamp) {
            this.statusTimestamp = statusTimestamp;
        }

        public void setInstances(List<Instance> instances) {
            this.instances = instances;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Application)) {
                return false;
            }
            Application other = (Application)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            BuildVersion this$buildVersion = this.getBuildVersion();
            BuildVersion other$buildVersion = other.getBuildVersion();
            if (this$buildVersion == null ? other$buildVersion != null : !((Object)this$buildVersion).equals(other$buildVersion)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            Instant this$statusTimestamp = this.getStatusTimestamp();
            Instant other$statusTimestamp = other.getStatusTimestamp();
            if (this$statusTimestamp == null ? other$statusTimestamp != null : !((Object)this$statusTimestamp).equals(other$statusTimestamp)) {
                return false;
            }
            List<Instance> this$instances = this.getInstances();
            List<Instance> other$instances = other.getInstances();
            return !(this$instances == null ? other$instances != null : !((Object)this$instances).equals(other$instances));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Application;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            BuildVersion $buildVersion = this.getBuildVersion();
            result = result * 59 + ($buildVersion == null ? 43 : ((Object)$buildVersion).hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            Instant $statusTimestamp = this.getStatusTimestamp();
            result = result * 59 + ($statusTimestamp == null ? 43 : ((Object)$statusTimestamp).hashCode());
            List<Instance> $instances = this.getInstances();
            result = result * 59 + ($instances == null ? 43 : ((Object)$instances).hashCode());
            return result;
        }

        public String toString() {
            return "ApplicationsController.Application(name=" + this.getName() + ", buildVersion=" + this.getBuildVersion() + ", status=" + this.getStatus() + ", statusTimestamp=" + this.getStatusTimestamp() + ", instances=" + this.getInstances() + ")";
        }
    }
}

