/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.domain.entities;

import de.codecentric.boot.admin.server.domain.events.InstanceDeregisteredEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceEndpointsDetectedEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceInfoChangedEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceRegisteredEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceRegistrationUpdatedEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceStatusChangedEvent;
import de.codecentric.boot.admin.server.domain.values.BuildVersion;
import de.codecentric.boot.admin.server.domain.values.Endpoints;
import de.codecentric.boot.admin.server.domain.values.Info;
import de.codecentric.boot.admin.server.domain.values.InstanceId;
import de.codecentric.boot.admin.server.domain.values.Registration;
import de.codecentric.boot.admin.server.domain.values.StatusInfo;
import de.codecentric.boot.admin.server.domain.values.Tags;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.util.Assert;

public class Instance
implements Serializable {
    private final InstanceId id;
    private final long version;
    private final Registration registration;
    private final boolean registered;
    private final StatusInfo statusInfo;
    private final Instant statusTimestamp;
    private final Info info;
    private final List<InstanceEvent> unsavedEvents;
    private final Endpoints endpoints;
    private final BuildVersion buildVersion;
    private final Tags tags;

    private Instance(InstanceId id) {
        this(id, -1L, null, false, StatusInfo.ofUnknown(), Instant.EPOCH, Info.empty(), Endpoints.empty(), null, Tags.empty(), Collections.emptyList());
    }

    private Instance(InstanceId id, long version, Registration registration, boolean registered, StatusInfo statusInfo, Instant statusTimestamp, Info info, Endpoints endpoints, BuildVersion buildVersion, Tags tags, List<InstanceEvent> unsavedEvents) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        Assert.notNull((Object)endpoints, (String)"'endpoints' must not be null");
        Assert.notNull((Object)info, (String)"'info' must not be null");
        Assert.notNull((Object)statusInfo, (String)"'statusInfo' must not be null");
        this.id = id;
        this.version = version;
        this.registration = registration;
        this.registered = registered;
        this.statusInfo = statusInfo;
        this.statusTimestamp = statusTimestamp;
        this.info = info;
        this.endpoints = registered ? endpoints.withEndpoint("health", registration.getHealthUrl()) : endpoints;
        this.unsavedEvents = unsavedEvents;
        this.buildVersion = buildVersion;
        this.tags = tags;
    }

    public static Instance create(InstanceId id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        return new Instance(id);
    }

    public Instance register(Registration registration) {
        Assert.notNull((Object)registration, (String)"'registration' must not be null");
        if (!this.isRegistered()) {
            return this.apply(new InstanceRegisteredEvent(this.id, this.nextVersion(), registration), true);
        }
        if (!Objects.equals(this.registration, registration)) {
            return this.apply(new InstanceRegistrationUpdatedEvent(this.id, this.nextVersion(), registration), true);
        }
        return this;
    }

    public Instance deregister() {
        if (this.isRegistered()) {
            return this.apply(new InstanceDeregisteredEvent(this.id, this.nextVersion()), true);
        }
        return this;
    }

    public Instance withInfo(Info info) {
        Assert.notNull((Object)info, (String)"'info' must not be null");
        if (Objects.equals(this.info, info)) {
            return this;
        }
        return this.apply(new InstanceInfoChangedEvent(this.id, this.nextVersion(), info), true);
    }

    public Instance withStatusInfo(StatusInfo statusInfo) {
        Assert.notNull((Object)statusInfo, (String)"'statusInfo' must not be null");
        if (Objects.equals(this.statusInfo.getStatus(), statusInfo.getStatus())) {
            return this;
        }
        return this.apply(new InstanceStatusChangedEvent(this.id, this.nextVersion(), statusInfo), true);
    }

    public Instance withEndpoints(Endpoints endpoints) {
        Assert.notNull((Object)endpoints, (String)"'endpoints' must not be null");
        if (Objects.equals(this.endpoints, this.registered ? endpoints.withEndpoint("health", this.registration.getHealthUrl()) : endpoints)) {
            return this;
        }
        return this.apply(new InstanceEndpointsDetectedEvent(this.id, this.nextVersion(), endpoints), true);
    }

    public boolean isRegistered() {
        return this.registered;
    }

    List<InstanceEvent> getUnsavedEvents() {
        return Collections.unmodifiableList(this.unsavedEvents);
    }

    Instance clearUnsavedEvents() {
        return new Instance(this.id, this.version, this.registration, this.registered, this.statusInfo, this.statusTimestamp, this.info, this.endpoints, this.buildVersion, this.tags, Collections.emptyList());
    }

    Instance apply(Collection<InstanceEvent> events) {
        Assert.notNull(events, (String)"'events' must not be null");
        Instance instance = this;
        for (InstanceEvent event : events) {
            instance = instance.apply(event);
        }
        return instance;
    }

    Instance apply(InstanceEvent event) {
        return this.apply(event, false);
    }

    private Instance apply(InstanceEvent event, boolean isNewEvent) {
        Assert.notNull((Object)event, (String)"'event' must not be null");
        Assert.isTrue((boolean)this.id.equals(event.getInstance()), (String)"'event' must refer the same instance");
        Assert.isTrue((this.nextVersion() == event.getVersion() ? 1 : 0) != 0, () -> "Event " + event.getVersion() + " doesn't match exptected version " + this.nextVersion());
        List<InstanceEvent> unsavedEvents = this.appendToEvents(event, isNewEvent);
        if (event instanceof InstanceRegisteredEvent) {
            Registration registration = ((InstanceRegisteredEvent)event).getRegistration();
            return new Instance(this.id, event.getVersion(), registration, true, StatusInfo.ofUnknown(), event.getTimestamp(), Info.empty(), Endpoints.empty(), this.updateBuildVersion(registration.getMetadata()), this.updateTags(registration.getMetadata()), unsavedEvents);
        }
        if (event instanceof InstanceRegistrationUpdatedEvent) {
            Registration registration = ((InstanceRegistrationUpdatedEvent)event).getRegistration();
            return new Instance(this.id, event.getVersion(), registration, this.registered, this.statusInfo, this.statusTimestamp, this.info, this.endpoints, this.updateBuildVersion(registration.getMetadata(), this.info.getValues()), this.updateTags(registration.getMetadata(), this.info.getValues()), unsavedEvents);
        }
        if (event instanceof InstanceStatusChangedEvent) {
            StatusInfo statusInfo = ((InstanceStatusChangedEvent)event).getStatusInfo();
            return new Instance(this.id, event.getVersion(), this.registration, this.registered, statusInfo, event.getTimestamp(), this.info, this.endpoints, this.buildVersion, this.tags, unsavedEvents);
        }
        if (event instanceof InstanceEndpointsDetectedEvent) {
            Endpoints endpoints = ((InstanceEndpointsDetectedEvent)event).getEndpoints();
            return new Instance(this.id, event.getVersion(), this.registration, this.registered, this.statusInfo, this.statusTimestamp, this.info, endpoints, this.buildVersion, this.tags, unsavedEvents);
        }
        if (event instanceof InstanceInfoChangedEvent) {
            Info info = ((InstanceInfoChangedEvent)event).getInfo();
            return new Instance(this.id, event.getVersion(), this.registration, this.registered, this.statusInfo, this.statusTimestamp, info, this.endpoints, this.updateBuildVersion(this.registration.getMetadata(), info.getValues()), this.updateTags(this.registration.getMetadata(), info.getValues()), unsavedEvents);
        }
        if (event instanceof InstanceDeregisteredEvent) {
            return new Instance(this.id, event.getVersion(), this.registration, false, StatusInfo.ofUnknown(), event.getTimestamp(), Info.empty(), Endpoints.empty(), null, Tags.empty(), unsavedEvents);
        }
        return this;
    }

    private long nextVersion() {
        return this.version + 1L;
    }

    private List<InstanceEvent> appendToEvents(InstanceEvent event, boolean isNewEvent) {
        if (!isNewEvent) {
            return this.unsavedEvents;
        }
        ArrayList<InstanceEvent> events = new ArrayList<InstanceEvent>(this.unsavedEvents.size() + 1);
        events.addAll(this.unsavedEvents);
        events.add(event);
        return events;
    }

    @SafeVarargs
    private final BuildVersion updateBuildVersion(Map<String, ?> ... sources) {
        return Arrays.stream(sources).map(BuildVersion::from).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @SafeVarargs
    private final Tags updateTags(Map<String, ?> ... sources) {
        return Arrays.stream(sources).map(source -> Tags.from(source, "tags")).reduce(Tags.empty(), Tags::append);
    }

    public InstanceId getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public Registration getRegistration() {
        return this.registration;
    }

    public StatusInfo getStatusInfo() {
        return this.statusInfo;
    }

    public Instant getStatusTimestamp() {
        return this.statusTimestamp;
    }

    public Info getInfo() {
        return this.info;
    }

    public Endpoints getEndpoints() {
        return this.endpoints;
    }

    public BuildVersion getBuildVersion() {
        return this.buildVersion;
    }

    public Tags getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InstanceId this$id = this.getId();
        InstanceId other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        Registration this$registration = this.getRegistration();
        Registration other$registration = other.getRegistration();
        if (this$registration == null ? other$registration != null : !((Object)this$registration).equals(other$registration)) {
            return false;
        }
        if (this.isRegistered() != other.isRegistered()) {
            return false;
        }
        StatusInfo this$statusInfo = this.getStatusInfo();
        StatusInfo other$statusInfo = other.getStatusInfo();
        if (this$statusInfo == null ? other$statusInfo != null : !((Object)this$statusInfo).equals(other$statusInfo)) {
            return false;
        }
        Info this$info = this.getInfo();
        Info other$info = other.getInfo();
        if (this$info == null ? other$info != null : !((Object)this$info).equals(other$info)) {
            return false;
        }
        Endpoints this$endpoints = this.getEndpoints();
        Endpoints other$endpoints = other.getEndpoints();
        if (this$endpoints == null ? other$endpoints != null : !((Object)this$endpoints).equals(other$endpoints)) {
            return false;
        }
        BuildVersion this$buildVersion = this.getBuildVersion();
        BuildVersion other$buildVersion = other.getBuildVersion();
        if (this$buildVersion == null ? other$buildVersion != null : !((Object)this$buildVersion).equals(other$buildVersion)) {
            return false;
        }
        Tags this$tags = this.getTags();
        Tags other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Instance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InstanceId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        Registration $registration = this.getRegistration();
        result = result * 59 + ($registration == null ? 43 : ((Object)$registration).hashCode());
        result = result * 59 + (this.isRegistered() ? 79 : 97);
        StatusInfo $statusInfo = this.getStatusInfo();
        result = result * 59 + ($statusInfo == null ? 43 : ((Object)$statusInfo).hashCode());
        Info $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
        Endpoints $endpoints = this.getEndpoints();
        result = result * 59 + ($endpoints == null ? 43 : ((Object)$endpoints).hashCode());
        BuildVersion $buildVersion = this.getBuildVersion();
        result = result * 59 + ($buildVersion == null ? 43 : ((Object)$buildVersion).hashCode());
        Tags $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "Instance(id=" + this.getId() + ", version=" + this.getVersion() + ", registration=" + this.getRegistration() + ", registered=" + this.isRegistered() + ", statusInfo=" + this.getStatusInfo() + ", statusTimestamp=" + this.getStatusTimestamp() + ", info=" + this.getInfo() + ", endpoints=" + this.getEndpoints() + ", buildVersion=" + this.getBuildVersion() + ", tags=" + this.getTags() + ")";
    }
}

