/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.notify.AbstractStatusChangeNotifier;
import java.net.URI;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.DataBindingPropertyAccessor;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import reactor.core.publisher.Mono;

public class WebexNotifier
extends AbstractStatusChangeNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebexNotifier.class);
    private static final URI DEFAULT_URL = URI.create("https://webexapis.com/v1/messages");
    private static final String DEFAULT_MESSAGE = "<strong>#{instance.registration.name}</strong>/#{instance.id} is <strong>#{event.statusInfo.status}</strong>";
    private RestTemplate restTemplate;
    private URI url = DEFAULT_URL;
    @Nullable
    private String authToken;
    @Nullable
    private String roomId;
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private Expression message;

    public WebexNotifier(InstanceRepository repository, RestTemplate restTemplate) {
        super(repository);
        this.restTemplate = restTemplate;
        this.message = this.parser.parseExpression(DEFAULT_MESSAGE, ParserContext.TEMPLATE_EXPRESSION);
    }

    @Override
    protected Mono<Void> doNotify(InstanceEvent event, Instance instance) {
        if (this.authToken == null) {
            return Mono.error((Throwable)new IllegalStateException("'authToken' must not be null."));
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(this.authToken);
        LOGGER.debug("Event: {}", (Object)event.getInstance());
        return Mono.fromRunnable(() -> this.restTemplate.postForEntity(this.url, (Object)new HttpEntity(this.createMessage(event, instance), (MultiValueMap)headers), Void.class));
    }

    protected Object createMessage(InstanceEvent event, Instance instance) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("roomId", this.roomId);
        parameters.put("markdown", this.getText(event, instance));
        return parameters;
    }

    @Nullable
    protected String getText(InstanceEvent event, Instance instance) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("event", event);
        root.put("instance", instance);
        root.put("lastStatus", this.getLastStatus(event.getInstance()));
        SimpleEvaluationContext context = SimpleEvaluationContext.forPropertyAccessors((PropertyAccessor[])new PropertyAccessor[]{DataBindingPropertyAccessor.forReadOnlyAccess(), new MapAccessor()}).withRootObject(root).build();
        return (String)this.message.getValue((EvaluationContext)context, String.class);
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    @Nullable
    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(@Nullable String authToken) {
        this.authToken = authToken;
    }

    @Nullable
    public String getRoomId() {
        return this.roomId;
    }

    public void setRoomId(@Nullable String roomId) {
        this.roomId = roomId;
    }

    public Expression getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = this.parser.parseExpression(message, ParserContext.TEMPLATE_EXPRESSION);
    }
}

