/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify.filter;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.notify.filter.ExpiringNotificationFilter;
import java.time.Instant;
import org.springframework.lang.Nullable;

public class ApplicationNameNotificationFilter
extends ExpiringNotificationFilter {
    private final String applicationName;

    public ApplicationNameNotificationFilter(String applicationName, @Nullable Instant expiry) {
        super(expiry);
        this.applicationName = applicationName;
    }

    @Override
    protected boolean doFilter(InstanceEvent event, Instance instance) {
        return this.applicationName.equals(instance.getRegistration().getName());
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String toString() {
        return "NotificationFilter [applicationName=" + this.applicationName + ", expiry=" + this.getExpiry() + "]";
    }
}

