/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.services;

import de.codecentric.boot.admin.config.AdminClientProperties;
import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.services.ApplicationFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.embedded.Ssl;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.util.UriComponentsBuilder;

public class DefaultApplicationFactory
implements ApplicationFactory {
    private AdminClientProperties client;
    private ServerProperties server;
    private ManagementServerProperties management;
    private Integer localServerPort;
    private Integer localManagementPort;
    private String healthEndpointPath;

    public DefaultApplicationFactory(AdminClientProperties client, ManagementServerProperties management, ServerProperties server, String healthEndpointPath) {
        this.client = client;
        this.management = management;
        this.server = server;
        this.healthEndpointPath = healthEndpointPath;
    }

    @Override
    public Application createApplication() {
        return Application.create(this.getName()).withHealthUrl(this.getHealthUrl()).withManagementUrl(this.getManagementUrl()).withServiceUrl(this.getServiceUrl()).build();
    }

    protected String getName() {
        return this.client.getName();
    }

    protected String getServiceUrl() {
        if (this.client.getServiceUrl() != null) {
            return this.client.getServiceUrl();
        }
        if (this.getLocalServerPort() == null) {
            throw new IllegalStateException("serviceUrl must be set when deployed to servlet-container");
        }
        return UriComponentsBuilder.newInstance().scheme(this.getScheme(this.server.getSsl())).host(this.getServiceHost()).port(this.getLocalServerPort().intValue()).path(this.server.getContextPath()).toUriString();
    }

    protected String getManagementUrl() {
        if (this.client.getManagementUrl() != null) {
            return this.client.getManagementUrl();
        }
        if (this.getLocalManagementPort() == null || this.getLocalManagementPort().equals(this.getLocalServerPort())) {
            return UriComponentsBuilder.fromHttpUrl((String)this.getServiceUrl()).pathSegment(this.server.getServletPrefix().split("/")).pathSegment(StringUtils.trimLeadingCharacter((String)this.management.getContextPath(), (char)'/').split("/")).toUriString();
        }
        Ssl ssl = this.management.getSsl() != null ? this.management.getSsl() : this.server.getSsl();
        return UriComponentsBuilder.newInstance().scheme(this.getScheme(ssl)).host(this.getManagementHost()).port(this.getLocalManagementPort().intValue()).path(this.management.getContextPath()).toUriString();
    }

    protected String getHealthUrl() {
        if (this.client.getHealthUrl() != null) {
            return this.client.getHealthUrl();
        }
        return UriComponentsBuilder.fromHttpUrl((String)this.getManagementUrl()).pathSegment(StringUtils.trimLeadingCharacter((String)this.getHealthEndpointPath(), (char)'/').split("/")).toUriString();
    }

    protected String getServiceHost() {
        InetAddress address = this.server.getAddress();
        if (address == null) {
            address = this.getLocalHost();
        }
        return this.getHost(address);
    }

    protected String getManagementHost() {
        InetAddress address = this.management.getAddress();
        if (address != null) {
            return this.getHost(address);
        }
        return this.getServiceHost();
    }

    protected InetAddress getLocalHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    protected Integer getLocalServerPort() {
        return this.localServerPort;
    }

    protected Integer getLocalManagementPort() {
        return this.localManagementPort;
    }

    protected String getHealthEndpointPath() {
        return this.healthEndpointPath;
    }

    protected String getScheme(Ssl ssl) {
        return ssl != null && ssl.isEnabled() ? "https" : "http";
    }

    protected String getHost(InetAddress address) {
        return this.client.isPreferIp() ? address.getHostAddress() : address.getCanonicalHostName();
    }

    @EventListener
    public void onApplicationReady(ApplicationReadyEvent event) {
        if (event.getApplicationContext() instanceof WebApplicationContext) {
            this.localServerPort = (Integer)event.getApplicationContext().getEnvironment().getProperty("local.server.port", Integer.class);
            this.localManagementPort = (Integer)event.getApplicationContext().getEnvironment().getProperty("local.management.port", Integer.class, (Object)this.localServerPort);
        }
    }
}

