/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.comparison;

import de.danielbechler.diff.comparison.ComparisonStrategy;
import de.danielbechler.diff.node.DiffNode;
import de.danielbechler.util.Assert;
import de.danielbechler.util.Exceptions;
import de.danielbechler.util.Objects;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualsOnlyComparisonStrategy
implements ComparisonStrategy {
    private final String equalsValueProviderMethod;

    public EqualsOnlyComparisonStrategy() {
        this.equalsValueProviderMethod = null;
    }

    public EqualsOnlyComparisonStrategy(String equalsValueProviderMethod) {
        Assert.hasText(equalsValueProviderMethod, "equalsValueProviderMethod");
        this.equalsValueProviderMethod = equalsValueProviderMethod;
    }

    @Override
    public void compare(DiffNode node, Class<?> type, Object working, Object base) {
        boolean result;
        if (this.equalsValueProviderMethod != null) {
            Object workingValue = EqualsOnlyComparisonStrategy.access(working, this.equalsValueProviderMethod);
            Object baseValue = EqualsOnlyComparisonStrategy.access(base, this.equalsValueProviderMethod);
            result = Objects.isEqual(workingValue, baseValue);
        } else {
            result = Objects.isEqual(working, base);
        }
        if (result) {
            node.setState(DiffNode.State.UNTOUCHED);
        } else {
            node.setState(DiffNode.State.CHANGED);
        }
    }

    private static Object access(Object target, String methodName) {
        if (target == null) {
            return null;
        }
        try {
            Method method = target.getClass().getMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return method.invoke(target, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw Exceptions.escalate(e);
        }
        catch (InvocationTargetException e) {
            throw Exceptions.escalate(e);
        }
        catch (IllegalAccessException e) {
            throw Exceptions.escalate(e);
        }
    }
}

