/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.config.io;

import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.Slf4jLevel;
import de.flapdoodle.embed.process.io.StreamProcessor;
import org.slf4j.Logger;

public class ProcessOutput {
    private final StreamProcessor output;
    private final StreamProcessor error;
    private final StreamProcessor commands;

    public ProcessOutput(StreamProcessor output, StreamProcessor error, StreamProcessor commands) {
        this.output = output;
        this.error = error;
        this.commands = commands;
    }

    public StreamProcessor getOutput() {
        return this.output;
    }

    public StreamProcessor getError() {
        return this.error;
    }

    public StreamProcessor getCommands() {
        return this.commands;
    }

    public static ProcessOutput getDefaultInstance(String label) {
        return new ProcessOutput(Processors.namedConsole("[" + label + " output]"), Processors.namedConsole("[" + label + " error]"), Processors.console());
    }

    public static ProcessOutput getDefaultInstanceSilent() {
        return new ProcessOutput(Processors.silent(), Processors.silent(), Processors.silent());
    }

    public static ProcessOutput getInstance(String label, Logger logger) {
        return new ProcessOutput(Processors.named("[" + label + " output]", Processors.logTo(logger, Slf4jLevel.INFO)), Processors.named("[" + label + " error]", Processors.logTo(logger, Slf4jLevel.ERROR)), Processors.logTo(logger, Slf4jLevel.DEBUG));
    }
}

