/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.util;

public class FSTMap {
    public static final int INIT_SIZ = 65536;
    final int GAP = 4;
    Object[] keys;
    int[] hash;
    int siz = 0;
    int collisionIndex;
    int mask;

    public FSTMap() {
        this.allocWithSize(65536);
    }

    void allocWithSize(int siz) {
        this.siz = siz;
        int len = siz * 4 + siz * 4 / 2;
        this.keys = new Object[len * 2];
        this.hash = new int[len];
        this.mask = siz - 1;
    }

    public Object get(Object key) {
        int hc = key.hashCode();
        int hashIdx = (hc & this.mask) * 4 << 1;
        int loopCnt = 0;
        while (this.keys[hashIdx] != null) {
            int hidx2 = hashIdx >>> 1;
            if (hc == this.hash[hidx2]) {
                if (this.keys[hashIdx].equals(key)) {
                    return this.keys[hashIdx + 1];
                }
                hashIdx += 2;
                if (++loopCnt != 4) continue;
                hashIdx = this.siz * 4;
                continue;
            }
            hashIdx += 2;
            if (++loopCnt != 4) continue;
            hashIdx = this.siz * 4;
        }
        return null;
    }

    public void put(Object key, Object val) {
        int hc = key.hashCode();
        int hashIdx = (hc & this.mask) * 4 << 1;
        int loopCnt = 0;
        while (true) {
            if (this.keys[hashIdx] == null) {
                this.keys[hashIdx + 1] = val;
                this.keys[hashIdx] = key;
                this.hash[hashIdx / 2] = hc;
                return;
            }
            if (hc == this.hash[hashIdx / 2]) {
                if (this.keys[hashIdx].equals(key)) {
                    this.keys[hashIdx + 1] = val;
                    return;
                }
                hashIdx += 2;
                if (++loopCnt != 4) continue;
                hashIdx = this.siz * 4;
                continue;
            }
            hashIdx += 2;
            if (++loopCnt != 4) continue;
            hashIdx = this.siz * 4;
        }
    }
}

