/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.rag.content.retriever.neo4j;

import dev.langchain4j.Experimental;
import dev.langchain4j.community.data.document.graph.GraphDocument;
import dev.langchain4j.community.rag.content.retriever.neo4j.Neo4jGraph;
import dev.langchain4j.community.rag.content.retriever.neo4j.Neo4jUtils;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Experimental
public class KnowledgeGraphWriter {
    public static final String DEFAULT_ID_PROP = "id";
    public static final String DEFAULT_TEXT_PROP = "text";
    public static final String DEFAULT_LABEL = "__Entity__";
    public static final String DEFAULT_CONS_NAME = "knowledge_cons";
    public static final String DEFAULT_REL_TYPE = "HAS_ENTITY";
    final String label;
    final String relType;
    final String sanitizedLabel;
    final String sanitizedRelType;
    final String constraintName;
    final String idProperty;
    final String sanitizedIdProperty;
    final String textProperty;
    final String sanitizedTextProperty;
    private final Neo4jGraph graph;

    public KnowledgeGraphWriter(Neo4jGraph graph, String idProperty, String label, String textProperty, String relType, String constraintName) {
        this.graph = (Neo4jGraph)ValidationUtils.ensureNotNull((Object)graph, (String)"graph");
        this.label = (String)Utils.getOrDefault((Object)label, (Object)DEFAULT_LABEL);
        this.relType = (String)Utils.getOrDefault((Object)relType, (Object)DEFAULT_REL_TYPE);
        this.idProperty = (String)Utils.getOrDefault((Object)idProperty, (Object)DEFAULT_ID_PROP);
        this.textProperty = (String)Utils.getOrDefault((Object)textProperty, (Object)DEFAULT_TEXT_PROP);
        this.constraintName = (String)Utils.getOrDefault((Object)constraintName, (Object)DEFAULT_CONS_NAME);
        this.sanitizedLabel = Neo4jUtils.sanitizeOrThrows(this.label, "label");
        this.sanitizedRelType = Neo4jUtils.sanitizeOrThrows(this.relType, "relType");
        this.sanitizedIdProperty = Neo4jUtils.sanitizeOrThrows(this.idProperty, "idProperty");
        this.sanitizedTextProperty = Neo4jUtils.sanitizeOrThrows(this.textProperty, "textProperty");
        this.createConstraint();
    }

    public static Builder builder() {
        return new Builder();
    }

    private void createConstraint() {
        String constraintQuery = String.format("CREATE CONSTRAINT %s IF NOT EXISTS FOR (b:%s) REQUIRE b.%s IS UNIQUE;", this.constraintName, this.sanitizedLabel, this.sanitizedIdProperty);
        this.graph.executeWrite(constraintQuery);
        this.graph.refreshSchema();
    }

    public void addGraphDocuments(List<GraphDocument> graphDocuments, boolean includeSource) {
        for (GraphDocument graphDoc : graphDocuments) {
            Document source = graphDoc.source();
            HashMap<String, Object> nodeParams = new HashMap<String, Object>();
            nodeParams.put("data", graphDoc.nodes().stream().map(Neo4jUtils::toMap).toList());
            if (includeSource) {
                HashMap<String, String> metadata = new HashMap<String, String>(Map.copyOf(source.metadata().toMap()));
                if (!metadata.containsKey(this.idProperty)) {
                    metadata.put(this.idProperty, Neo4jUtils.generateMD5(source.text()));
                }
                Map<String, String> document = Map.of("metadata", metadata, DEFAULT_TEXT_PROP, source.text());
                nodeParams.put("document", document);
            }
            String nodeImportQuery = this.getNodeImportQuery(includeSource);
            this.graph.executeWrite(nodeImportQuery, nodeParams);
            List<Map> relData = graphDoc.relationships().stream().map(rel -> Map.of("source", rel.sourceNode().id(), "source_label", rel.sourceNode().type(), "target", rel.targetNode().id(), "target_label", rel.targetNode().type(), "type", rel.type().replace(" ", "_").toUpperCase())).toList();
            String relImportQuery = this.getRelImportQuery();
            this.graph.executeWrite(relImportQuery, Map.of("data", relData));
        }
    }

    private String getNodeImportQuery(boolean includeSource) {
        String includeDocsQuery = this.getIncludeDocsQuery(includeSource);
        String withDocsRel = includeSource ? String.format("MERGE (d)-[:%s]->(source) ", this.relType) : "";
        return includeDocsQuery + "UNWIND $data AS row " + String.format("MERGE (source:%1$s {%2$s: row.id}) ", this.sanitizedLabel, this.sanitizedIdProperty) + withDocsRel + "WITH source, row SET source:$(row.type) RETURN count(*) as total";
    }

    private String getIncludeDocsQuery(boolean includeSource) {
        if (!includeSource) {
            return "";
        }
        return String.format("MERGE (d:Document {%1$s: $document.metadata.%1$s})\nSET d.%2$s = $document.text\nSET d += $document.metadata\nWITH d\n", this.sanitizedIdProperty, this.sanitizedTextProperty);
    }

    private String getRelImportQuery() {
        return String.format("UNWIND $data AS row\nMERGE (source:%1$s {%2$s: row.source})\nMERGE (target:%1$s {%2$s: row.target})\nWITH source, target, row\nMERGE (source)-[rel:$(toString(row.type) + '')]->(target)\nRETURN distinct 'done'\n", this.sanitizedLabel, this.sanitizedIdProperty);
    }

    public static class Builder {
        private String label;
        private String idProperty;
        private String textProperty;
        private String relType;
        private String constraintName;
        private Neo4jGraph graph;

        public Builder graph(Neo4jGraph graph) {
            this.graph = graph;
            return this;
        }

        public Builder idProperty(String idProperty) {
            this.idProperty = idProperty;
            return this;
        }

        public Builder textProperty(String textProperty) {
            this.textProperty = textProperty;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder relType(String relType) {
            this.relType = relType;
            return this;
        }

        public Builder constraintName(String constraintName) {
            this.constraintName = constraintName;
            return this;
        }

        public KnowledgeGraphWriter build() {
            return new KnowledgeGraphWriter(this.graph, this.idProperty, this.label, this.textProperty, this.relType, this.constraintName);
        }
    }
}

