/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.store.embedding.neo4j;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import dev.langchain4j.store.embedding.filter.Filter;
import dev.langchain4j.store.embedding.filter.comparison.IsEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThan;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsIn;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThan;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotIn;
import dev.langchain4j.store.embedding.filter.logical.And;
import dev.langchain4j.store.embedding.filter.logical.Not;
import dev.langchain4j.store.embedding.filter.logical.Or;
import java.time.OffsetDateTime;
import java.util.Map;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.driver.internal.value.ListValue;
import org.neo4j.driver.internal.value.PointValue;

public class Neo4jFilterMapper {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static String UNSUPPORTED_FILTER_TYPE_ERROR = "Unsupported filter type: ";
    private Node node;

    private static FunctionInvocation convertToPoint(PointValue value1) {
        try {
            String s = OBJECT_MAPPER.writeValueAsString(value1.asObject());
            Map map = (Map)new JsonMapper().readValue(s, Map.class);
            return Cypher.point((MapExpression)Cypher.asExpression((Map)map));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Expression toCypherLiteral(Object value) {
        if (value instanceof OffsetDateTime) {
            return Cypher.datetime((Expression)Cypher.literalOf((Object)value.toString()));
        }
        if (value instanceof PointValue) {
            PointValue pointValue = (PointValue)value;
            return Neo4jFilterMapper.convertToPoint(pointValue);
        }
        if (value instanceof Map) {
            return Cypher.mapOf((Object[])new Object[]{value});
        }
        if (value instanceof ListValue) {
            ListValue listValue = (ListValue)value;
            return Cypher.literalOf((Object)listValue.asList());
        }
        return Cypher.literalOf((Object)value);
    }

    public Neo4jFilterMapper(Node node) {
        this.node = node;
    }

    public Condition getCondition(Filter filter) {
        if (filter instanceof IsEqualTo) {
            IsEqualTo item = (IsEqualTo)filter;
            Expression cypherLiteral = Neo4jFilterMapper.toCypherLiteral(item.key());
            Expression cypherLiteral1 = Neo4jFilterMapper.toCypherLiteral(item.comparisonValue());
            return this.node.property(cypherLiteral).eq(cypherLiteral1);
        }
        if (filter instanceof IsNotEqualTo) {
            IsNotEqualTo item = (IsNotEqualTo)filter;
            Expression cypherLiteral = Neo4jFilterMapper.toCypherLiteral(item.key());
            Expression cypherLiteral1 = Neo4jFilterMapper.toCypherLiteral(item.comparisonValue());
            return this.node.property(cypherLiteral).isNotEqualTo(cypherLiteral1);
        }
        if (filter instanceof IsGreaterThan) {
            IsGreaterThan item = (IsGreaterThan)filter;
            Expression cypherLiteral = Neo4jFilterMapper.toCypherLiteral(item.key());
            Expression cypherLiteral1 = Neo4jFilterMapper.toCypherLiteral(item.comparisonValue());
            return this.node.property(cypherLiteral).gt(cypherLiteral1);
        }
        if (filter instanceof IsGreaterThanOrEqualTo) {
            IsGreaterThanOrEqualTo item = (IsGreaterThanOrEqualTo)filter;
            Expression cypherLiteral = Neo4jFilterMapper.toCypherLiteral(item.key());
            Expression cypherLiteral1 = Neo4jFilterMapper.toCypherLiteral(item.comparisonValue());
            return this.node.property(cypherLiteral).gte(cypherLiteral1);
        }
        if (filter instanceof IsLessThan) {
            IsLessThan item = (IsLessThan)filter;
            Expression cypherLiteral = Neo4jFilterMapper.toCypherLiteral(item.key());
            Expression cypherLiteral1 = Neo4jFilterMapper.toCypherLiteral(item.comparisonValue());
            return this.node.property(cypherLiteral).lt(cypherLiteral1);
        }
        if (filter instanceof IsLessThanOrEqualTo) {
            IsLessThanOrEqualTo item = (IsLessThanOrEqualTo)filter;
            Expression cypherLiteral = Neo4jFilterMapper.toCypherLiteral(item.key());
            Expression cypherLiteral1 = Neo4jFilterMapper.toCypherLiteral(item.comparisonValue());
            return this.node.property(cypherLiteral).lte(cypherLiteral1);
        }
        if (filter instanceof IsIn) {
            IsIn item = (IsIn)filter;
            return this.mapIn(item);
        }
        if (filter instanceof IsNotIn) {
            IsNotIn item = (IsNotIn)filter;
            return this.mapNotIn(item);
        }
        if (filter instanceof And) {
            And item = (And)filter;
            return this.mapAnd(item);
        }
        if (filter instanceof Not) {
            Not item = (Not)filter;
            return this.mapNot(item);
        }
        if (filter instanceof Or) {
            Or item = (Or)filter;
            return this.mapOr(item);
        }
        throw new UnsupportedOperationException(UNSUPPORTED_FILTER_TYPE_ERROR + filter.getClass().getName());
    }

    public Condition mapIn(IsIn filter) {
        Expression cypherLiteral = Neo4jFilterMapper.toCypherLiteral(filter.key());
        Expression cypherLiteral1 = Neo4jFilterMapper.toCypherLiteral(filter.comparisonValues());
        return Cypher.includesAny((Expression)this.node.property(cypherLiteral), (Expression)cypherLiteral1);
    }

    public Condition mapNotIn(IsNotIn filter) {
        Expression cypherLiteral = Neo4jFilterMapper.toCypherLiteral(filter.key());
        Expression cypherLiteral1 = Neo4jFilterMapper.toCypherLiteral(filter.comparisonValues());
        Condition condition1 = Cypher.includesAny((Expression)this.node.property(cypherLiteral), (Expression)cypherLiteral1);
        return Cypher.not((Condition)condition1);
    }

    private Condition mapAnd(And filter) {
        Condition left = this.getCondition(filter.left());
        Condition right = this.getCondition(filter.right());
        return left.and(right);
    }

    private Condition mapOr(Or filter) {
        Condition left = this.getCondition(filter.left());
        Condition right = this.getCondition(filter.right());
        return left.or(right);
    }

    private Condition mapNot(Not filter) {
        Condition expression = this.getCondition(filter.expression());
        return Cypher.not((Condition)expression);
    }
}

