/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.dashscope;

import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.aigc.generation.GenerationUsage;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationResult;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationUsage;
import com.alibaba.dashscope.tools.ToolCallBase;
import com.alibaba.dashscope.tools.ToolCallFunction;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.dashscope.QwenHelper;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class QwenStreamingResponseBuilder {
    private final StringBuilder generatedContent = new StringBuilder();
    private final Map<Integer, ToolExecutionRequestBuilder> indexToToolExecutionRequestBuilder = new ConcurrentHashMap<Integer, ToolExecutionRequestBuilder>();
    private Integer inputTokenCount;
    private Integer outputTokenCount;
    private FinishReason finishReason;

    public String append(GenerationResult partialResponse) {
        FinishReason finishReason;
        if (partialResponse == null) {
            return null;
        }
        GenerationUsage usage = partialResponse.getUsage();
        if (usage != null) {
            this.inputTokenCount = usage.getInputTokens();
            this.outputTokenCount = usage.getOutputTokens();
        }
        if ((finishReason = QwenHelper.finishReasonFrom(partialResponse)) != null) {
            this.finishReason = finishReason;
        }
        if (QwenHelper.hasAnswer(partialResponse)) {
            String partialContent = QwenHelper.answerFrom(partialResponse);
            this.generatedContent.append(partialContent);
            return partialContent;
        }
        if (QwenHelper.isFunctionToolCalls(partialResponse)) {
            List<ToolCallBase> toolCalls = QwenHelper.toolCallsFrom(partialResponse);
            for (int index = 0; index < toolCalls.size(); ++index) {
                ToolCallFunction.CallFunction functionCall;
                ToolCallBase toolCallBase = toolCalls.get(index);
                if (!(toolCallBase instanceof ToolCallFunction)) continue;
                ToolCallFunction toolCall = (ToolCallFunction)toolCallBase;
                ToolExecutionRequestBuilder toolExecutionRequestBuilder = this.indexToToolExecutionRequestBuilder.computeIfAbsent(index, idx -> new ToolExecutionRequestBuilder());
                if (toolCall.getId() != null) {
                    toolExecutionRequestBuilder.idBuilder.append(toolCall.getId());
                }
                if ((functionCall = toolCall.getFunction()).getName() != null) {
                    toolExecutionRequestBuilder.nameBuilder.append(functionCall.getName());
                }
                if (functionCall.getArguments() == null) continue;
                toolExecutionRequestBuilder.argumentsBuilder.append(functionCall.getArguments());
            }
        }
        return null;
    }

    public String append(MultiModalConversationResult partialResponse) {
        FinishReason finishReason;
        if (partialResponse == null) {
            return null;
        }
        MultiModalConversationUsage usage = partialResponse.getUsage();
        if (usage != null) {
            this.inputTokenCount = usage.getInputTokens();
            this.outputTokenCount = usage.getOutputTokens();
        }
        if ((finishReason = QwenHelper.finishReasonFrom(partialResponse)) != null) {
            this.finishReason = finishReason;
        }
        if (QwenHelper.hasAnswer(partialResponse)) {
            String partialContent = QwenHelper.answerFrom(partialResponse);
            this.generatedContent.append(partialContent);
            return partialContent;
        }
        return null;
    }

    public Response<AiMessage> build() {
        String text = this.generatedContent.toString();
        if (!this.indexToToolExecutionRequestBuilder.isEmpty()) {
            List toolExecutionRequests = this.indexToToolExecutionRequestBuilder.values().stream().map(it -> ToolExecutionRequest.builder().id(it.idBuilder.toString()).name(it.nameBuilder.toString()).arguments(it.argumentsBuilder.toString()).build()).collect(Collectors.toList());
            AiMessage aiMessage = Utils.isNullOrBlank((String)text) ? AiMessage.from(toolExecutionRequests) : AiMessage.from((String)text, toolExecutionRequests);
            return Response.from((Object)aiMessage, (TokenUsage)new TokenUsage(this.inputTokenCount, this.outputTokenCount), (FinishReason)this.finishReason);
        }
        if (!Utils.isNullOrBlank((String)text)) {
            return Response.from((Object)AiMessage.from((String)text), (TokenUsage)new TokenUsage(this.inputTokenCount, this.outputTokenCount), (FinishReason)this.finishReason);
        }
        return null;
    }

    private static class ToolExecutionRequestBuilder {
        private final StringBuffer idBuilder = new StringBuffer();
        private final StringBuffer nameBuilder = new StringBuffer();
        private final StringBuffer argumentsBuilder = new StringBuffer();

        private ToolExecutionRequestBuilder() {
        }
    }
}

