/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.qianfan.client;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.model.qianfan.InternalQianfanHelper;
import dev.langchain4j.model.qianfan.client.Usage;
import dev.langchain4j.model.qianfan.client.chat.ChatCompletionResponse;
import dev.langchain4j.model.qianfan.client.chat.FunctionCall;
import dev.langchain4j.model.qianfan.client.completion.CompletionResponse;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class QianfanStreamingResponseBuilder {
    private final StringBuffer contentBuilder = new StringBuffer();
    private final StringBuffer toolNameBuilder = new StringBuffer();
    private final StringBuffer toolArgumentsBuilder = new StringBuffer();
    private final Map<Integer, ToolExecutionRequestBuilder> indexToToolExecutionRequestBuilder = new ConcurrentHashMap<Integer, ToolExecutionRequestBuilder>();
    private volatile String finishReason;
    private Integer inputTokenCount;
    private Integer outputTokenCount;

    public QianfanStreamingResponseBuilder(Integer inputTokenCount) {
        this.inputTokenCount = inputTokenCount;
    }

    public void append(ChatCompletionResponse partialResponse) {
        FunctionCall functionCall;
        Usage usage;
        String content;
        if (partialResponse == null) {
            return;
        }
        String finishReason = partialResponse.getFinishReason();
        if (finishReason != null) {
            this.finishReason = finishReason;
        }
        if ((content = partialResponse.getResult()) != null) {
            this.contentBuilder.append(content);
        }
        if ((usage = partialResponse.getUsage()) != null) {
            this.inputTokenCount = usage.promptTokens();
            this.outputTokenCount = usage.completionTokens();
        }
        if ((functionCall = partialResponse.getFunctionCall()) != null) {
            if (functionCall.name() != null) {
                this.toolNameBuilder.append(functionCall.name());
            }
            if (functionCall.arguments() != null) {
                this.toolArgumentsBuilder.append(functionCall.arguments());
            }
        }
    }

    public void append(CompletionResponse partialResponse) {
        String token;
        if (partialResponse == null) {
            return;
        }
        String result = partialResponse.getResult();
        if (Utils.isNullOrBlank((String)result)) {
            return;
        }
        String finishReason = partialResponse.getFinishReason();
        if (finishReason != null) {
            this.finishReason = finishReason;
        }
        if ((token = partialResponse.getResult()) != null) {
            this.contentBuilder.append(token);
        }
    }

    public Response<AiMessage> build(Tokenizer tokenizer, boolean forcefulToolExecution) {
        String content = this.contentBuilder.toString();
        if (!content.isEmpty()) {
            return Response.from((Object)AiMessage.from((String)content), (TokenUsage)this.tokenUsage(content, tokenizer), (FinishReason)InternalQianfanHelper.finishReasonFrom(this.finishReason));
        }
        String toolName = this.toolNameBuilder.toString();
        if (!toolName.isEmpty()) {
            ToolExecutionRequest toolExecutionRequest = ToolExecutionRequest.builder().name(toolName).arguments(this.toolArgumentsBuilder.toString()).build();
            return Response.from((Object)AiMessage.from((ToolExecutionRequest[])new ToolExecutionRequest[]{toolExecutionRequest}), (TokenUsage)this.tokenUsage(Collections.singletonList(toolExecutionRequest), tokenizer, forcefulToolExecution), (FinishReason)InternalQianfanHelper.finishReasonFrom(this.finishReason));
        }
        if (!this.indexToToolExecutionRequestBuilder.isEmpty()) {
            List<ToolExecutionRequest> toolExecutionRequests = this.indexToToolExecutionRequestBuilder.values().stream().map(it -> ToolExecutionRequest.builder().id(it.idBuilder.toString()).name(it.nameBuilder.toString()).arguments(it.argumentsBuilder.toString()).build()).collect(Collectors.toList());
            return Response.from((Object)AiMessage.from(toolExecutionRequests), (TokenUsage)this.tokenUsage(toolExecutionRequests, tokenizer, forcefulToolExecution), (FinishReason)InternalQianfanHelper.finishReasonFrom(this.finishReason));
        }
        return null;
    }

    public Response<String> build(Tokenizer tokenizer) {
        String content = this.contentBuilder.toString();
        if (!content.isEmpty()) {
            return Response.from((Object)content, (TokenUsage)this.tokenUsage(content, tokenizer), (FinishReason)InternalQianfanHelper.finishReasonFrom(this.finishReason));
        }
        return null;
    }

    private TokenUsage tokenUsage(String content, Tokenizer tokenizer) {
        if (tokenizer == null) {
            return null;
        }
        int outputTokenCount = tokenizer.estimateTokenCountInText(content);
        return new TokenUsage(this.inputTokenCount, Integer.valueOf(outputTokenCount));
    }

    private TokenUsage tokenUsage(List<ToolExecutionRequest> toolExecutionRequests, Tokenizer tokenizer, boolean forcefulToolExecution) {
        if (tokenizer == null) {
            return null;
        }
        int outputTokenCount = 0;
        if (forcefulToolExecution) {
            for (ToolExecutionRequest toolExecutionRequest : toolExecutionRequests) {
                outputTokenCount += tokenizer.estimateTokenCountInForcefulToolExecutionRequest(toolExecutionRequest);
            }
        } else {
            outputTokenCount = tokenizer.estimateTokenCountInToolExecutionRequests(toolExecutionRequests);
        }
        return new TokenUsage(this.inputTokenCount, Integer.valueOf(outputTokenCount));
    }

    public Response<AiMessage> build() {
        String content = this.contentBuilder.toString();
        if (!content.isEmpty()) {
            return Response.from((Object)AiMessage.from((String)content), (TokenUsage)new TokenUsage(this.inputTokenCount, this.outputTokenCount), (FinishReason)InternalQianfanHelper.finishReasonFrom(this.finishReason));
        }
        String toolName = this.toolNameBuilder.toString();
        if (!toolName.isEmpty()) {
            ToolExecutionRequest toolExecutionRequest = ToolExecutionRequest.builder().name(toolName).arguments(this.toolArgumentsBuilder.toString()).build();
            return Response.from((Object)AiMessage.from((ToolExecutionRequest[])new ToolExecutionRequest[]{toolExecutionRequest}), (TokenUsage)new TokenUsage(this.inputTokenCount, this.outputTokenCount), (FinishReason)InternalQianfanHelper.finishReasonFrom(this.finishReason));
        }
        if (!this.indexToToolExecutionRequestBuilder.isEmpty()) {
            List toolExecutionRequests = this.indexToToolExecutionRequestBuilder.values().stream().map(it -> ToolExecutionRequest.builder().id(it.idBuilder.toString()).name(it.nameBuilder.toString()).arguments(it.argumentsBuilder.toString()).build()).collect(Collectors.toList());
            return Response.from((Object)AiMessage.from(toolExecutionRequests), (TokenUsage)new TokenUsage(this.inputTokenCount, this.outputTokenCount), (FinishReason)InternalQianfanHelper.finishReasonFrom(this.finishReason));
        }
        return null;
    }

    private static class ToolExecutionRequestBuilder {
        private final StringBuffer idBuilder = new StringBuffer();
        private final StringBuffer nameBuilder = new StringBuffer();
        private final StringBuffer argumentsBuilder = new StringBuffer();

        private ToolExecutionRequestBuilder() {
        }
    }
}

