/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.qianfan.client;

import dev.langchain4j.model.qianfan.client.Utils;
import java.io.IOException;
import java.util.function.Function;
import okhttp3.Request;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

public class SyncRequestExecutor<Response, ResponseContent> {
    private static final Logger LOG = LoggerFactory.getLogger(SyncRequestExecutor.class);
    private final Call<Response> call;
    private final Function<Response, ResponseContent> responseContentExtractor;

    SyncRequestExecutor(Call<Response> call, Function<Response, ResponseContent> responseContentExtractor) {
        this.call = call;
        this.responseContentExtractor = responseContentExtractor;
    }

    public ResponseContent execute() {
        try {
            Response retrofitResponse = this.call.execute();
            if (retrofitResponse.isSuccessful()) {
                Object response = retrofitResponse.body();
                return this.responseContentExtractor.apply(response);
            }
            throw Utils.toException(retrofitResponse);
        }
        catch (IOException var3) {
            throw new RuntimeException(var3);
        }
    }

    public String getBody(Request request) {
        if ("GET".equals(request.method())) {
            return "";
        }
        try {
            Buffer buffer = new Buffer();
            request.body().writeTo((BufferedSink)buffer);
            return buffer.readUtf8();
        }
        catch (Exception var2) {
            return "[Exception happened while reading request body. Check logs for more details.]";
        }
    }
}

