/*
 * Decompiled with CFR 0.152.
 */
package dev.tinyflow.core.node;

import com.agentsflex.core.chain.Chain;
import com.agentsflex.core.chain.Parameter;
import com.agentsflex.core.chain.RefType;
import com.agentsflex.core.chain.node.BaseNode;
import com.agentsflex.core.util.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoopNode
extends BaseNode {
    private Parameter loopVar;
    private Chain loopChain;

    public Parameter getLoopVar() {
        return this.loopVar;
    }

    public void setLoopVar(Parameter loopVar) {
        this.loopVar = loopVar;
    }

    public Chain getLoopChain() {
        return this.loopChain;
    }

    public void setLoopChain(Chain loopChain) {
        this.loopChain = loopChain;
    }

    protected Map<String, Object> execute(Chain chain) {
        List outputDefs;
        this.loopChain.setParent(chain);
        Map loopVars = this.getChainParameters(chain, Collections.singletonList(this.loopVar));
        Maps result = Maps.of();
        Object value = loopVars.get(this.loopVar.getName());
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            int index = 0;
            for (Object o : iterable) {
                HashMap<String, Object> loopParams = new HashMap<String, Object>();
                loopParams.put("loopItem", o);
                loopParams.put("index", index++);
                loopParams.putAll(loopVars);
                loopParams.putAll(chain.getMemory().getAll());
                this.loopChain.execute(loopParams);
                this.fillResult(result, this.loopChain.getMemory().getAll());
            }
        } else if (value instanceof Number) {
            int count = ((Number)value).intValue();
            for (int i = 0; i < count; ++i) {
                HashMap<String, Integer> loopParams = new HashMap<String, Integer>();
                loopParams.put("loopItem", i);
                loopParams.put("index", i);
                loopParams.putAll(loopVars);
                loopParams.putAll(chain.getMemory().getAll());
                this.loopChain.execute(loopParams);
                this.fillResult(result, this.loopChain.getMemory().getAll());
            }
        }
        if ((outputDefs = this.getOutputDefs()) != null) {
            for (Parameter outputDef : outputDefs) {
                if (outputDef.getRefType() != RefType.INPUT) continue;
                result.put((Object)outputDef.getName(), (Object)outputDef.getRef());
            }
        }
        return result;
    }

    private void fillResult(Maps result, Map<String, Object> executeResult) {
        List outputDefs = this.getOutputDefs();
        if (outputDefs != null) {
            for (Parameter outputDef : outputDefs) {
                if (outputDef.getRefType() != RefType.REF) continue;
                Object value = executeResult.get(outputDef.getRef());
                ArrayList<Object> list = (ArrayList<Object>)result.get((Object)outputDef.getName());
                if (list == null) {
                    list = new ArrayList<Object>();
                }
                list.add(value);
                result.put((Object)outputDef.getName(), list);
            }
        }
    }
}

