/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.io.File;
import java.io.PrintWriter;
import org.eigenbase.resgen.AbstractGenerator;
import org.eigenbase.resgen.ResourceDef;
import org.eigenbase.resgen.ResourceDefinition;
import org.eigenbase.resgen.ResourceGen;

class CppGenerator
extends AbstractGenerator {
    private final String className;
    private final String defaultExceptionClassName;
    private final String headerFilename;
    private final String baseClassName;
    private static final String CPP_STRING = "const std::string &";
    private static final String CPP_NUMBER = "int";
    private static final String CPP_DATE_TIME = "time_t";
    private static final String[] CPP_TYPE_NAMES = new String[]{"const std::string &", "int", "time_t", "time_t"};

    CppGenerator(File srcFile, File file, String className, String baseClassName, String defaultExceptionClassName, String headerFilename) {
        super(srcFile, file);
        assert (className.indexOf(46) < 0) : "C++ class name must not contain '.': " + className;
        this.className = className;
        this.defaultExceptionClassName = defaultExceptionClassName;
        this.headerFilename = headerFilename;
        assert (baseClassName != null);
        this.baseClassName = baseClassName;
    }

    protected String getClassName() {
        return this.className;
    }

    protected String getBaseClassName() {
        return this.baseClassName;
    }

    protected String[] getArgTypes(String message) {
        return ResourceDefinition.getArgTypes(message, CPP_TYPE_NAMES);
    }

    public void generateModule(ResourceGen generator, ResourceDef.ResourceBundle resourceList, PrintWriter pw) {
        int i;
        this.generateDoNotModifyHeader(pw);
        this.generateGeneratedByBlock(pw);
        String className = this.getClassName();
        String bundleCacheClassName = className + "BundleCache";
        String baseClass = this.getBaseClassName();
        if (resourceList.cppCommonInclude != null) {
            pw.println("// begin common include specified by " + this.getSrcFileForComment());
            pw.println("#include \"" + resourceList.cppCommonInclude + "\"");
            pw.println("// end common include specified by " + this.getSrcFileForComment());
        }
        pw.println("#include \"" + this.headerFilename + "\"");
        pw.println("#include \"ResourceBundle.h\"");
        pw.println("#include \"Locale.h\"");
        pw.println();
        pw.println("#include <map>");
        pw.println("#include <string>");
        pw.println();
        if (resourceList.cppNamespace != null) {
            pw.println("namespace " + resourceList.cppNamespace + " {");
            pw.println();
        }
        pw.println("using namespace std;");
        pw.println();
        pw.println("#define BASENAME (\"" + className + "\")");
        pw.println();
        pw.println("static " + bundleCacheClassName + " bundleCache;");
        pw.println("static string bundleLocation(\"\");");
        pw.println();
        pw.println("const " + className + " &" + className + "::instance()");
        pw.println("{");
        pw.println("    return " + className + "::instance(Locale::getDefault());");
        pw.println("}");
        pw.println();
        pw.println("const " + className + " &" + className + "::instance(const Locale &locale)");
        pw.println("{");
        pw.println("    return *makeInstance<" + className + ", " + bundleCacheClassName + ", " + bundleCacheClassName + "::iterator>(bundleCache, locale);");
        pw.println("}");
        pw.println();
        pw.println("void " + className + "::setResourceFileLocation(const string &location)");
        pw.println("{");
        pw.println("    bundleLocation = location;");
        pw.println("}");
        pw.println();
        pw.println("" + className + "::" + className + "(Locale locale)");
        pw.println("    : " + baseClass + "(BASENAME, locale, bundleLocation),");
        for (i = 0; i < resourceList.resources.length; ++i) {
            ResourceDef.Resource resource = resourceList.resources[i];
            pw.print("      _" + resource.name + "(this, \"" + resource.name + "\")");
            if (i + 1 < resourceList.resources.length) {
                pw.println(',');
                continue;
            }
            pw.println();
        }
        pw.println("{ }");
        pw.println();
        for (i = 0; i < resourceList.resources.length; ++i) {
            this.generateResource(resourceList.resources[i], pw);
        }
        if (resourceList.cppNamespace != null) {
            pw.println();
            pw.println("} // end namespace " + resourceList.cppNamespace);
        }
    }

    public void generateResource(ResourceDef.Resource resource, PrintWriter pw) {
        String text = resource.text.cdata;
        String resourceInitCap = ResourceGen.getResourceInitcap(resource);
        String parameterList = this.getParameterList(text);
        String argumentList = this.getArgumentList(text);
        pw.println("string " + this.className + "::" + resource.name + "(" + parameterList + ") const");
        pw.println("{");
        pw.println("    return _" + resource.name + ".format(" + argumentList + ");");
        pw.println("}");
        if (resource instanceof ResourceDef.Exception) {
            boolean chainExceptions;
            ResourceDef.Exception exception = (ResourceDef.Exception)resource;
            String exceptionClass = exception.cppClassName;
            if (exceptionClass == null) {
                exceptionClass = this.defaultExceptionClassName;
            }
            pw.println(exceptionClass + "* " + this.className + "::new" + resourceInitCap + "(" + parameterList + ") const");
            pw.println("{");
            pw.println("    return new " + exceptionClass + "(" + resource.name + "(" + argumentList + "));");
            pw.println("}");
            pw.println();
            boolean bl = chainExceptions = exception.cppChainExceptions != null && exception.cppChainExceptions.equalsIgnoreCase("true");
            if (chainExceptions) {
                if (parameterList.length() > 0) {
                    pw.println(exceptionClass + "* " + this.className + "::new" + resourceInitCap + "(" + parameterList + ", const " + exceptionClass + " * const prev) const");
                } else {
                    pw.println(exceptionClass + " " + this.className + "::new" + resourceInitCap + "(const " + exceptionClass + " * const prev) const");
                }
                pw.println("{");
                pw.println("    return new " + exceptionClass + "(" + resource.name + "(" + argumentList + "), prev);");
                pw.println("}");
                pw.println();
            }
        }
    }
}

