/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eigenbase.xom.CdataDef;
import org.eigenbase.xom.CommentDef;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Location;
import org.eigenbase.xom.NodeDef;
import org.eigenbase.xom.TextDef;
import org.eigenbase.xom.WrapperElementDef;
import org.eigenbase.xom.XMLOutput;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;

public abstract class ElementDef
implements NodeDef,
Serializable,
Cloneable {
    public static Class getElementClass(DOMWrapper wrapper, Class enclosure, String prefix) throws XOMException {
        if (enclosure == null) {
            return null;
        }
        if (wrapper.getType() != 2) {
            throw new XOMException("DOMWrapper must be of ELEMENT type.");
        }
        String tag = wrapper.getTagName();
        if (prefix == null) {
            prefix = "";
        } else if (!tag.startsWith(prefix)) {
            throw new XOMException("Element names must start \"" + prefix + "\": " + tag + " is invalid.");
        }
        String className = tag.substring(prefix.length(), tag.length());
        className = XOMUtil.capitalize(className);
        Class<?> elemClass = null;
        try {
            elemClass = Class.forName(enclosure.getName() + "$" + className);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        return elemClass;
    }

    public static NodeDef constructElement(DOMWrapper wrapper, Class elemClass) throws XOMException {
        Constructor<?>[] constructors = elemClass.getDeclaredConstructors();
        Constructor<?> elemConstructor = null;
        for (int i = 0; i < constructors.length; ++i) {
            Class<?>[] params = constructors[i].getParameterTypes();
            if (params.length != 1 || params[0] != DOMWrapper.class) continue;
            elemConstructor = constructors[i];
            break;
        }
        if (elemConstructor == null) {
            throw new XOMException("No constructor taking class DOMWrapper could be found in class " + elemClass.getName());
        }
        Object[] args = new Object[]{wrapper};
        try {
            return (ElementDef)elemConstructor.newInstance(args);
        }
        catch (InstantiationException ex) {
            throw new XOMException("Unable to instantiate object of class " + elemClass.getName() + ": " + ex.getMessage());
        }
        catch (InvocationTargetException ex) {
            Throwable target = ex.getTargetException();
            if (target instanceof XOMException) {
                throw (XOMException)target;
            }
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            throw new XOMException("Unexpected exception while instantiating object: " + target.toString());
        }
        catch (IllegalAccessException ex) {
            throw new XOMException("Unable to instantiate object of class " + elemClass.getName() + ": " + ex.getMessage());
        }
    }

    public static NodeDef constructElement(DOMWrapper wrapper, Class enclosure, String prefix) throws XOMException {
        switch (wrapper.getType()) {
            case 2: {
                Class elemClass = ElementDef.getElementClass(wrapper, enclosure, prefix);
                if (elemClass == null) {
                    return new WrapperElementDef(wrapper, enclosure, prefix);
                }
                return ElementDef.constructElement(wrapper, elemClass);
            }
            case 3: {
                return new CommentDef(wrapper.getText());
            }
            case 4: {
                return new CdataDef(wrapper.getText());
            }
            case 1: {
                return new TextDef(wrapper.getText());
            }
        }
        throw new XOMException("Unknown type: " + wrapper.getText());
    }

    public void displayXML(XMLOutput out, int indent) {
    }

    public void displayXML(XMLOutput out) {
        this.displayXML(out, 0);
    }

    public boolean displayDiff(ElementDef other, PrintWriter out, int indent) {
        return false;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public int getType() {
        return 2;
    }

    public String getText() {
        return null;
    }

    protected static void displayIndent(PrintWriter out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print("   ");
        }
    }

    protected static void displayString(PrintWriter out, String name, String value, int indent) {
        ElementDef.displayIndent(out, indent);
        if (value == null) {
            out.println(name + ": null");
        } else {
            out.println(name + ": \"" + value + "\"");
        }
    }

    protected static void displayAttribute(PrintWriter out, String name, Object value, int indent) {
        ElementDef.displayIndent(out, indent);
        if (value == null) {
            out.println(name + " = null");
        } else {
            out.println(name + " = \"" + value.toString() + "\"");
        }
    }

    protected static void displayElement(PrintWriter out, String name, ElementDef value, int indent) {
        ElementDef.displayIndent(out, indent);
        if (value == null) {
            out.println(name + ": null");
        } else {
            out.print(name + ": ");
            value.display(out, indent);
        }
    }

    protected static void displayElementArray(PrintWriter out, String name, NodeDef[] values, int indent) {
        ElementDef.displayIndent(out, indent);
        if (values == null) {
            out.println(name + ": null array");
        } else {
            out.println(name + ": array of " + values.length + " values");
            for (int i = 0; i < values.length; ++i) {
                ElementDef.displayIndent(out, indent);
                if (values[i] == null) {
                    out.println(name + "[" + i + "]: null");
                    continue;
                }
                out.print(name + "[" + i + "]: ");
                values[i].display(out, indent);
            }
        }
    }

    protected static void displayStringArray(PrintWriter out, String name, String[] values, int indent) {
        ElementDef.displayIndent(out, indent);
        if (values == null) {
            out.println(name + ": null array");
        } else {
            out.println(name + ": array of " + values.length + " values");
            for (int i = 0; i < values.length; ++i) {
                ElementDef.displayIndent(out, indent);
                if (values[i] == null) {
                    out.println(name + "[" + i + "]: null");
                    continue;
                }
                out.println(name + "[" + i + "]: " + values[i]);
            }
        }
    }

    protected static void displayXMLString(XMLOutput out, String tag, String value) {
        if (value != null) {
            out.stringTag(tag, value);
        }
    }

    protected static void displayXMLElement(XMLOutput out, ElementDef value) {
        if (value != null) {
            value.displayXML(out, 0);
        }
    }

    protected static void displayXMLElementArray(XMLOutput out, NodeDef[] values) {
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                values[i].displayXML(out, 0);
            }
        }
    }

    protected static void displayXMLStringArray(XMLOutput out, String tag, String[] values) {
        for (int i = 0; i < values.length; ++i) {
            out.stringTag(tag, values[i]);
        }
    }

    protected static boolean displayStringDiff(String name, String value1, String value2, PrintWriter out, int indent) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value2 == null) {
            if (out != null) {
                ElementDef.displayIndent(out, indent);
                out.println("String " + name + ": mismatch: " + value1.toString() + " vs null.");
            }
            return false;
        }
        if (value1 == null) {
            if (out != null) {
                ElementDef.displayIndent(out, indent);
                out.println("String " + name + ": mismatch: " + "null vs " + value2.toString() + ".");
            }
            return false;
        }
        if (value1.equals(value2)) {
            return true;
        }
        if (out != null) {
            ElementDef.displayIndent(out, indent);
            out.println("String " + name + ": mismatch: " + value1.toString() + " vs " + value2.toString() + ".");
        }
        return false;
    }

    protected static boolean displayAttributeDiff(String name, Object value1, Object value2, PrintWriter out, int indent) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value2 == null) {
            if (out != null) {
                ElementDef.displayIndent(out, indent);
                out.println("Attribute " + name + ": mismatch: " + value1.toString() + " vs null.");
            }
            return false;
        }
        if (value1 == null) {
            if (out != null) {
                ElementDef.displayIndent(out, indent);
                out.println("Attribute " + name + ": mismatch: " + "null vs " + value2.toString() + ".");
            }
            return false;
        }
        if (value1.getClass() != value2.getClass()) {
            if (out != null) {
                ElementDef.displayIndent(out, indent);
                out.println("Attribute " + name + ": class mismatch: " + value1.getClass().getName() + " vs " + value2.getClass().getName() + ".");
            }
            return false;
        }
        if (value1.equals(value2)) {
            return true;
        }
        if (out != null) {
            ElementDef.displayIndent(out, indent);
            out.println("Attribute " + name + ": mismatch: " + value1.toString() + " vs " + value2.toString() + ".");
        }
        return false;
    }

    protected static boolean displayElementDiff(String name, NodeDef value1, NodeDef value2, PrintWriter out, int indent) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value2 == null) {
            if (out != null) {
                ElementDef.displayIndent(out, indent);
                out.println("Object " + name + ": mismatch: " + "(...) vs null.");
            }
            return false;
        }
        if (value1 == null) {
            if (out != null) {
                ElementDef.displayIndent(out, indent);
                out.println("Object " + name + ": mismatch: " + "null vs (...).");
            }
            return false;
        }
        if (value1.getClass() != value2.getClass()) {
            if (out != null) {
                ElementDef.displayIndent(out, indent);
                out.println("Object " + name + ": class mismatch: " + value1.getClass().getName() + " vs " + value2.getClass().getName() + ".");
            }
            return false;
        }
        return ((ElementDef)value1).displayDiff((ElementDef)value2, out, indent);
    }

    protected static boolean displayElementArrayDiff(String name, NodeDef[] values1, NodeDef[] values2, PrintWriter out, int indent) {
        int length1 = 0;
        int length2 = 0;
        if (values1 != null) {
            length1 = values1.length;
        }
        if (values2 != null) {
            length2 = values2.length;
        }
        if (length1 != length2) {
            if (out != null) {
                ElementDef.displayIndent(out, indent);
                out.println("Array " + name + ": size mismatch: " + length1 + " vs " + length2 + ".");
            }
            return false;
        }
        boolean diff = true;
        for (int i = 0; i < length1; ++i) {
            diff = diff && ElementDef.displayElementDiff(name + "[" + i + "]", values1[i], values2[i], out, indent);
        }
        return diff;
    }

    protected static boolean displayStringArrayDiff(String name, String[] values1, String[] values2, PrintWriter out, int indent) {
        if (values1.length != values2.length) {
            if (out != null) {
                ElementDef.displayIndent(out, indent);
                out.println("Array " + name + ": size mismatch: " + values1.length + " vs " + values2.length + ".");
            }
            return false;
        }
        boolean diff = true;
        for (int i = 0; i < values1.length; ++i) {
            diff = diff && ElementDef.displayStringDiff(name + "[" + i + "]", values1[i], values2[i], out, indent);
        }
        return diff;
    }

    public String toString() {
        StringWriter strOut = new StringWriter();
        PrintWriter prOut = new PrintWriter(strOut);
        this.display(prOut, 0);
        return strOut.toString();
    }

    public String toXML() {
        StringWriter writer = new StringWriter();
        XMLOutput out = new XMLOutput(writer);
        this.displayXML(out, 0);
        return writer.toString();
    }

    public String toCompactXML() {
        StringWriter writer = new StringWriter();
        XMLOutput out = new XMLOutput(writer);
        out.setCompact(true);
        this.displayXML(out, 0);
        return writer.toString();
    }

    public String diff(ElementDef other) {
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        boolean diff = this.displayDiff(other, out, 0);
        if (!diff) {
            return writer.toString();
        }
        return null;
    }

    public boolean equals(Object other) {
        try {
            return this.displayDiff((ElementDef)other, null, 0);
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    public int hashCode() {
        return this.toXML().hashCode();
    }

    public void verifyEqual(ElementDef other) throws XOMException {
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        out.println();
        boolean diff = this.displayDiff(other, out, 1);
        out.println();
        if (!diff) {
            throw new XOMException("Element definition mismatch: " + writer.toString());
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        try {
            return this.deepCopy();
        }
        catch (XOMException ex) {
            throw new CloneNotSupportedException("Unable to clone " + this.getClass().getName() + ": " + ex.toString());
        }
    }

    public ElementDef deepCopy() throws XOMException {
        try {
            ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
            ObjectOutputStream objOut = new ObjectOutputStream(byteBuffer);
            objOut.writeObject(this);
            objOut.flush();
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteBuffer.toByteArray());
            ObjectInputStream objIn = new ObjectInputStream(byteIn);
            ElementDef def = (ElementDef)objIn.readObject();
            return def;
        }
        catch (IOException ex) {
            throw new XOMException(ex, "Failed to serialize-copy ElementDef");
        }
        catch (ClassNotFoundException ex) {
            throw new XOMException(ex, "Failed to serialize-copy ElementDef");
        }
    }

    public DOMWrapper getWrapper() {
        try {
            Field field = this.getClass().getField("_def");
            return (DOMWrapper)field.get(this);
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
        catch (IllegalAccessException ex) {
            throw new Error(ex.toString() + " in getWrapper");
        }
    }

    public NodeDef[] getChildren() {
        ArrayList<NodeDef> childrenList = new ArrayList<NodeDef>();
        Field[] fields = this.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            try {
                Class<?> type = field.getType();
                if (NodeDef.class.isAssignableFrom(type)) {
                    childrenList.add((NodeDef)field.get(this));
                    continue;
                }
                if (!type.isArray() || !NodeDef.class.isAssignableFrom(type.getComponentType())) continue;
                NodeDef[] nodes = (NodeDef[])field.get(this);
                childrenList.addAll(Arrays.asList(nodes));
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error while accessing field '" + field + "'", e);
            }
        }
        return childrenList.toArray(new NodeDef[childrenList.size()]);
    }

    public void addChild(NodeDef child) throws XOMException {
        XOMUtil.addChild(this, child);
    }

    public void addChildren(NodeDef[] children) throws XOMException {
        XOMUtil.addChildren(this, children);
    }

    protected static NodeDef[] getMixedChildren_new(DOMWrapper _def, Class clazz, String prefix) throws XOMException {
        DOMWrapper[] _elts = _def.getChildren();
        int count = 0;
        block6: for (int i = 0; i < _elts.length; ++i) {
            switch (_elts[i].getType()) {
                case 2: 
                case 3: 
                case 4: {
                    ++count;
                    continue block6;
                }
            }
        }
        NodeDef[] children = new NodeDef[count];
        count = 0;
        block7: for (int i = 0; i < _elts.length; ++i) {
            switch (_elts[i].getType()) {
                case 2: 
                case 3: 
                case 4: {
                    children[count++] = ElementDef.constructElement(_elts[i], clazz, prefix);
                    continue block7;
                }
            }
        }
        return children;
    }

    protected static NodeDef[] getMixedChildren(DOMWrapper _def, Class clazz, String prefix) throws XOMException {
        DOMWrapper[] _elts = _def.getChildren();
        NodeDef[] children = new NodeDef[_elts.length];
        for (int i = 0; i < _elts.length; ++i) {
            children[i] = ElementDef.constructElement(_elts[i], clazz, prefix);
        }
        return children;
    }

    protected static ElementDef[] getElementChildren(DOMWrapper _def, Class clazz, String prefix) throws XOMException {
        DOMWrapper[] _elts = _def.getElementChildren();
        ElementDef[] children = new ElementDef[_elts.length];
        for (int i = 0; i < children.length; ++i) {
            children[i] = (ElementDef)ElementDef.constructElement(_elts[i], clazz, prefix);
        }
        return children;
    }

    public Location getLocation() {
        DOMWrapper wrapper = this.getWrapper();
        if (wrapper == null) {
            return null;
        }
        return wrapper.getLocation();
    }
}

