/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import org.eigenbase.xom.ElementDef;
import org.eigenbase.xom.NodeDef;
import org.eigenbase.xom.XMLOutput;

public class GenericDef
extends ElementDef {
    private String tagName;
    private Vector children;
    private OrderedStringMap attributes;

    public GenericDef(String tagName) {
        this.tagName = tagName;
        this.children = new Vector();
        this.attributes = new OrderedStringMap();
    }

    public void display(PrintWriter out, int indent) {
        int i;
        out.println(this.getName());
        int count = this.attributes.size();
        for (i = 0; i < count; ++i) {
            String key = this.attributes.keyAt(i);
            Object value = this.attributes.valueAt(i);
            GenericDef.displayAttribute(out, key, value.toString(), indent + 1);
        }
        count = this.children.size();
        for (i = 0; i < count; ++i) {
            ElementDef child = (ElementDef)this.children.elementAt(i);
            GenericDef.displayElement(out, "?", child, indent + 1);
        }
    }

    public void displayXML(XMLOutput out, int indent) {
        int i;
        out.beginBeginTag(this.tagName);
        int count = this.attributes.size();
        for (i = 0; i < count; ++i) {
            String key = this.attributes.keyAt(i);
            Object value = this.attributes.valueAt(i);
            out.attribute(key, value.toString());
        }
        out.endBeginTag(this.tagName);
        count = this.children.size();
        for (i = 0; i < count; ++i) {
            NodeDef child = (NodeDef)this.children.elementAt(i);
            child.displayXML(out, indent + 1);
        }
        out.endTag(this.tagName);
    }

    public int getType() {
        return 2;
    }

    public String getName() {
        return this.tagName;
    }

    public void addChild(NodeDef element) {
        this.children.addElement(element);
    }

    public NodeDef[] getChildren() {
        Object[] a = new NodeDef[this.children.size()];
        this.children.copyInto(a);
        return a;
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    private static class StringMapEntry {
        String key;
        Object value;

        StringMapEntry(String key, Object value) {
            this.key = key;
            this.value = value;
        }
    }

    private static class OrderedStringMap {
        Vector v = new Vector();
        Hashtable h = new Hashtable();

        OrderedStringMap() {
        }

        int size() {
            return this.v.size();
        }

        Object get(String key) {
            return this.h.get(key);
        }

        void put(String key, Object value) {
            if (this.h.put(key, value) != null) {
                int count = this.v.size();
                for (int i = 0; i < count; ++i) {
                    StringMapEntry entry = (StringMapEntry)this.v.elementAt(i);
                    if (!entry.key.equals(key)) continue;
                    entry.value = value;
                    return;
                }
                throw new Error("key " + key + " not found in OrderedStringMap");
            }
            this.v.addElement(new StringMapEntry(key, value));
        }

        String keyAt(int i) {
            return ((StringMapEntry)this.v.elementAt((int)i)).key;
        }

        Object valueAt(int i) {
            return ((StringMapEntry)this.v.elementAt((int)i)).value;
        }
    }
}

