/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom.wrappers;

import java.io.IOException;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.wrappers.GenericDOMParser;
import org.eigenbase.xom.wrappers.W3CDOMWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XercesDOMParser
extends GenericDOMParser {
    private DOMParser parser = new DOMParser();

    public XercesDOMParser() throws XOMException {
        this(false);
    }

    public XercesDOMParser(boolean validate) throws XOMException {
        try {
            if (!validate) {
                this.parser.setFeature("http://xml.org/sax/features/validation", false);
                this.parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
        }
        catch (SAXException e) {
            throw new XOMException(e, "Error setting up validation");
        }
        this.parser.setErrorHandler((ErrorHandler)this);
        this.document = new DocumentImpl();
    }

    protected Document parseInputSource(InputSource in) throws XOMException {
        this.prepareParse();
        try {
            this.parser.parse(in);
        }
        catch (SAXException ex) {
            this.handleErrors();
            throw new XOMException(ex, "Document parse failed");
        }
        catch (IOException ex) {
            this.handleErrors();
            throw new XOMException(ex, "Document parse failed");
        }
        this.handleErrors();
        return this.parser.getDocument();
    }

    public DOMWrapper create(String tagName) {
        Element node = this.document.createElement(tagName);
        return new W3CDOMWrapper(node, this);
    }
}

