/*
 * Decompiled with CFR 0.152.
 */
package es.moki.ratelimitj.core.limiter.request;

import es.moki.ratelimitj.core.limiter.request.RequestLimitRule;
import es.moki.ratelimitj.core.limiter.request.RequestRateLimiterFactory;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRequestRateLimiterFactory<T>
implements RequestRateLimiterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRequestRateLimiterFactory.class.getClass());
    private final ConcurrentMap<Set<RequestLimitRule>, T> rateLimiterInstances = new ConcurrentHashMap<Set<RequestLimitRule>, T>();

    protected abstract T create(Set<RequestLimitRule> var1);

    protected T lookupInstance(Set<RequestLimitRule> rules) {
        Object rateLimiter = this.rateLimiterInstances.get(rules);
        if (rateLimiter == null) {
            LOG.info("creating new RequestRateLimiter");
            this.rateLimiterInstances.putIfAbsent(rules, this.create(rules));
            rateLimiter = this.rateLimiterInstances.get(rules);
        }
        return (T)rateLimiter;
    }
}

