/*
 * Decompiled with CFR 0.152.
 */
package es.moki.ratelimitj.core.limiter.request;

import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.TimeUnit;

public class RequestLimitRule {
    private final int durationSeconds;
    private final long limit;
    private final OptionalInt precision;
    private final String name;

    private RequestLimitRule(int durationSeconds, long limit) {
        this(durationSeconds, limit, OptionalInt.empty(), null);
    }

    private RequestLimitRule(int durationSeconds, long limit, OptionalInt precision, String name) {
        this.durationSeconds = durationSeconds;
        this.limit = limit;
        this.precision = precision;
        this.name = name;
    }

    public static RequestLimitRule of(int duration, TimeUnit timeUnit, long limit) {
        return new RequestLimitRule((int)timeUnit.toSeconds(duration), limit);
    }

    public RequestLimitRule withPrecision(int precision) {
        return new RequestLimitRule(this.durationSeconds, this.limit, OptionalInt.of(precision), this.name);
    }

    public RequestLimitRule withName(String name) {
        return new RequestLimitRule(this.durationSeconds, this.limit, this.precision, name);
    }

    public int getDurationSeconds() {
        return this.durationSeconds;
    }

    public OptionalInt getPrecision() {
        return this.precision;
    }

    public String getName() {
        return this.name;
    }

    public long getLimit() {
        return this.limit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestLimitRule that = (RequestLimitRule)o;
        return this.durationSeconds == that.durationSeconds && this.limit == that.limit && Objects.equals(this.precision, that.precision) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.durationSeconds, this.limit, this.precision, this.name);
    }
}

