/*
 * Decompiled with CFR 0.152.
 */
package es.moki.ratelimitj.inmemory.concurrent;

import es.moki.ratelimitj.core.limiter.concurrent.Baton;
import es.moki.ratelimitj.core.limiter.concurrent.ConcurrentLimitRule;
import es.moki.ratelimitj.core.limiter.concurrent.ConcurrentRequestLimiter;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;

public class InMemoryConcurrentRequestRateLimiter
implements ConcurrentRequestLimiter {
    private final ExpiringMap<String, Semaphore> expiringKeyMap;
    private final ConcurrentLimitRule rule;

    public InMemoryConcurrentRequestRateLimiter(ConcurrentLimitRule rule) {
        this.rule = rule;
        this.expiringKeyMap = ExpiringMap.builder().expiration(rule.getTimeoutMillis(), TimeUnit.MILLISECONDS).expirationPolicy(ExpirationPolicy.ACCESSED).build();
    }

    public Baton acquire(String key) {
        return this.acquire(key, 1);
    }

    public Baton acquire(String key, int weight) {
        Semaphore semaphore = (Semaphore)this.expiringKeyMap.computeIfAbsent((Object)key, s -> new Semaphore(this.rule.getConcurrentLimit(), false));
        if (semaphore.tryAcquire(weight)) {
            return new InMemoryBaton(semaphore, weight);
        }
        return new InMemoryBaton(weight);
    }

    private static class InMemoryBaton
    implements Baton {
        private final Semaphore semaphore;
        private final int weight;
        private boolean acquired;

        InMemoryBaton(Semaphore semaphore, int weight) {
            this.semaphore = semaphore;
            this.weight = weight;
            this.acquired = true;
        }

        InMemoryBaton(int weight) {
            this.semaphore = null;
            this.weight = weight;
        }

        public void release() {
            if (this.semaphore == null) {
                throw new IllegalStateException();
            }
            this.semaphore.release(this.weight);
        }

        public boolean hasAcquired() {
            return this.acquired;
        }

        public <T> Optional<T> get(Supplier<T> action) {
            if (!this.acquired) {
                return Optional.empty();
            }
            try {
                Optional<T> optional = Optional.of(action.get());
                return optional;
            }
            finally {
                this.release();
                this.acquired = false;
            }
        }

        public void doAction(Runnable action) {
            if (!this.acquired) {
                return;
            }
            try {
                action.run();
            }
            finally {
                this.release();
                this.acquired = false;
            }
        }
    }
}

