/*
 * Decompiled with CFR 0.152.
 */
package es.moki.ratelimitj.inmemory.request;

import de.jkeylockmanager.manager.KeyLockManager;
import de.jkeylockmanager.manager.KeyLockManagers;
import es.moki.ratelimitj.core.RateLimitUtils;
import es.moki.ratelimitj.core.limiter.request.RequestLimitRule;
import es.moki.ratelimitj.core.limiter.request.RequestRateLimiter;
import es.moki.ratelimitj.core.time.SystemTimeSupplier;
import es.moki.ratelimitj.core.time.TimeSupplier;
import es.moki.ratelimitj.inmemory.request.SavedKey;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class InMemorySlidingWindowRequestRateLimiter
implements RequestRateLimiter {
    private static final Logger LOG = LoggerFactory.getLogger(InMemorySlidingWindowRequestRateLimiter.class);
    private final Set<RequestLimitRule> rules;
    private final TimeSupplier timeSupplier;
    private final ExpiringMap<String, ConcurrentMap<String, Long>> expiringKeyMap;
    private final KeyLockManager lockManager = KeyLockManagers.newLock();

    public InMemorySlidingWindowRequestRateLimiter(Set<RequestLimitRule> rules) {
        this(rules, (TimeSupplier)new SystemTimeSupplier());
    }

    public InMemorySlidingWindowRequestRateLimiter(Set<RequestLimitRule> rules, TimeSupplier timeSupplier) {
        this.rules = rules;
        this.timeSupplier = timeSupplier;
        this.expiringKeyMap = ExpiringMap.builder().variableExpiration().build();
    }

    InMemorySlidingWindowRequestRateLimiter(ExpiringMap<String, ConcurrentMap<String, Long>> expiringKeyMap, Set<RequestLimitRule> rules, TimeSupplier timeSupplier) {
        this.expiringKeyMap = expiringKeyMap;
        this.rules = rules;
        this.timeSupplier = timeSupplier;
    }

    public boolean overLimitWhenIncremented(String key) {
        return this.overLimitWhenIncremented(key, 1);
    }

    public boolean overLimitWhenIncremented(String key, int weight) {
        return this.eqOrGeLimit(key, weight, true);
    }

    public boolean geLimitWhenIncremented(String key) {
        return this.geLimitWhenIncremented(key, 1);
    }

    public boolean geLimitWhenIncremented(String key, int weight) {
        return this.eqOrGeLimit(key, weight, false);
    }

    public boolean resetLimit(String key) {
        return this.expiringKeyMap.remove((Object)key) != null;
    }

    private ConcurrentMap<String, Long> getMap(String key, int longestDuration) {
        return (ConcurrentMap)this.lockManager.executeLocked((Object)key, () -> {
            ConcurrentHashMap keyMap = (ConcurrentHashMap)this.expiringKeyMap.get((Object)key);
            if (keyMap == null) {
                keyMap = new ConcurrentHashMap();
                this.expiringKeyMap.put((Object)key, keyMap, ExpirationPolicy.CREATED, (long)longestDuration, TimeUnit.SECONDS);
            }
            return keyMap;
        });
    }

    private boolean eqOrGeLimit(String key, int weight, boolean strictlyGreater) {
        Objects.requireNonNull(key, "key cannot be null");
        Objects.requireNonNull(this.rules, "rules cannot be null");
        if (this.rules.isEmpty()) {
            throw new IllegalArgumentException("at least one rule must be provided");
        }
        long now = this.timeSupplier.get();
        int longestDurationSeconds = this.rules.stream().map(RequestLimitRule::getDurationSeconds).reduce(Integer::max).orElse(0);
        ArrayList<SavedKey> savedKeys = new ArrayList<SavedKey>(this.rules.size());
        ConcurrentMap<String, Long> keyMap = this.getMap(key, longestDurationSeconds);
        boolean geLimit = false;
        for (RequestLimitRule rule : this.rules) {
            Long cur;
            SavedKey savedKey = new SavedKey(now, rule.getDurationSeconds(), rule.getPrecision());
            savedKeys.add(savedKey);
            Long oldTs = (Long)keyMap.get(savedKey.tsKey);
            oldTs = oldTs != null ? oldTs : savedKey.trimBefore;
            if (oldTs > now) {
                return true;
            }
            long decr = 0L;
            ArrayList<String> dele = new ArrayList<String>();
            long trim = Math.min(savedKey.trimBefore, oldTs + savedKey.blocks);
            for (long oldBlock = oldTs.longValue(); oldBlock == trim - 1L; ++oldBlock) {
                String bkey = savedKey.countKey + oldBlock;
                Long bcount = (Long)keyMap.get(bkey);
                if (bcount == null) continue;
                decr += bcount.longValue();
                dele.add(bkey);
            }
            if (!dele.isEmpty()) {
                dele.forEach(keyMap::remove);
                long decrement = decr;
                cur = keyMap.compute(savedKey.countKey, (k, v) -> v - decrement);
            } else {
                cur = (Long)keyMap.get(savedKey.countKey);
            }
            long count = (Long)RateLimitUtils.coalesce((Object)cur, (Object)0L) + (long)weight;
            if (count > rule.getLimit()) {
                return true;
            }
            if (strictlyGreater || count != rule.getLimit()) continue;
            geLimit = true;
        }
        if (weight != 0) {
            for (SavedKey savedKey : savedKeys) {
                keyMap.put(savedKey.tsKey, savedKey.trimBefore);
                Long computedCountKeyValue = keyMap.compute(savedKey.countKey, (k, v) -> (Long)RateLimitUtils.coalesce((Object)v, (Object)0L) + (long)weight);
                Long computedCountKeyBlockIdValue = keyMap.compute(savedKey.countKey + savedKey.blockId, (k, v) -> (Long)RateLimitUtils.coalesce((Object)v, (Object)0L) + (long)weight);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{} {}={}", new Object[]{key, savedKey.countKey, computedCountKeyValue});
                LOG.debug("{} {}={}", new Object[]{key, savedKey.countKey + savedKey.blockId, computedCountKeyBlockIdValue});
            }
        }
        return geLimit;
    }
}

