/*
 * Decompiled with CFR 0.152.
 */
package com.taiping.ESBToolkit;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.taiping.common.JsonUtils;
import com.taiping.common.LogUtils;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.form.Form;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;

public class HttpClient {
    public static final String ESB_REQUEST_ID = "TP-REQUEST-ID";
    public static final String ESB_SERVICE_ID = "TP-SERVICE-ID";
    public static final String ESB_APP_ID = "TP-APP-ID";
    public static final String ESB_ACCESS_TOKEN = "TP-ACCESS-TOKEN";
    public static final String ESB_REQUEST_TIME = "TP-REQUEST-TIME";
    public static final String ESB_REQUEST_HASH = "TP-REQUEST-HASH";
    public static final String ESB_REQUEST_EXT = "TP-REQUEST-EXT";
    private static final String ENCODING = "UTF-8";
    private static final String APPLICATION_JSON = "application/json";
    private static final String APPLICATION_XML = "text/xml";
    private static final String APPLICATION_FORM = "application/x-www-form-urlencoded";
    private static final long defaultReciveTimeout = 60000L;
    private static long reciveTimeout;

    public static void setReciveTimeout(long timeout) {
        reciveTimeout = timeout;
    }

    public static void setDefaultTimeout() {
        reciveTimeout = 60000L;
        System.out.println("HttpClient default reciveTimeout is: " + reciveTimeout);
    }

    private static WebClient createClient(String url, List<Object> providers) {
        WebClient client = providers != null && providers.size() > 0 ? WebClient.create((String)url, providers) : WebClient.create((String)url);
        ClientConfiguration config = WebClient.getConfig((Object)client);
        config.getHttpConduit().getClient().setReceiveTimeout(reciveTimeout);
        return client;
    }

    private static WebClient createClient(String url) {
        return HttpClient.createClient(url, null);
    }

    public static Object postJson(String url, Object o) {
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new JacksonJsonProvider());
        WebClient client = HttpClient.createClient(url, providers);
        Object res = client.accept(new String[]{APPLICATION_JSON}).type(APPLICATION_JSON).post(o, o.getClass());
        return res;
    }

    public static Response postXML(String url, Object o) {
        WebClient client = HttpClient.createClient(url);
        Response res = client.accept(new String[]{APPLICATION_XML}).type(APPLICATION_XML).post(o);
        return res;
    }

    public static Response postXML(String url, Object o, Map<String, String> addHeaders) {
        WebClient client = HttpClient.createClient(url);
        HttpClient.addHeaders(client, addHeaders);
        Response res = client.accept(new String[]{APPLICATION_XML}).type(APPLICATION_XML).post(o);
        return res;
    }

    public static Object postXML(String url, Object o, Class<?> clazz) {
        WebClient client = HttpClient.createClient(url);
        Object res = client.accept(new String[]{APPLICATION_XML}).type(APPLICATION_XML).post(o, clazz);
        return res;
    }

    public static Object postXML(String url, Object o, Class<?> clazz, Map<String, String> addHeaders) {
        WebClient client = HttpClient.createClient(url);
        HttpClient.addHeaders(client, addHeaders);
        Object res = client.accept(new String[]{APPLICATION_XML}).type(APPLICATION_XML).post(o, clazz);
        return res;
    }

    public static Object getXML(String url, Class<?> clazz) {
        WebClient client = HttpClient.createClient(url);
        Object obj = client.accept(new String[]{APPLICATION_XML}).get(clazz);
        return obj;
    }

    public static Object getXML(String url, Class<?> clazz, Map<String, String> addHeaders) {
        WebClient client = HttpClient.createClient(url);
        HttpClient.addHeaders(client, addHeaders);
        Object obj = client.accept(new String[]{APPLICATION_XML}).get(clazz);
        return obj;
    }

    public static Object getJson(String url, Class<?> clazz) {
        WebClient client = HttpClient.createClient(url);
        Object obj = client.accept(new String[]{APPLICATION_JSON}).get(clazz);
        return obj;
    }

    public static Object getJson(String url, Class<?> clazz, Map<String, String> addHeaders) {
        WebClient client = HttpClient.createClient(url);
        HttpClient.addHeaders(client, addHeaders);
        Object obj = client.accept(new String[]{APPLICATION_JSON}).get(clazz);
        return obj;
    }

    public static Response postXML(String url, Object o, String xmlStr) {
        String toPostXML = HttpClient.writeXML(o, xmlStr);
        WebClient client = HttpClient.createClient(url);
        Response res = client.post((Object)toPostXML);
        return res;
    }

    public static Response postFormRequest(String url, Map<String, String> formValues, Map<String, String> addHeaders) {
        WebClient client = HttpClient.createClient(url);
        Form form = new Form();
        HttpClient.addHeaders(client, addHeaders);
        Set<String> keys = formValues.keySet();
        for (String key : keys) {
            form.set(key, (Object)formValues.get(key));
        }
        return client.form(form);
    }

    public static <T> T postForm(String url, Map<String, String> formValues, Map<String, String> addHeaders, Class clazz) {
        Response res = HttpClient.postFormRequest(url, formValues, addHeaders);
        return (T)res.readEntity(clazz);
    }

    public static <T> T postForm(String url, Map<String, String> formValues, Class clazz) {
        Response res = HttpClient.postFormRequest(url, formValues, null);
        return (T)res.readEntity(clazz);
    }

    private static void addHeaders(WebClient client, Map<String, String> addHeaders) {
        if (addHeaders != null) {
            Set<String> keys = addHeaders.keySet();
            for (String key : keys) {
                client.header(key, new Object[]{addHeaders.get(key)});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> void postLog(String url, T logObj) {
        AsyncHttpClient client = new AsyncHttpClient();
        try {
            ((AsyncHttpClient.BoundRequestBuilder)client.preparePost(url).setHeader("Content-Type", APPLICATION_JSON).setHeader("Accept", APPLICATION_JSON).setBodyEncoding(ENCODING)).setBody(JsonUtils.object2json(logObj)).execute((AsyncHandler)new AsyncCompletionHandler<Integer>(){

                public Integer onCompleted(com.ning.http.client.Response response) throws Exception {
                    return response.getStatusCode();
                }
            });
        }
        catch (IllegalArgumentException e) {
            LogUtils.error(HttpClient.class, e);
            e.printStackTrace();
        }
        catch (IOException e) {
            LogUtils.error(HttpClient.class, e);
            e.printStackTrace();
        }
        finally {
            client.close();
        }
    }

    public static HttpResponse postXMl(String url, Map<String, String> posMap) throws ParseException, Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        ArrayList<BasicNameValuePair> namePairs = new ArrayList<BasicNameValuePair>();
        HttpPost httppost = new HttpPost(url);
        for (Map.Entry<String, String> entry : posMap.entrySet()) {
            BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue());
            namePairs.add(pair);
        }
        httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(namePairs, ENCODING));
        HttpResponse res = client.execute((HttpUriRequest)httppost);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeXML(Object o, String xmlStr) {
        Configuration cfg = new Configuration();
        StringTemplateLoader stringLoader = new StringTemplateLoader();
        stringLoader.putTemplate("xmlTemplate", xmlStr);
        cfg.setTemplateLoader((TemplateLoader)stringLoader);
        StringWriter out = new StringWriter();
        try {
            Template template = cfg.getTemplate("xmlTemplate");
            template.process(o, (Writer)out);
        }
        catch (IOException e) {
            LogUtils.error(HttpClient.class, e);
            e.printStackTrace();
        }
        catch (TemplateException e) {
            LogUtils.error(HttpClient.class, (Exception)((Object)e));
            e.printStackTrace();
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                LogUtils.error(HttpClient.class, e);
                e.printStackTrace();
            }
        }
        return out.toString();
    }
}

