/*
 * Decompiled with CFR 0.152.
 */
package com.taiping.common;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;

public class ArithUtils {
    private static final int DEF_DIV_SCALE = 10;

    private ArithUtils() {
    }

    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2).doubleValue();
    }

    public static double sub(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).doubleValue();
    }

    public static double mul(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2).doubleValue();
    }

    public static double div(double v1, double v2) {
        return ArithUtils.div(v1, v2, 10);
    }

    public static double div(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("\u53c2\u6570scale\u5fc5\u987b\u4e3a\u6574\u6570\u4e3a\u96f6!");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, scale, 4).doubleValue();
    }

    public static double round(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("\u53c2\u6570scale\u5fc5\u987b\u4e3a\u6574\u6570\u4e3a\u96f6!");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, 4).doubleValue();
    }

    public static float convertsToFloat(double v) {
        BigDecimal b = new BigDecimal(v);
        return b.floatValue();
    }

    public static int convertsToInt(double v) {
        BigDecimal b = new BigDecimal(v);
        return b.intValue();
    }

    public static long convertsToLong(double v) {
        BigDecimal b = new BigDecimal(v);
        return b.longValue();
    }

    public static double returnMax(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.max(b2).doubleValue();
    }

    public static double returnMin(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.min(b2).doubleValue();
    }

    public static int compareTo(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.compareTo(b2);
    }

    public static int getDecimals(double number) {
        DecimalFormat decimalFormat = new DecimalFormat("#.####");
        String numberString = decimalFormat.format(number);
        if (numberString.indexOf(".") > 0) {
            return numberString.length() - String.valueOf(number).indexOf(".") - 1;
        }
        return 0;
    }

    public static int getDecimals(float number) {
        DecimalFormat decimalFormat = new DecimalFormat("#.####");
        String numberString = decimalFormat.format(number);
        if (numberString.indexOf(".") > 0) {
            return numberString.length() - String.valueOf(number).indexOf(".") - 1;
        }
        return 0;
    }

    public static int getMinute(long startTime) {
        long end = new Date().getTime();
        long ss = (end - startTime) / 1000L;
        int minuteTime = (int)ss / 60;
        return minuteTime;
    }
}

