/*
 * Decompiled with CFR 0.152.
 */
package com.taiping.common;

import java.io.Serializable;
import java.util.Date;
import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;
import org.springframework.stereotype.Component;

@Component
public class EntityInterceptor
extends EmptyInterceptor {
    private static final long serialVersionUID = 7319416231145791577L;
    private static final String CREATE_DATE = "createDate";
    private static final String MODIFY_DATE = "modifyDate";

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        Date createDate = new Date();
        for (int i = 0; i < propertyNames.length; ++i) {
            if (!CREATE_DATE.equals(propertyNames[i]) && !MODIFY_DATE.equals(propertyNames[i])) continue;
            state[i] = createDate;
        }
        return true;
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        Date updateDate = new Date();
        for (int i = 0; i < propertyNames.length; ++i) {
            if (!MODIFY_DATE.equals(propertyNames[i])) continue;
            currentState[i] = updateDate;
        }
        return true;
    }
}

