/*
 * Decompiled with CFR 0.152.
 */
package com.taiping.common;

import com.taiping.ESBToolkit.HttpClient;
import com.taiping.common.PropertyFileUtil;
import com.taiping.common.bean.ScIlogBusinessOperateLog;
import com.taiping.common.bean.ScIlogErrorLog;
import com.taiping.common.bean.ScIlogInterfaceLog;
import com.taiping.common.bean.ScIlogMsg;
import com.taiping.common.bean.ScIlogOperateLog;
import com.taiping.common.bean.ScIlogWebLog;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.log4j.Logger;

public class LogUtils {
    public static Queue<String> consoleLog = new LinkedList<String>();
    static Logger log;

    public static void postErrorLog(ScIlogErrorLog errorLog) {
        if (errorLog != null && errorLog.getErrorInfo() != null && errorLog.getErrorInfo().length() > 4000) {
            errorLog.setErrorInfo(errorLog.getErrorInfo().substring(0, 3999));
        }
        try {
            HttpClient.postLog(LogUtils.getProperty("/errlog"), errorLog);
        }
        catch (Exception e) {
            LogUtils.error(LogUtils.class, e);
        }
    }

    public static void postBusinessLog(ScIlogBusinessOperateLog buslog) {
        try {
            HttpClient.postLog(LogUtils.getProperty("/businessLog"), buslog);
        }
        catch (Exception e) {
            LogUtils.error(LogUtils.class, e);
        }
    }

    public static void postOperateLog(ScIlogOperateLog operLog) {
        try {
            HttpClient.postLog(LogUtils.getProperty("/operateLog"), operLog);
        }
        catch (Exception e) {
            LogUtils.error(LogUtils.class, e);
        }
    }

    public static void postMessageLog(ScIlogMsg msgLog) {
        try {
            HttpClient.postLog(LogUtils.getProperty("/messageLog"), msgLog);
        }
        catch (Exception e) {
            LogUtils.error(LogUtils.class, e);
        }
    }

    public static void postWebLog(ScIlogWebLog webLog) {
        try {
            HttpClient.postLog(LogUtils.getProperty("/webLog"), webLog);
        }
        catch (Exception e) {
            LogUtils.error(LogUtils.class, e);
        }
    }

    public static void postInterfaceLog(ScIlogInterfaceLog interfaceLog) {
        try {
            HttpClient.postLog(LogUtils.getProperty("/interfaceLog"), interfaceLog);
        }
        catch (Exception e) {
            LogUtils.error(LogUtils.class, e);
        }
    }

    public static void error(Class<?> clazz, Exception e) {
        log = Logger.getLogger((String)clazz.getName());
        log.error((Object)LogUtils.getErrorStr(e));
    }

    public static void warn(Class<?> clazz, String warn) {
        log = Logger.getLogger((String)clazz.getName());
        log.warn((Object)warn);
    }

    public static void debug(Class<?> classname, String logStr) {
        log = Logger.getLogger((String)classname.getName());
        log.debug((Object)logStr);
    }

    public static void info(Class<?> classname, String logStr) {
        log = Logger.getLogger((String)classname.getName());
        log.info((Object)logStr);
    }

    public static String getErrorStr(Exception e) {
        if (e != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            e.printStackTrace(writer);
            StringBuffer buffer = stringWriter.getBuffer();
            return buffer.toString();
        }
        return "";
    }

    public static String getProperty(String propertyKey) {
        return PropertyFileUtil.get("log.url") + propertyKey;
    }
}

