/*
 * Decompiled with CFR 0.152.
 */
package com.taiping.common;

import com.taiping.common.DateUtils;
import com.taiping.common.LinkedProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.DefaultPropertiesPersister;
import org.springframework.util.PropertiesPersister;

public class PropertyFileUtil {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static Logger logger = LoggerFactory.getLogger(PropertyFileUtil.class);
    private static Properties properties;
    private static PropertiesPersister propertiesPersister;
    private static ResourceLoader resourceLoader;
    private static Properties activePropertyFiles;
    private static String PROFILE_ID;
    public static boolean INITIALIZED;

    public static void init() throws IOException {
        String fileNames = "application-files.properties";
        PROFILE_ID = "";
        PropertyFileUtil.innerInit(fileNames);
        PropertyFileUtil.activePropertyFiles(fileNames);
        INITIALIZED = true;
    }

    public static void init(String profile) throws IOException {
        if (StringUtils.isBlank((CharSequence)profile)) {
            PropertyFileUtil.init();
        } else {
            PROFILE_ID = profile;
            String fileNames = "application-" + profile + "-files.properties";
            PropertyFileUtil.innerInit(fileNames);
        }
        INITIALIZED = true;
    }

    private static void innerInit(String fileName) throws IOException {
        String[] propFiles = PropertyFileUtil.activePropertyFiles(fileName);
        logger.debug("\u8bfb\u53d6\u5c5e\u6027\u6587\u4ef6\uff1a{}", (Object)ArrayUtils.toString((Object)propFiles));
        properties = PropertyFileUtil.loadProperties(propFiles);
        Set<Object> keySet = properties.keySet();
        for (Object key : keySet) {
            logger.debug("property: {}, value: {}", key, (Object)properties.getProperty(key.toString()));
        }
    }

    private static void doFilters() {
        logger.info("\u5f00\u59cb\u6267\u884c\u8fc7\u6ee4\u5668");
        if (properties == null) {
            logger.warn("properties\u4e3a\u7a7a\uff0c\u9000\u51fa\u5c5e\u6027\u8fc7\u6ee4\u5668\u7684\u6267\u884c\uff01\uff01\uff01");
        }
        if (PropertyFileUtil.get("sys.ver") == null) {
            String currentTimestamp = DateUtils.formatCurrentDateTime("yyyyMMddHHmmss");
            properties.setProperty("sys.ver", currentTimestamp);
            logger.info("sys.ver\u5c5e\u6027\u672a\u914d\u7f6e\uff0c\u9ed8\u8ba4\u4f7f\u7528\u5f53\u524d\u65f6\u95f4\u6233\u4f5c\u4e3a\u65f6\u95f4\u6233\u7248\u672c\u53f7:" + currentTimestamp);
        }
        logger.info("\u5b8c\u6210\u6267\u884c\u8fc7\u6ee4\u5668");
    }

    private static String[] activePropertyFiles(String fileName) throws IOException {
        logger.info("\u8bfb\u53d6" + fileName);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream resourceAsStream = loader.getResourceAsStream(fileName);
        activePropertyFiles = new LinkedProperties();
        activePropertyFiles.load(resourceAsStream);
        Set<Object> fileKeySet = activePropertyFiles.keySet();
        String[] propFiles = new String[fileKeySet.size()];
        ArrayList<Object> fileList = new ArrayList<Object>();
        fileList.addAll(activePropertyFiles.keySet());
        for (int i = 0; i < propFiles.length; ++i) {
            String fileKey = fileList.get(i).toString();
            propFiles[i] = activePropertyFiles.getProperty(fileKey);
        }
        return propFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String ... resourcesPaths) throws IOException {
        Properties props = new Properties();
        for (String location : resourcesPaths) {
            logger.debug("Loading properties file from:" + location);
            InputStream is = null;
            try {
                Resource resource = resourceLoader.getResource(location);
                is = resource.getInputStream();
                propertiesPersister.load(props, (Reader)new InputStreamReader(is, DEFAULT_ENCODING));
            }
            catch (IOException ex) {
                logger.info("Could not load properties from classpath:" + location + ": " + ex.getMessage());
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        return props;
    }

    public static Set<String> getKeys() {
        return properties.stringPropertyNames();
    }

    public static Map<String, String> getKeyValueMap() {
        Set<String> keys = PropertyFileUtil.getKeys();
        HashMap<String, String> values = new HashMap<String, String>();
        for (String key : keys) {
            values.put(key, PropertyFileUtil.get(key));
        }
        return values;
    }

    public static String get(String key) {
        String propertyValue = properties.getProperty(key);
        logger.debug("\u83b7\u53d6\u5c5e\u6027\uff1a{}\uff0c\u503c\uff1a{}", (Object)key, (Object)propertyValue);
        return propertyValue;
    }

    public static String get(String key, String defaultValue) {
        String propertyValue = properties.getProperty(key);
        String value = StringUtils.defaultString((String)propertyValue, (String)defaultValue);
        logger.debug("\u83b7\u53d6\u5c5e\u6027\uff1a{}\uff0c\u503c\uff1a{}", (Object)key, (Object)value);
        return value;
    }

    public static void add(String key, String value) {
        properties.put(key, value);
        logger.debug("\u901a\u8fc7\u65b9\u6cd5\u6dfb\u52a0\u5c5e\u6027\u5230\u5185\u5b58\uff1a{}\uff0c\u503c\uff1a{}", (Object)key, (Object)value);
    }

    public static Properties getActivePropertyFiles() {
        return activePropertyFiles;
    }

    public static String getProfile() {
        return PROFILE_ID;
    }

    static {
        propertiesPersister = new DefaultPropertiesPersister();
        resourceLoader = new DefaultResourceLoader();
        activePropertyFiles = null;
        PROFILE_ID = "";
        INITIALIZED = false;
    }
}

