/*
 * Decompiled with CFR 0.152.
 */
package com.taiping.common;

import com.taiping.common.Base64Tool;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;

public class SignUtils {
    private KeyStore keyStore;
    private String keyPasswd;
    private String keyName;

    public SignUtils(String p12File, String keyName, String password) {
        try {
            this.setKeyName(keyName);
            this.setKeyPasswd(password);
            FileInputStream fis = new FileInputStream(p12File);
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(fis, password.toCharArray());
            ((InputStream)fis).close();
            this.setKeyStore(keyStore);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String sign(String srcText) {
        String signStr = "";
        try {
            Signature sig = Signature.getInstance("SHA1WithRSA");
            Key k = this.keyStore.getKey(this.keyName, this.keyPasswd.toCharArray());
            PrivateKey privateKey = (PrivateKey)k;
            sig.initSign(privateKey);
            sig.update(srcText.getBytes("UTF-8"));
            byte[] signature = sig.sign();
            signStr = Base64Tool.encode(signature);
            System.out.println("signature:" + signStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return signStr;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyPasswd() {
        return this.keyPasswd;
    }

    public void setKeyPasswd(String keyPasswd) {
        this.keyPasswd = keyPasswd;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }
}

