/*
 * Decompiled with CFR 0.152.
 */
package com.taiping.common;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@Component
public class SpringUtils
implements ApplicationContextAware {
    public static ServletContext servletContext;
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringUtils.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static Object getBean(String name) throws BeansException {
        return applicationContext.getBean(name);
    }

    public static Object getBean(HttpServletRequest request, String beanName) {
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getSession().getServletContext());
        Object bean = ctx.getBean(beanName);
        return bean;
    }

    public static <T> Object getSpringBean(HttpServletRequest request, String beanName) {
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getSession().getServletContext());
        Object bean = ctx.getBean(beanName);
        return bean;
    }

    public static <T> Object getSpringBean(String beanName) {
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        Object bean = ctx.getBean(beanName);
        return bean;
    }

    public static Object getSpringBeanByXml(String springXmlPath, String beanName) {
        ClassPathXmlApplicationContext context;
        ClassPathXmlApplicationContext factory = context = new ClassPathXmlApplicationContext(new String[]{springXmlPath});
        Object bean = factory.getBean(beanName);
        return bean;
    }

    public static Object getSpringBeanByXml(String[] xmlPath, String beanName) {
        ClassPathXmlApplicationContext context;
        ClassPathXmlApplicationContext factory = context = new ClassPathXmlApplicationContext(xmlPath);
        Object bean = factory.getBean(beanName);
        return bean;
    }

    public static <T> Object getBeanByXml(String springXmlPath, String beanName) {
        ClassPathXmlApplicationContext context;
        ClassPathXmlApplicationContext factory = context = new ClassPathXmlApplicationContext(new String[]{springXmlPath});
        Object bean = factory.getBean(beanName);
        return bean;
    }

    public static ServletContext getServletContext() {
        return servletContext;
    }

    public static void setServletContext(ServletContext servletContext) {
        SpringUtils.servletContext = servletContext;
    }
}

