/*
 * Decompiled with CFR 0.152.
 */
package com.taiping.common;

import com.taiping.common.bean.DynamicConfig;
import com.taiping.common.bean.HtmlConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.apache.struts2.ServletActionContext;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class TemplateConfigUtil {
    public static final String CONFIG_FILE_NAME = "template.xml";

    public static List<DynamicConfig> getDynamicConfigList() {
        ArrayList<DynamicConfig> dynamicConfigList = new ArrayList<DynamicConfig>();
        File configFile = null;
        Document document = null;
        try {
            String configFilePath = new File(Thread.currentThread().getContextClassLoader().getResource("").toURI().getPath()).getParent() + "/template/" + CONFIG_FILE_NAME;
            configFile = new File(configFilePath);
            SAXReader saxReader = new SAXReader();
            document = saxReader.read(configFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Element htmlConfigElement = (Element)document.selectSingleNode("/taiping/dynamicConfig");
        Iterator iterator = htmlConfigElement.elementIterator();
        dynamicConfigList = new ArrayList();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String description = element.element("description").getTextTrim();
            String templateFilePath = element.element("templateFilePath").getTextTrim();
            DynamicConfig dynamicConfig = new DynamicConfig();
            dynamicConfig.setName(element.getName());
            dynamicConfig.setDescription(description);
            dynamicConfig.setTemplateFilePath(templateFilePath);
            dynamicConfigList.add(dynamicConfig);
        }
        return dynamicConfigList;
    }

    public static DynamicConfig getDynamicConfig(String name) {
        Document document = null;
        try {
            String configFilePath = new File(Thread.currentThread().getContextClassLoader().getResource("").toURI().getPath()).getParent() + "/template/" + CONFIG_FILE_NAME;
            File configFile = new File(configFilePath);
            SAXReader saxReader = new SAXReader();
            document = saxReader.read(configFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Element element = (Element)document.selectSingleNode("/taiping/dynamicConfig/" + name);
        String description = element.element("description").getTextTrim();
        String templateFilePath = element.element("templateFilePath").getTextTrim();
        DynamicConfig dynamicConfig = new DynamicConfig();
        dynamicConfig.setName(element.getName());
        dynamicConfig.setDescription(description);
        dynamicConfig.setTemplateFilePath(templateFilePath);
        return dynamicConfig;
    }

    public static String readTemplateFileContent(DynamicConfig dynamicConfig) {
        ServletContext servletContext = ServletActionContext.getServletContext();
        File templateFile = new File(servletContext.getRealPath(dynamicConfig.getTemplateFilePath()));
        String templateFileContent = null;
        try {
            templateFileContent = FileUtils.readFileToString((File)templateFile, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return templateFileContent;
    }

    public static String writeTemplateFileContent(DynamicConfig dynamicConfig, String templateFileContent) {
        ServletContext servletContext = ServletActionContext.getServletContext();
        File templateFile = new File(servletContext.getRealPath(dynamicConfig.getTemplateFilePath()));
        try {
            FileUtils.writeStringToFile((File)templateFile, (String)templateFileContent, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return templateFileContent;
    }

    public static List<HtmlConfig> getHtmlConfigList() {
        ArrayList<HtmlConfig> htmlConfigList = new ArrayList<HtmlConfig>();
        File configFile = null;
        Document document = null;
        try {
            String configFilePath = new File(Thread.currentThread().getContextClassLoader().getResource("").toURI().getPath()).getParent() + "/template/" + CONFIG_FILE_NAME;
            configFile = new File(configFilePath);
            SAXReader saxReader = new SAXReader();
            document = saxReader.read(configFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Element htmlConfigElement = (Element)document.selectSingleNode("/taiping/htmlConfig");
        Iterator iterator = htmlConfigElement.elementIterator();
        htmlConfigList = new ArrayList();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String description = element.element("description").getTextTrim();
            String templateFilePath = element.element("templateFilePath").getTextTrim();
            String htmlFilePath = element.element("htmlFilePath").getTextTrim();
            HtmlConfig htmlConfig = new HtmlConfig();
            htmlConfig.setName(element.getName());
            htmlConfig.setDescription(description);
            htmlConfig.setTemplateFilePath(templateFilePath);
            htmlConfig.setHtmlFilePath(htmlFilePath);
            htmlConfigList.add(htmlConfig);
        }
        return htmlConfigList;
    }

    public static HtmlConfig getHtmlConfig(String name) {
        Document document = null;
        try {
            String configFilePath = new File(Thread.currentThread().getContextClassLoader().getResource("").toURI().getPath()).getParent() + "/template/" + CONFIG_FILE_NAME;
            File configFile = new File(configFilePath);
            SAXReader saxReader = new SAXReader();
            document = saxReader.read(configFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Element element = (Element)document.selectSingleNode("/taiping/htmlConfig/" + name);
        String description = element.element("description").getTextTrim();
        String templateFilePath = element.element("templateFilePath").getTextTrim();
        String htmlFilePath = element.element("htmlFilePath").getTextTrim();
        HtmlConfig htmlConfig = new HtmlConfig();
        htmlConfig.setName(element.getName());
        htmlConfig.setDescription(description);
        htmlConfig.setTemplateFilePath(templateFilePath);
        htmlConfig.setHtmlFilePath(htmlFilePath);
        return htmlConfig;
    }

    public static String readTemplateFileContent(HtmlConfig htmlConfig) {
        ServletContext servletContext = ServletActionContext.getServletContext();
        File templateFile = new File(servletContext.getRealPath(htmlConfig.getTemplateFilePath()));
        String templateFileContent = null;
        try {
            templateFileContent = FileUtils.readFileToString((File)templateFile, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return templateFileContent;
    }

    public static String writeTemplateFileContent(HtmlConfig htmlConfig, String templateFileContent) {
        ServletContext servletContext = ServletActionContext.getServletContext();
        File templateFile = new File(servletContext.getRealPath(htmlConfig.getTemplateFilePath()));
        try {
            FileUtils.writeStringToFile((File)templateFile, (String)templateFileContent, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return templateFileContent;
    }
}

