/*
 * Decompiled with CFR 0.152.
 */
package com.taiping.common;

import com.taiping.common.Base64Tool;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class VerifySignUtils {
    private X509Certificate cert;

    public VerifySignUtils(String crtFile) {
        try {
            FileInputStream fin = null;
            DataInputStream din = null;
            fin = new FileInputStream(crtFile);
            din = new DataInputStream(fin);
            CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509");
            byte[] bytes = new byte[din.available()];
            din.readFully(bytes);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            X509Certificate cert = (X509Certificate)certificatefactory.generateCertificate(bais);
            this.setCert(cert);
            fin.close();
            din.close();
            this.setCert(cert);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean verifySign(String srcText, String signature) {
        boolean verifySignResult = false;
        try {
            Signature sig = Signature.getInstance(this.cert.getSigAlgName());
            sig.initVerify(this.cert);
            sig.update(srcText.getBytes("UTF-8"));
            byte[] sbyte = Base64Tool.decode(signature);
            verifySignResult = sig.verify(sbyte);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return verifySignResult;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public void setCert(X509Certificate cert) {
        this.cert = cert;
    }
}

