package imageServer.config;

import ueditor.ActionEnter;
import freemarker.template.TemplateModelException;
import imageServer.utils.ImageScaleImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

import javax.annotation.PostConstruct;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;


/**
 * Created by xiaoqian on 2016/8/31.
 */
@Configuration
public class WebConfig {

    private static final Logger logger = LoggerFactory.getLogger(WebConfig.class);

    private String ueditorMapping = ImageConfigVo.API_PATH+"/ueditor";

    @Autowired
    private ImageConfigVo imageConfigVo;

    @Bean
    ServletRegistrationBean ueditorServlet(){
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean(new GenericServlet() {
            @Override
            public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
                request.setCharacterEncoding( "utf-8" );
                ((HttpServletResponse)response).setHeader("Content-Type" , "text/html");
                //String rootPath = WebConfig.class.getResource("/").getPath();
                response.getWriter().write(new ActionEnter((HttpServletRequest) request, imageConfigVo.getFullSaveFilePath()).exec());
            }
        },ueditorMapping);
        return servletRegistrationBean;
    }
    @Bean
    public WebMvcConfigurerAdapter mvcConfig(final ImageConfigVo imageConfig){
        return  new WebMvcConfigurerAdapter(){
            @Override
            public void addInterceptors(InterceptorRegistry registry) {
/*                registry.addInterceptor(commonInterceptor).addPathPatterns("*//**");
                 registry.addInterceptor(loginInterceptor).addPathPatterns("*//**");*/
            }

          /*  @Override
            public void addResourceHandlers(ResourceHandlerRegistry registry) {
                registry.addResourceHandler("*//**")
                        .addResourceLocations("classpath:/META-INF/resources/"
                                , "classpath:/resources/", "classpath:/static/"
                                , "classpath:/public/","file:"+imageConfig.getSavePath())
                        .setCachePeriod(365 * 24 * 3600 * 1000);
            }*/
        };
    }

    @ConfigurationProperties(prefix = "image")
    @Bean
    ImageConfigVo imageConfig (){
        return new ImageConfigVo();
    }

    @Bean(initMethod = "init")
    ImageScaleImpl imageScale(){
        return new ImageScaleImpl();
    }

    @Autowired
    FreeMarkerConfigurer freeMarkerConfigurer;

    @PostConstruct
    void inited() throws TemplateModelException {
        if(logger.isInfoEnabled()){
            logger.info("上传服务器配置：{}",imageConfig());
        }
        freeMarkerConfigurer.getConfiguration().setSharedVariable("_imageConfig",imageConfig());
    }
}
