package imageServer.web;

import com.alibaba.fastjson.JSON;
import imageServer.config.ImageConfigVo;
import imageServer.vo.ImageUploadResponseVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLDecoder;
import java.util.List;

/**
 * Created by xiaoqian on 2016/8/31.
 */
@Controller
@RequestMapping(ImageConfigVo.API_PATH)
public class FileUploadController extends AbstractUploadAct {

    private static final Logger logger = LoggerFactory.getLogger(FileUploadController.class);

    @RequestMapping(method = RequestMethod.POST)
    @ResponseBody
    public Object upload(HttpServletRequest request, HttpServletResponse response) throws IOException {
        MultipartHttpServletRequest mrequest = ((MultipartHttpServletRequest)request);
        response.setHeader("Access-Control-Allow-Origin", "*");
//        if (request.getCharacterEncoding() == null) {
//            request.setCharacterEncoding("UTF-8");//空的时候
//        }
        List<ImageUploadResponseVo> responseVos =  uploadFiles(request,  mrequest);

        return responseVos;
    }

    @RequestMapping(value = {"textjson"}, method = RequestMethod.POST, produces="text/html; charset=UTF-8")
    @ResponseBody
    public String uploadText(HttpServletRequest request, HttpServletResponse response) throws IOException {
        MultipartHttpServletRequest mrequest = ((MultipartHttpServletRequest)request);
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Content-Type", "text/html;charset=utf-8");
//        if (request.getCharacterEncoding() == null) {
//            request.setCharacterEncoding("UTF-8");//空的时候
//        }
        List<ImageUploadResponseVo> responseVos =  uploadFiles(request,  mrequest);

        return JSON.toJSONString(responseVos);
    }

    @RequestMapping(value = {"download"}, method = RequestMethod.GET, produces="text/html; charset=UTF-8")
    public void download(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String path = (String) request.getParameter("path");
        String fileName = (String) request.getParameter("fileName");
        fileName = URLDecoder.decode(fileName, "utf-8");
        response.setContentType("application/x-download");// 设置为下载application/x-download
        response.addHeader("content-type ", "application/x-msdownload");
        response.setContentType("application/octet-stream");
        response.setHeader("content-disposition", "attachment; filename=" + transCharacter(request, fileName));//设定输出文件头

        File file = getUploadedFile(path);

        if(file != null) {
            BufferedInputStream bufferedInputStream = null;
            InputStream inputStream =null;
            BufferedOutputStream bufferedOutputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                response.addHeader("Content-Length", bufferedInputStream.available()+"");
                bufferedOutputStream = new BufferedOutputStream(response.getOutputStream());
                byte[] bytes = new byte[1024];
                while (bufferedInputStream.read(bytes) > -1) {
                    bufferedOutputStream.write(bytes);
                }
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                try {
                    bufferedInputStream.close();
                    bufferedOutputStream.flush();
                    bufferedOutputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

}
