package imageServer.web.ckeditorImgPaste;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

import imageServer.config.ImageConfigVo;

/**
 * 2018/1/30 yuweichu 用于生成报表pdf并批量压缩导出
 * 2018/2/11 yuweichu 将代码从uninogift-admin-web 复制了一份过来，稍微改了下
 * @author yuweichu
 *
 */
@Controller
@RequestMapping("/image/protocol/richText")
public class ProtocolRichTextController {
    Logger logger = LoggerFactory.getLogger(ProtocolRichTextController.class);

//    @Value("${templete.protocol.tmppath}")
//    private String tmppath;
    
    @Autowired
    protected ImageConfigVo imageConfigVo;
    
    public ImageConfigVo getImageConfigVo() {
        return imageConfigVo;
    }

    public void setImageConfigVo(ImageConfigVo imageConfigVo) {
        this.imageConfigVo = imageConfigVo;
    }
    
    private static final String FOLDER_NAME = "ckeditorpaste";
    
    //2018/2/6 ckeditor上传图片的后台
    /**
     * ckeditor图片上传
     * 
     * @Title imageUpload
     * @param request
     * @param response
     */
    @RequestMapping("/imageUpload")
    public void imageUpload(HttpServletRequest request, HttpServletResponse response) {
        //写在应用程序下/upload下
//    	String DirectoryName = tmppath;
    	String saveFilePathStr = getImageConfigVo().getFullSaveFilePath();
    	if(!saveFilePathStr.endsWith(File.separator)) {
    		saveFilePathStr = saveFilePathStr + File.separator;
    	}
    	String DirectoryName = saveFilePathStr+FOLDER_NAME+File.separator;
        try {
            ImageUploadUtil.ckeditor(request, response, DirectoryName);
        } catch (IllegalStateException e) {
            logger.error(e.getMessage(),e);
        } catch (IOException e) {
        	logger.error(e.getMessage(),e);
        }
    }
    
    /**
     * ckeditor图片黏贴
     * 
     * @Title imageUpload
     * @param request
     * @param response
     */
    @RequestMapping("/imagePaste")
    public void imagePaste(HttpServletRequest request, HttpServletResponse response) {
        //写在应用程序下/upload下
//    	String DirectoryName = tmppath;
    	String saveFilePathStr = getImageConfigVo().getFullSaveFilePath();
    	if(!saveFilePathStr.endsWith(File.separator)) {
    		saveFilePathStr = saveFilePathStr + File.separator;
    	}
    	String DirectoryName = saveFilePathStr+FOLDER_NAME+File.separator;
        try {
            ImageUploadUtil.ckeditorImgPaste(request, response, DirectoryName);
        } catch (IllegalStateException e) {
            logger.error(e.getMessage(),e);
        } catch (IOException e) {
        	logger.error(e.getMessage(),e);
        }
    }
    
    /**
     * 查看上传的文件
     * @param request
     * @param response
     */
    @RequestMapping("/uploadView/{name}")
    public void uploadBrowser(HttpServletRequest request, HttpServletResponse response,@PathVariable("name")String name) {
        //将/upload文件下指定文件名的图片返回
    	String saveFilePathStr = getImageConfigVo().getFullSaveFilePath();
    	if(!saveFilePathStr.endsWith(File.separator)) {
    		saveFilePathStr = saveFilePathStr + File.separator;
    	}
    	String DirectoryName = saveFilePathStr+FOLDER_NAME+File.separator;
    	
    	
    	String realPath = DirectoryName+name;
    	
    	//如果传来的name中没有后缀
    	String suffix = "png";
    	if(!name.contains(".")) {
    		//就通过_???来补后缀
    		if(name.contains("+")) {
    			String[] tmp = name.split("\\+");
    			if(tmp!=null && tmp.length==2) {
    				realPath = DirectoryName+name+"."+tmp[1];
    				suffix = tmp[1];
    			}
    		}
    	}
        try {
        	File file = new File(realPath);  
            //判断文件是否存在如果不存在就返回默认图标  
            if(!(file.exists() && file.canRead())) {  
//            	file = new File(tmppath+File.separator+"error.png"); 
            }
            FileInputStream inputStream = new FileInputStream(file);  
            byte[] data = new byte[(int)file.length()];  
            int length = inputStream.read(data);  
            inputStream.close();  
            response.setContentType("image/"+suffix);  
            OutputStream stream = response.getOutputStream();  
            stream.write(data);  
            stream.flush();  
            stream.close();
        }catch (Exception e) {
        	logger.error(e.getMessage(),e);
        }
    }
}
