package imageServer.web.facade;

import imageServer.config.ImageConfigVo;
import imageServer.utils.ImageScale;
import imageServer.vo.ImageUploadResponseVo;
import imageServer.web.AbstractUploadAct;
import imageServer.web.FileUploadController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.util.List;

/**
 * Created by xiaoqian on 2016/9/7.
 */
@Controller
@RequestMapping(ImageConfigVo.API_PATH)
public class JSPGouController extends AbstractUploadAct {
    private static final Logger logger = LoggerFactory.getLogger(FileUploadController.class);
    private static final String ERROR = "error";
    private static final String UPLOAD_IFRAME_UPLOAD = "/upload/iframeUpload";
    private static final String UPLOAD_IFRAME_SWITCH_UPLOAD = "/upload/iframe_switch_upload";

    @RequestMapping("/doImageCut")
    public String imageCut(String imgSrcPath, Integer imgTop, Integer imgLeft,
                           Integer imgWidth, Integer imgHeight, Integer reMinWidth,
                           Integer reMinHeight, Float imgScale, Integer uploadNum,
                           HttpServletRequest request, ModelMap model) {
        String ctx = request.getContextPath();
        imgSrcPath = imgSrcPath.substring(ctx.length());
        String real = (imgSrcPath.replace(imageConfigVo.getDomain(),""));
        File srcFile = new File( (imageConfigVo.getSavePath()+"/"+real).replaceAll("//","/"));
        model.addAttribute("uploadNum", uploadNum);
        try {
            if(imgWidth!=null){
                if (imgWidth > 0) {
                    imageScale.resizeFix(srcFile, srcFile, reMinWidth, reMinHeight,getLen(imgTop, imgScale), getLen(imgLeft,
                            imgScale), getLen(imgWidth, imgScale),getLen(imgHeight, imgScale));
                } else {
                    imageScale.resizeFix(srcFile, srcFile, reMinWidth, reMinHeight);
                }
            }else{
                model.addAttribute(ERROR, "图片不能为空");
            }
        }catch (Exception e) {
            logger.error("cut image error", e);
            model.addAttribute(ERROR, e.getMessage());
        }
        return "/upload/image_cuted";
    }

    private int getLen(int len, float imgScale) {
        return Math.round(len / imgScale);
    }

    /**
     * 兼容jspgou图片上传
     * @param uploadNum
     * @param zoomWidth
     * @param zoomHeight
     * @param request
     * @param model
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/iframeUpload",method = RequestMethod.POST)
    public String iframeUpload(
            Integer uploadNum,
            Integer zoomWidth,
            Integer zoomHeight,
            HttpServletRequest request, ModelMap model) throws IOException {
        try {
            MultipartHttpServletRequest mrequest = ((MultipartHttpServletRequest)request);
            List<ImageUploadResponseVo> responseVos =  uploadFiles(request,  mrequest);
            if(responseVos==null || responseVos.size()==0){
                model.put(ERROR,"未上传文件");
                return UPLOAD_IFRAME_UPLOAD;
            }
            ImageUploadResponseVo imageUploadResponseVo = responseVos.get(0);

            model.addAttribute("zoomWidth",zoomWidth);
            model.addAttribute("zoomHeight",zoomHeight);

            model.addAttribute("uploadPath", imageUploadResponseVo.getAbsoluteFilePath());
            model.addAttribute("uploadNum", uploadNum);
        } catch (Exception e) {
            model.addAttribute(ERROR, e.getMessage());
            logger.error("上传文件处理出错", e);
        }
        return UPLOAD_IFRAME_UPLOAD;
    }

    /**
     * 兼容jspgou图片上传
     * @param uploadNum
     * @param request
     * @param model
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/switchIframeUpload",method = RequestMethod.POST)
    public String iframeUpload(
            String fileName,
            Integer uploadNum,
            @RequestParam(value = "uploadFileSwitch", required = false) MultipartFile file,
            HttpServletRequest request, ModelMap model) throws IOException {
        try {
            MultipartHttpServletRequest mrequest = ((MultipartHttpServletRequest)request);
            List<ImageUploadResponseVo> responseVos =  uploadFiles(request,  mrequest);
            if(responseVos==null || responseVos.size()==0){
                model.put(ERROR,"未上传文件");
                return UPLOAD_IFRAME_SWITCH_UPLOAD;
            }
            ImageUploadResponseVo imageUploadResponseVo = responseVos.get(0);
            model.addAttribute("uploadPath", imageUploadResponseVo.getAbsoluteFilePath());
            model.addAttribute("uploadNum", uploadNum);
        } catch (Exception e) {
            model.addAttribute(ERROR, e.getMessage());
            logger.error("上传文件处理出错", e);
        }
        return UPLOAD_IFRAME_SWITCH_UPLOAD;
    }

    //放大图片上传
    @RequestMapping("/ampIframeUpload")
    public String ampIfameUpload(
            String fileName,
            Integer uploadNum,
            @RequestParam(value = "uploadFileAmp", required = false) MultipartFile file,
            HttpServletRequest request, ModelMap model) {
        try {
            MultipartHttpServletRequest mrequest = ((MultipartHttpServletRequest)request);
            List<ImageUploadResponseVo> responseVos =  uploadFiles(request,  mrequest);
            if(responseVos==null || responseVos.size()==0){
                model.put(ERROR,"未上传文件");
                return UPLOAD_IFRAME_SWITCH_UPLOAD;
            }
            ImageUploadResponseVo imageUploadResponseVo = responseVos.get(0);
            model.addAttribute("uploadPath", imageUploadResponseVo.getAbsoluteFilePath());
            model.addAttribute("uploadNum", uploadNum);
        } catch (Exception e) {
            model.addAttribute(ERROR, e.getMessage());
            logger.error("上传文件处理出错", e);
        }
        return "upload/iframe_amp_upload";
    }

    //放大图片上传
    @RequestMapping("/bigIframeUpload")
    public String bigIfameUpload(
            String fileName,
            Integer uploadNum,
            @RequestParam(value = "uploadFileBig", required = false) MultipartFile file,
            HttpServletRequest request, ModelMap model) {
        try {
            MultipartHttpServletRequest mrequest = ((MultipartHttpServletRequest)request);
            List<ImageUploadResponseVo> responseVos =  uploadFiles(request,  mrequest);
            if(responseVos==null || responseVos.size()==0){
                model.put(ERROR,"未上传文件");
                return UPLOAD_IFRAME_SWITCH_UPLOAD;
            }
            ImageUploadResponseVo imageUploadResponseVo = responseVos.get(0);
            model.addAttribute("uploadPath", imageUploadResponseVo.getAbsoluteFilePath());
            model.addAttribute("uploadNum", uploadNum);
        } catch (Exception e) {
            model.addAttribute(ERROR, e.getMessage());
            logger.error("上传文件处理出错", e);
        }
        return "upload/iframe_big_upload";
    }

    @RequestMapping("/imageCut")
    public String imageAreaSelect( String imgSrcPath,
                                   Integer zoomWidth, Integer zoomHeight, Integer uploadNum,
                                   HttpServletRequest request, ModelMap model) {
        model.addAttribute("imgSrcPath", imgSrcPath);
        model.addAttribute("zoomWidth", zoomWidth);
        model.addAttribute("zoomHeight", zoomHeight);
        model.addAttribute("uploadNum", uploadNum);
        return "/upload/image_area_select";
    }

    @Autowired
    ImageScale imageScale;
}
